/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.rewrite;

import com.atlassian.jgitflow.core.CoreEol;
import com.atlassian.jgitflow.core.exception.JGitFlowException;
import com.atlassian.maven.plugins.jgitflow.exception.ProjectRewriteException;
import com.atlassian.maven.plugins.jgitflow.provider.JGitFlowProvider;
import com.atlassian.maven.plugins.jgitflow.rewrite.ProjectChange;
import com.atlassian.maven.plugins.jgitflow.rewrite.ProjectChangeset;
import com.atlassian.maven.plugins.jgitflow.rewrite.ProjectRewriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.eclipse.jgit.lib.Config;
import org.jdom2.CDATA;
import org.jdom2.Comment;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.filter.ContentFilter;
import org.jdom2.filter.Filter;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.util.IteratorIterable;

@Component(role=ProjectRewriter.class)
public class MavenProjectRewriter
implements ProjectRewriter {
    private static final int POM_INDENTATION = 4;
    @Requirement
    private JGitFlowProvider jGitFlowProvider;

    @Override
    public void applyChanges(MavenProject project, ProjectChangeset changes) throws ProjectRewriteException {
        String eol = null;
        try {
            eol = CoreEol.getConfigValue((Config)this.jGitFlowProvider.gitFlow().git().getRepository().getConfig()).getEol();
        }
        catch (JGitFlowException e) {
            throw new ProjectRewriteException("Error determining proper EOL!", e);
        }
        File pomFile = project.getFile();
        if (null == pomFile || !pomFile.exists() || !pomFile.canRead()) {
            String pomPath = null == pomFile ? "null" : pomFile.getAbsolutePath();
            throw new ProjectRewriteException("pom file must be readable! " + pomPath);
        }
        DocumentDescriptor dd = this.readPom(pomFile, eol);
        Document document = dd.getDocument();
        Element root = document.getRootElement();
        boolean pomWasModified = false;
        if (pomWasModified |= this.applyAllChanges(project, root, changes.getItems())) {
            this.writePom(dd, pomFile, eol);
        }
    }

    private void writePom(DocumentDescriptor dd, File f, String eol) throws ProjectRewriteException {
        XmlStreamWriter writer = null;
        String intro = dd.getIntro();
        String outtro = dd.getOuttro();
        Document document = dd.getDocument();
        try {
            writer = WriterFactory.newXmlWriter((File)f);
            if (intro != null) {
                writer.write(intro);
            }
            Format format = Format.getRawFormat();
            format.setLineSeparator(eol);
            XMLOutputter out = new XMLOutputter(format);
            out.output(document.getRootElement(), (Writer)writer);
            if (outtro != null) {
                writer.write(outtro);
            }
        }
        catch (IOException e) {
            throw new ProjectRewriteException("Error writing pom!", e);
        }
        finally {
            IOUtil.close((Writer)writer);
        }
    }

    private boolean applyAllChanges(MavenProject project, Element root, Iterable<ProjectChange> items) throws ProjectRewriteException {
        boolean modified = false;
        for (ProjectChange change : items) {
            boolean result = change.applyChange(project, root);
            if (modified) continue;
            modified = result;
        }
        return modified;
    }

    private DocumentDescriptor readPom(File pomFile, String eol) throws ProjectRewriteException {
        String intro = null;
        String outtro = null;
        try {
            String content = ReleaseUtil.readXmlFile((File)pomFile, (String)eol);
            content = content.replaceAll("<([^!][^>]*?)\\s{2,}([^>]*?)>", "<$1 $2>");
            content = content.replaceAll("(\\s{2,}|[^\\s])/>", "$1 />");
            SAXBuilder builder = new SAXBuilder();
            Document document = builder.build((Reader)new StringReader(content));
            this.normaliseLineEndings(document, eol);
            StringWriter w = new StringWriter();
            Format format = Format.getRawFormat();
            format.setLineSeparator(eol);
            XMLOutputter out = new XMLOutputter(format);
            out.output(document.getRootElement(), (Writer)w);
            int index = content.indexOf(w.toString());
            if (index >= 0) {
                intro = content.substring(0, index);
                outtro = content.substring(index + w.toString().length());
            } else {
                String SPACE = "\\s++";
                String XML = "<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>";
                String INTSUB = "\\[(?:(?:[^\"'\\]]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+\\]";
                String DOCTYPE = "<!DOCTYPE(?:(?:[^\"'\\[>]++)|(?:\"[^\"]*+\")|(?:'[^']*+')|(?:\\[(?:(?:[^\"'\\]]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+\\]))*+>";
                String PI = "<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>";
                String COMMENT = "<!--(?:[^-]|(?:-[^-]))*+-->";
                String INTRO = "(?:(?:\\s++)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>)|(?:<!DOCTYPE(?:(?:[^\"'\\[>]++)|(?:\"[^\"]*+\")|(?:'[^']*+')|(?:\\[(?:(?:[^\"'\\]]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+\\]))*+>)|(?:<!--(?:[^-]|(?:-[^-]))*+-->)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>))*";
                String OUTRO = "(?:(?:\\s++)|(?:<!--(?:[^-]|(?:-[^-]))*+-->)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>))*";
                String POM = "(?s)((?:(?:\\s++)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>)|(?:<!DOCTYPE(?:(?:[^\"'\\[>]++)|(?:\"[^\"]*+\")|(?:'[^']*+')|(?:\\[(?:(?:[^\"'\\]]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+\\]))*+>)|(?:<!--(?:[^-]|(?:-[^-]))*+-->)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>))*)(.*?)((?:(?:\\s++)|(?:<!--(?:[^-]|(?:-[^-]))*+-->)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>))*)";
                Matcher matcher = Pattern.compile("(?s)((?:(?:\\s++)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>)|(?:<!DOCTYPE(?:(?:[^\"'\\[>]++)|(?:\"[^\"]*+\")|(?:'[^']*+')|(?:\\[(?:(?:[^\"'\\]]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+\\]))*+>)|(?:<!--(?:[^-]|(?:-[^-]))*+-->)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>))*)(.*?)((?:(?:\\s++)|(?:<!--(?:[^-]|(?:-[^-]))*+-->)|(?:<\\?(?:(?:[^\"'>]++)|(?:\"[^\"]*+\")|(?:'[^']*+'))*+>))*)").matcher(content);
                if (matcher.matches()) {
                    intro = matcher.group(1);
                    outtro = matcher.group(matcher.groupCount());
                }
            }
            return new DocumentDescriptor(document, intro, outtro);
        }
        catch (IOException e) {
            throw new ProjectRewriteException("unable to read pom!", e);
        }
        catch (JDOMException e) {
            throw new ProjectRewriteException("unable to read pom!", e);
        }
    }

    private void normaliseLineEndings(Document document, String eol) {
        Comment c;
        IteratorIterable i = document.getDescendants((Filter)new ContentFilter(8));
        while (i.hasNext()) {
            c = (Comment)i.next();
            c.setText(ReleaseUtil.normalizeLineEndings((String)c.getText(), (String)eol));
        }
        i = document.getDescendants((Filter)new ContentFilter(2));
        while (i.hasNext()) {
            c = (CDATA)i.next();
            c.setText(ReleaseUtil.normalizeLineEndings((String)c.getText(), (String)eol));
        }
    }

    private class DocumentDescriptor {
        private final Document document;
        private final String intro;
        private final String outtro;

        private DocumentDescriptor(Document document, String intro, String outtro) {
            this.document = document;
            this.intro = intro;
            this.outtro = outtro;
        }

        public Document getDocument() {
            return this.document;
        }

        public String getIntro() {
            return this.intro;
        }

        public String getOuttro() {
            return this.outtro;
        }
    }
}

