/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.tray;

import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.MainFrame;
import java.awt.Image;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TraySupport {
    private static final boolean AVAILABLE;
    private static final TraySupport INSTANCE;
    protected MainFrame mainFrame;

    public static boolean isAvailable() {
        return AVAILABLE;
    }

    public static TraySupport getInstance() {
        return INSTANCE;
    }

    public abstract void setIconImage(Image var1);

    public abstract Image getDefaultIcon();

    public abstract void displayMessage(String var1, MessageType var2);

    public void displayMessage(String message) {
        this.displayMessage(message, MessageType.NONE);
    }

    public void setMainFrame(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.updateTrayIcon();
    }

    public void updateTrayIcon() {
        if (this.mainFrame == null) {
            this.setActive(false);
        } else {
            ApplicationPreferences prefs = this.mainFrame.getApplicationPreferences();
            this.setActive(prefs.isTrayActive());
        }
    }

    public abstract void setToolTip(String var1);

    public abstract void setActive(boolean var1);

    public abstract boolean isActive();

    static {
        TraySupport instance;
        block10: {
            boolean support;
            Logger logger;
            block9: {
                logger = LoggerFactory.getLogger(TraySupport.class);
                support = false;
                try {
                    Class<?> clazz = Class.forName("java.awt.SystemTray");
                    Method method = clazz.getMethod("isSupported", new Class[0]);
                    Object result = method.invoke(null, new Object[0]);
                    if (result instanceof Boolean) {
                        support = (Boolean)result;
                    }
                }
                catch (Exception e) {
                    if (!logger.isInfoEnabled()) break block9;
                    logger.info("Exception while checking for SystemTray support. => not available", (Throwable)e);
                }
            }
            AVAILABLE = support;
            instance = null;
            if (AVAILABLE) {
                try {
                    Class<?> clazz = Class.forName("de.huxhorn.lilith.tray.impl.SystemTrayImpl");
                    Object o = clazz.newInstance();
                    if (o instanceof TraySupport) {
                        instance = (TraySupport)o;
                    } else if (logger.isErrorEnabled()) {
                        logger.error("Invalid TraySupport instance! {}", o);
                    }
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) break block10;
                    logger.error("Exception while checking for SystemTray support. => not available", (Throwable)e);
                }
            }
        }
        INSTANCE = instance;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageType {
        ERROR,
        WARNING,
        INFO,
        NONE;

    }
}

