/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.tools.formatters;

import ch.qos.logback.access.PatternLayout;
import ch.qos.logback.access.spi.AccessContext;
import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.access.spi.ServerAdapter;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.StatusManager;
import de.huxhorn.lilith.data.access.AccessEvent;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.logback.tools.ContextHelper;
import de.huxhorn.lilith.tools.formatters.Formatter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessFormatter
implements Formatter<EventWrapper<AccessEvent>> {
    private final Logger logger = LoggerFactory.getLogger(AccessFormatter.class);
    private static final String DEFAULT_PATTERN = "common";
    private PatternLayout layout;
    private String pattern;

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public String format(EventWrapper<AccessEvent> wrapper) {
        AccessEvent event;
        this.initLayout();
        if (wrapper != null && (event = (AccessEvent)wrapper.getEvent()) != null) {
            return this.layout.doLayout(this.convert(event));
        }
        return null;
    }

    private IAccessEvent convert(AccessEvent event) {
        AccessEventFoo result = null;
        if (event != null) {
            Long et;
            result = new AccessEventFoo();
            Long ts = event.getTimeStamp();
            if (ts != null) {
                result.setTimeStamp(ts);
            }
            if ((et = event.getElapsedTime()) != null) {
                result.setElapsedTime(et);
            }
            result.setRequestURI(event.getRequestURI());
            result.setRequestURL(event.getRequestURL());
            result.setRemoteHost(event.getRemoteHost());
            result.setRemoteUser(event.getRemoteUser());
            result.setProtocol(event.getProtocol());
            result.setMethod(event.getMethod());
            result.setServerName(event.getServerName());
            result.setRemoteAddr(event.getRemoteAddress());
            result.setRequestHeaderMap(event.getRequestHeaders());
            result.setResponseHeaderMap(event.getResponseHeaders());
            result.setRequestParameterMap(event.getRequestParameters());
            result.setLocalPort(event.getLocalPort());
            result.setStatusCode(event.getStatusCode());
        }
        return result;
    }

    private void initLayout() {
        if (this.layout == null) {
            this.layout = new PatternLayout();
            AccessContext context = new AccessContext();
            this.layout.setContext((Context)context);
            if (this.pattern != null) {
                this.layout.setPattern(this.pattern);
            } else {
                this.layout.setPattern(DEFAULT_PATTERN);
            }
            this.layout.start();
            int statusLevel = ContextHelper.getHighestLevel((Context)context);
            StatusManager statusManager = context.getStatusManager();
            if (statusLevel > 0) {
                List stati = statusManager.getCopyOfStatusList();
                String msg = "Error while initializing layout! " + stati;
                if (this.logger.isErrorEnabled()) {
                    this.logger.error(msg);
                }
                throw new IllegalStateException(msg);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AccessEventFoo
    implements IAccessEvent {
        private String requestURI;
        private String requestURL;
        private String remoteHost;
        private String remoteUser;
        private String remoteAddr;
        private String protocol;
        private String method;
        private String serverName;
        private Map<String, String> requestHeaderMap;
        private Map<String, String[]> requestParameterMap;
        private Map<String, String> responseHeaderMap;
        private int statusCode = -1;
        private int localPort = -1;
        private long timeStamp = 0L;
        private long elapsedTime;
        private static final String[] NA_STRING_ARRAY = new String[0];
        private static final String EMPTY = "";

        private AccessEventFoo() {
        }

        public HttpServletRequest getRequest() {
            return null;
        }

        public HttpServletResponse getResponse() {
            return null;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        private void setElapsedTime(long elapsedTime) {
            this.elapsedTime = elapsedTime;
        }

        public long getElapsedTime() {
            return this.elapsedTime;
        }

        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        public void setRequestURI(String requestURI) {
            this.requestURI = requestURI;
        }

        public String getRequestURI() {
            if (this.requestURI == null) {
                this.requestURI = "-";
            }
            return this.requestURI;
        }

        public void setRequestURL(String requestURL) {
            this.requestURL = requestURL;
        }

        public String getRequestURL() {
            if (this.requestURL == null) {
                this.requestURL = "-";
            }
            return this.requestURL;
        }

        public void setRemoteHost(String remoteHost) {
            this.remoteHost = remoteHost;
        }

        public String getRemoteHost() {
            if (this.remoteHost == null) {
                this.remoteHost = "-";
            }
            return this.remoteHost;
        }

        public void setRemoteUser(String remoteUser) {
            this.remoteUser = remoteUser;
        }

        public String getRemoteUser() {
            if (this.remoteUser == null) {
                this.remoteUser = "-";
            }
            return this.remoteUser;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getProtocol() {
            if (this.protocol == null) {
                this.protocol = "-";
            }
            return this.protocol;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public String getMethod() {
            if (this.method == null) {
                this.method = "-";
            }
            return this.method;
        }

        public void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public String getServerName() {
            if (this.serverName == null) {
                this.serverName = "-";
            }
            return this.serverName;
        }

        public void setRemoteAddr(String remoteAddr) {
            this.remoteAddr = remoteAddr;
        }

        public String getRemoteAddr() {
            if (this.remoteAddr == null) {
                this.remoteAddr = "-";
            }
            return this.remoteAddr;
        }

        public void setRequestHeaderMap(Map<String, String> requestHeaderMap) {
            this.requestHeaderMap = requestHeaderMap;
        }

        public String getRequestHeader(String key) {
            String result = null;
            key = key.toLowerCase();
            if (this.requestHeaderMap != null) {
                result = this.requestHeaderMap.get(key);
            }
            if (result != null) {
                return result;
            }
            return "-";
        }

        public Enumeration getRequestHeaderNames() {
            if (this.requestHeaderMap == null) {
                this.requestHeaderMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            }
            Vector<String> list = new Vector<String>(this.requestHeaderMap.keySet());
            return list.elements();
        }

        public Map<String, String> getRequestHeaderMap() {
            if (this.requestHeaderMap == null) {
                this.requestHeaderMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            }
            return this.requestHeaderMap;
        }

        public void setRequestParameterMap(Map<String, String[]> requestParameterMap) {
            this.requestParameterMap = requestParameterMap;
        }

        public Map<String, String[]> getRequestParameterMap() {
            if (this.requestParameterMap == null) {
                this.requestParameterMap = new HashMap<String, String[]>();
            }
            return this.requestParameterMap;
        }

        public String getAttribute(String key) {
            return "-";
        }

        public String[] getRequestParameter(String key) {
            String[] value;
            if (this.requestParameterMap == null) {
                this.requestParameterMap = new HashMap<String, String[]>();
            }
            if ((value = this.requestParameterMap.get(key)) == null) {
                return NA_STRING_ARRAY;
            }
            return value;
        }

        public String getCookie(String key) {
            return "-";
        }

        public long getContentLength() {
            return -1L;
        }

        public void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getRequestContent() {
            return EMPTY;
        }

        public String getResponseContent() {
            return EMPTY;
        }

        public void setLocalPort(int localPort) {
            this.localPort = localPort;
        }

        public int getLocalPort() {
            return this.localPort;
        }

        public ServerAdapter getServerAdapter() {
            return null;
        }

        public void setResponseHeaderMap(Map<String, String> responseHeaderMap) {
            this.responseHeaderMap = responseHeaderMap;
        }

        public String getResponseHeader(String key) {
            if (this.responseHeaderMap == null) {
                this.responseHeaderMap = new HashMap<String, String>();
            }
            return this.responseHeaderMap.get(key);
        }

        public Map<String, String> getResponseHeaderMap() {
            if (this.responseHeaderMap == null) {
                this.responseHeaderMap = new HashMap<String, String>();
            }
            return this.responseHeaderMap;
        }

        public List<String> getResponseHeaderNameList() {
            if (this.responseHeaderMap == null) {
                this.responseHeaderMap = new HashMap<String, String>();
            }
            return new ArrayList<String>(this.responseHeaderMap.keySet());
        }

        public void prepareForDeferredProcessing() {
        }
    }
}

