/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.tools;

import de.huxhorn.lilith.swing.callables.IndexingCallable;
import de.huxhorn.lilith.tools.FileHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexCommand {
    public static boolean indexLogFile(File inputFile) {
        Logger logger = LoggerFactory.getLogger(IndexCommand.class);
        File inputDataFile = FileHelper.resolveDataFile(inputFile);
        String inputDataFileStr = inputDataFile.getAbsolutePath();
        if (!inputDataFile.isFile()) {
            if (logger.isErrorEnabled()) {
                logger.error("'{}' is not a file!", (Object)inputDataFileStr);
            }
            return false;
        }
        if (!inputDataFile.canRead()) {
            if (logger.isErrorEnabled()) {
                logger.error("Can't read '{}'!", (Object)inputDataFileStr);
            }
            return false;
        }
        File inputIndexFile = FileHelper.resolveIndexFile(inputFile);
        String inputIndexFileStr = inputIndexFile.getAbsolutePath();
        IndexingCallable callable = new IndexingCallable(inputDataFile, inputIndexFile);
        callable.addPropertyChangeListener(new IndexingChangeListener());
        try {
            long count = callable.call();
            if (logger.isInfoEnabled()) {
                logger.info("Finished indexing {}. Number of events: {}", (Object)inputDataFileStr, (Object)count);
            }
            return true;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("Exception while indexing '" + inputDataFileStr + "'!", (Throwable)e);
            }
            return false;
        }
    }

    private static class IndexingChangeListener
    implements PropertyChangeListener {
        private final Logger logger = LoggerFactory.getLogger(IndexingChangeListener.class);

        private IndexingChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("progress".equals(evt.getPropertyName()) && this.logger.isInfoEnabled()) {
                this.logger.info("Progress: {}%", evt.getNewValue());
            }
        }
    }
}

