/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.tools;

import de.huxhorn.lilith.conditions.GroovyCondition;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.engine.AccessFileBufferFactory;
import de.huxhorn.lilith.engine.LogFileFactory;
import de.huxhorn.lilith.engine.LoggingFileBufferFactory;
import de.huxhorn.lilith.engine.impl.LogFileFactoryImpl;
import de.huxhorn.lilith.swing.callables.IndexingCallable;
import de.huxhorn.lilith.tools.FileHelper;
import de.huxhorn.lilith.tools.IndexCommand;
import de.huxhorn.lilith.tools.formatters.AccessFormatter;
import de.huxhorn.lilith.tools.formatters.Formatter;
import de.huxhorn.lilith.tools.formatters.LoggingFormatter;
import de.huxhorn.sulky.buffers.AppendOperation;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.buffers.FileBuffer;
import de.huxhorn.sulky.codec.filebuffer.DefaultFileHeaderStrategy;
import de.huxhorn.sulky.codec.filebuffer.FileHeader;
import de.huxhorn.sulky.codec.filebuffer.MetaData;
import de.huxhorn.sulky.codec.filebuffer.ReadOnlyExclusiveCodecFileBuffer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterCommand {
    public static boolean filterFile(File inputFile, File outputFile, File conditionFile, String searchString, String pattern, boolean overwrite, boolean keepRunning, boolean exclusive) {
        Logger logger = LoggerFactory.getLogger(FilterCommand.class);
        File inputDataFile = FileHelper.resolveDataFile(inputFile);
        String inputDataFileStr = inputDataFile.getAbsolutePath();
        if (!inputDataFile.isFile()) {
            if (logger.isErrorEnabled()) {
                logger.error("'{}' is not a file!", (Object)inputDataFileStr);
            }
            return false;
        }
        if (!inputDataFile.canRead()) {
            if (logger.isErrorEnabled()) {
                logger.error("Can't read '{}'!", (Object)inputDataFileStr);
            }
            return false;
        }
        if (exclusive) {
            keepRunning = false;
        }
        File inputIndexFile = FileHelper.resolveIndexFile(inputFile);
        long inputDataModified = inputDataFile.lastModified();
        if (!inputIndexFile.isFile()) {
            IndexCommand.indexLogFile(inputDataFile);
        } else {
            long inputIndexModified = inputIndexFile.lastModified();
            if (inputIndexModified < inputDataModified) {
                IndexCommand.indexLogFile(inputDataFile);
            }
        }
        String scriptFileName = conditionFile.getAbsolutePath();
        GroovyCondition groovyCondition = new GroovyCondition(scriptFileName);
        if (searchString != null) {
            groovyCondition.setSearchString(searchString);
        }
        File outputDataFile = FileHelper.resolveDataFile(outputFile);
        String outputDataFileStr = outputDataFile.getAbsolutePath();
        File outputIndexFile = FileHelper.resolveIndexFile(outputFile);
        String outputIndexFileStr = outputIndexFile.getAbsolutePath();
        if (overwrite) {
            if (outputDataFile.delete() && logger.isDebugEnabled()) {
                logger.debug("Deleted {}.", (Object)outputDataFileStr);
            }
            if (outputIndexFile.delete() && logger.isDebugEnabled()) {
                logger.debug("Deleted {}.", (Object)outputIndexFileStr);
            }
        }
        if (outputDataFile.isFile()) {
            long outputDataModified = outputDataFile.lastModified();
            if (!outputIndexFile.isFile()) {
                IndexCommand.indexLogFile(outputDataFile);
            } else {
                long outputIndexModified = outputIndexFile.lastModified();
                if (outputIndexModified < outputDataModified) {
                    IndexCommand.indexLogFile(outputDataFile);
                }
            }
        }
        DefaultFileHeaderStrategy fileHeaderStrategy = new DefaultFileHeaderStrategy();
        try {
            FileHeader header = fileHeaderStrategy.readFileHeader(inputDataFile);
            if (header == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Couldn't read file header from '{}'!", (Object)inputDataFileStr);
                }
                return false;
            }
            if (header.getMagicValue() != 190731757) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Invalid magic value! ", (Object)Integer.toHexString(header.getMagicValue()));
                }
                return false;
            }
            MetaData metaData = header.getMetaData();
            if (metaData == null || metaData.getData() == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Couldn't read meta data from '{}'!", (Object)inputDataFileStr);
                }
                return false;
            }
            Map data = metaData.getData();
            String contentType = (String)data.get("contentType");
            LogFileFactoryImpl logFileFactory = new LogFileFactoryImpl(new File("."));
            if ("logging".equals(contentType)) {
                FileBuffer inputBuffer;
                HashMap<String, String> loggingMetaData = new HashMap<String, String>();
                loggingMetaData.put("contentType", "logging");
                loggingMetaData.put("contentFormat", "protobuf");
                loggingMetaData.put("compression", "GZIP");
                LoggingFileBufferFactory fileBufferFactory = new LoggingFileBufferFactory((LogFileFactory)logFileFactory, loggingMetaData);
                if (exclusive) {
                    ReadOnlyExclusiveCodecFileBuffer input = new ReadOnlyExclusiveCodecFileBuffer(inputDataFile, inputIndexFile);
                    input.setCodec(fileBufferFactory.resolveCodec(metaData));
                    inputBuffer = input;
                } else {
                    inputBuffer = fileBufferFactory.createBuffer(inputDataFile, inputIndexFile, data);
                }
                FileBuffer outputBuffer = fileBufferFactory.createBuffer(outputDataFile, outputIndexFile, data);
                LoggingFormatter formatter = null;
                if (pattern != null) {
                    formatter = new LoggingFormatter();
                    formatter.setPattern(pattern);
                }
                long firstUnfiltered = FilterCommand.filterContent(inputBuffer, outputBuffer, groovyCondition, formatter);
                if (keepRunning) {
                    FilterCommand.pollFile(inputBuffer, outputBuffer, groovyCondition, formatter, inputDataFile, inputIndexFile, firstUnfiltered);
                }
                return true;
            }
            if ("access".equals(contentType)) {
                FileBuffer inputBuffer;
                HashMap<String, String> accessMetaData = new HashMap<String, String>();
                accessMetaData.put("contentType", "access");
                accessMetaData.put("contentFormat", "protobuf");
                accessMetaData.put("compression", "GZIP");
                AccessFileBufferFactory fileBufferFactory = new AccessFileBufferFactory((LogFileFactory)logFileFactory, accessMetaData);
                if (exclusive) {
                    ReadOnlyExclusiveCodecFileBuffer input = new ReadOnlyExclusiveCodecFileBuffer(inputDataFile, inputIndexFile);
                    input.setCodec(fileBufferFactory.resolveCodec(metaData));
                    inputBuffer = input;
                } else {
                    inputBuffer = fileBufferFactory.createBuffer(inputDataFile, inputIndexFile, data);
                }
                FileBuffer outputBuffer = fileBufferFactory.createBuffer(outputDataFile, outputIndexFile, data);
                AccessFormatter formatter = null;
                if (pattern != null) {
                    formatter = new AccessFormatter();
                    formatter.setPattern(pattern);
                }
                long firstUnfiltered = FilterCommand.filterContent(inputBuffer, outputBuffer, groovyCondition, formatter);
                if (keepRunning) {
                    FilterCommand.pollFile(inputBuffer, outputBuffer, groovyCondition, formatter, inputDataFile, inputIndexFile, firstUnfiltered);
                }
                return true;
            }
            if (logger.isWarnEnabled()) {
                logger.warn("Unexpected content type {}.", (Object)contentType);
            }
            return false;
        }
        catch (IOException ex) {
            if (logger.isWarnEnabled()) {
                logger.warn("Exception while reading from file '" + inputDataFileStr + "'!", (Throwable)ex);
            }
            return false;
        }
    }

    private static <T extends Serializable> long filterContent(Buffer<EventWrapper<T>> inputBuffer, AppendOperation<EventWrapper<T>> outputBuffer, GroovyCondition groovyCondition, Formatter<EventWrapper<T>> formatter) {
        long i;
        long bufferSize = inputBuffer.getSize();
        for (i = 0L; i < bufferSize; ++i) {
            String msg;
            EventWrapper current = (EventWrapper)inputBuffer.get(i);
            if (current == null || !groovyCondition.isTrue((Object)current)) continue;
            if (formatter != null && (msg = formatter.format(current)) != null) {
                System.out.print(msg);
                System.out.flush();
            }
            outputBuffer.add((Object)current);
        }
        return i;
    }

    private static <T extends Serializable> void pollFile(Buffer<EventWrapper<T>> inputBuffer, AppendOperation<EventWrapper<T>> outputBuffer, GroovyCondition groovyCondition, Formatter<EventWrapper<T>> formatter, File inputDataFile, File inputIndexFile, long index) {
        Logger logger = LoggerFactory.getLogger(FilterCommand.class);
        while (true) {
            long dataModified = inputDataFile.lastModified();
            long indexModified = inputIndexFile.lastModified();
            if (indexModified < dataModified) {
                IndexingCallable callable = new IndexingCallable(inputDataFile, inputIndexFile, true);
                try {
                    callable.call();
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break;
                    logger.warn("Exception while reindexing!", (Throwable)e);
                    break;
                }
                while (index < inputBuffer.getSize()) {
                    EventWrapper current = (EventWrapper)inputBuffer.get(index);
                    if (current != null && groovyCondition.isTrue((Object)current)) {
                        String msg;
                        if (formatter != null && (msg = formatter.format(current)) != null) {
                            System.out.print(msg);
                            System.out.flush();
                        }
                        outputBuffer.add((Object)current);
                    }
                    ++index;
                }
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                if (!logger.isInfoEnabled()) break;
                logger.info("Interrupted...");
                break;
            }
        }
    }
}

