/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.tools;

import de.huxhorn.lilith.swing.ApplicationPreferences;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateMd5Command {
    public static boolean createMd5(File input) {
        Logger logger = LoggerFactory.getLogger(CreateMd5Command.class);
        if (!input.isFile()) {
            if (logger.isWarnEnabled()) {
                logger.warn("{} isn't a file!", (Object)input.getAbsolutePath());
            }
            return false;
        }
        File output = new File(input.getParentFile(), input.getName() + ".md5");
        try {
            FileInputStream fis = new FileInputStream(input);
            byte[] md5 = ApplicationPreferences.getMD5(fis);
            if (md5 == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Couldn't calculate checksum for {}!", (Object)input.getAbsolutePath());
                }
                return false;
            }
            FileOutputStream fos = new FileOutputStream(output);
            fos.write(md5);
            fos.close();
            if (logger.isInfoEnabled()) {
                logger.info("Wrote checksum of {} to {}.", (Object)input.getAbsolutePath(), (Object)output.getAbsolutePath());
            }
        }
        catch (IOException e) {
            if (logger.isWarnEnabled()) {
                logger.warn("Exception while creating checksum!", (Throwable)e);
            }
            return false;
        }
        return true;
    }
}

