/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.tools;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.engine.AccessFileBufferFactory;
import de.huxhorn.lilith.engine.LogFileFactory;
import de.huxhorn.lilith.engine.LoggingFileBufferFactory;
import de.huxhorn.lilith.engine.impl.LogFileFactoryImpl;
import de.huxhorn.lilith.tools.FileHelper;
import de.huxhorn.lilith.tools.IndexCommand;
import de.huxhorn.lilith.tools.formatters.AccessFormatter;
import de.huxhorn.lilith.tools.formatters.Formatter;
import de.huxhorn.lilith.tools.formatters.LoggingFormatter;
import de.huxhorn.sulky.buffers.FileBuffer;
import de.huxhorn.sulky.codec.filebuffer.DefaultFileHeaderStrategy;
import de.huxhorn.sulky.codec.filebuffer.FileHeader;
import de.huxhorn.sulky.codec.filebuffer.MetaData;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatCommand {
    public static boolean catFile(File inputFile, String pattern, int amount) {
        Logger logger = LoggerFactory.getLogger(CatCommand.class);
        File inputDataFile = FileHelper.resolveDataFile(inputFile);
        String inputDataFileStr = inputDataFile.getAbsolutePath();
        if (!inputDataFile.isFile()) {
            if (logger.isErrorEnabled()) {
                logger.error("'{}' is not a file!", (Object)inputDataFileStr);
            }
            return false;
        }
        if (!inputDataFile.canRead()) {
            if (logger.isErrorEnabled()) {
                logger.error("Can't read '{}'!", (Object)inputDataFileStr);
            }
            return false;
        }
        File inputIndexFile = FileHelper.resolveIndexFile(inputFile);
        long dataModified = inputDataFile.lastModified();
        if (!inputIndexFile.isFile()) {
            IndexCommand.indexLogFile(inputDataFile);
        } else {
            long indexModified = inputIndexFile.lastModified();
            if (indexModified < dataModified) {
                IndexCommand.indexLogFile(inputDataFile);
            }
        }
        DefaultFileHeaderStrategy fileHeaderStrategy = new DefaultFileHeaderStrategy();
        try {
            FileHeader header = fileHeaderStrategy.readFileHeader(inputDataFile);
            if (header == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Couldn't read file header from '{}'!", (Object)inputDataFileStr);
                }
                return false;
            }
            if (header.getMagicValue() != 190731757) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Invalid magic value! ", (Object)Integer.toHexString(header.getMagicValue()));
                }
                return false;
            }
            MetaData metaData = header.getMetaData();
            if (metaData == null || metaData.getData() == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Couldn't read meta data from '{}'!", (Object)inputDataFileStr);
                }
                return false;
            }
            Map data = metaData.getData();
            String contentType = (String)data.get("contentType");
            LogFileFactoryImpl logFileFactory = new LogFileFactoryImpl(new File("."));
            if ("logging".equals(contentType)) {
                HashMap<String, String> loggingMetaData = new HashMap<String, String>();
                loggingMetaData.put("contentType", "logging");
                loggingMetaData.put("contentFormat", "protobuf");
                loggingMetaData.put("compression", "GZIP");
                LoggingFileBufferFactory fileBufferFactory = new LoggingFileBufferFactory((LogFileFactory)logFileFactory, loggingMetaData);
                FileBuffer inputBuffer = fileBufferFactory.createBuffer(inputDataFile, inputIndexFile, data);
                LoggingFormatter formatter = new LoggingFormatter();
                formatter.setPattern(pattern);
                CatCommand.printContent(inputBuffer, formatter, amount);
                return true;
            }
            if ("access".equals(contentType)) {
                HashMap<String, String> accessMetaData = new HashMap<String, String>();
                accessMetaData.put("contentType", "access");
                accessMetaData.put("contentFormat", "protobuf");
                accessMetaData.put("compression", "GZIP");
                AccessFileBufferFactory fileBufferFactory = new AccessFileBufferFactory((LogFileFactory)logFileFactory, accessMetaData);
                FileBuffer buffer = fileBufferFactory.createBuffer(inputDataFile, inputIndexFile, data);
                AccessFormatter formatter = new AccessFormatter();
                formatter.setPattern(pattern);
                CatCommand.printContent(buffer, formatter, amount);
                return true;
            }
            if (logger.isWarnEnabled()) {
                logger.warn("Unexpected content type {}.", (Object)contentType);
            }
            return false;
        }
        catch (IOException ex) {
            if (logger.isWarnEnabled()) {
                logger.warn("Exception while reading from file '{}'!", (Object)inputDataFileStr, (Object)ex);
            }
            return false;
        }
    }

    private static <T extends Serializable> void printContent(FileBuffer<EventWrapper<T>> buffer, Formatter<EventWrapper<T>> formatter, long amount) {
        long bufferSize = buffer.getSize();
        if (amount < 1L || amount > bufferSize) {
            amount = bufferSize;
        }
        for (long i = 0L; i < amount; ++i) {
            String msg;
            EventWrapper current = (EventWrapper)buffer.get(i);
            if (current == null || (msg = formatter.format(current)) == null) continue;
            System.out.print(msg);
            System.out.flush();
        }
    }
}

