/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.table.tooltips;

import de.huxhorn.lilith.data.access.AccessEvent;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.swing.table.TooltipGenerator;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JTable;

public class TimestampTooltipGenerator
implements TooltipGenerator {
    private SimpleDateFormat fullFormat = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSS");

    public String createTooltipText(JTable table, int row) {
        String tooltip = null;
        Object value = table.getValueAt(row, 0);
        if (value instanceof EventWrapper) {
            AccessEvent event;
            Long timestamp;
            EventWrapper wrapper = (EventWrapper)value;
            Serializable eventObj = wrapper.getEvent();
            if (eventObj instanceof LoggingEvent) {
                LoggingEvent event2 = (LoggingEvent)eventObj;
                Long timestamp2 = event2.getTimeStamp();
                if (timestamp2 != null) {
                    tooltip = this.fullFormat.format(new Date(timestamp2));
                }
            } else if (eventObj instanceof AccessEvent && (timestamp = (event = (AccessEvent)eventObj).getTimeStamp()) != null) {
                tooltip = this.fullFormat.format(new Date(timestamp));
            }
        }
        return tooltip;
    }
}

