/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.table.tooltips;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.ThreadInfo;
import de.huxhorn.lilith.swing.table.TooltipGenerator;
import java.io.Serializable;
import javax.swing.JTable;

public class ThreadTooltipGenerator
implements TooltipGenerator {
    public String createTooltipText(JTable table, int row) {
        LoggingEvent event;
        ThreadInfo threadInfo;
        EventWrapper wrapper;
        Serializable eventObj;
        String tooltip = null;
        Object value = table.getValueAt(row, 0);
        if (value instanceof EventWrapper && (eventObj = (wrapper = (EventWrapper)value).getEvent()) instanceof LoggingEvent && (threadInfo = (event = (LoggingEvent)eventObj).getThreadInfo()) != null) {
            StringBuilder builder = new StringBuilder();
            String name = threadInfo.getName();
            Long id = threadInfo.getId();
            if (name != null || id != null) {
                if (name == null) {
                    builder.append(id);
                } else if (id == null) {
                    builder.append(name);
                } else {
                    builder.append(name).append(" (id=").append(id).append(")");
                }
            }
            name = threadInfo.getGroupName();
            id = threadInfo.getGroupId();
            if (name != null || id != null) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                if (name == null) {
                    builder.append("groupId=").append(id);
                } else if (id == null) {
                    builder.append("group=").append(name);
                } else {
                    builder.append("group=").append(name).append(" (id=").append(id).append(")");
                }
            }
            tooltip = builder.toString();
        }
        return tooltip;
    }
}

