/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.table.tooltips;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.Marker;
import de.huxhorn.lilith.swing.table.TooltipGenerator;
import de.huxhorn.sulky.formatting.SimpleXml;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerTooltipGenerator
implements TooltipGenerator {
    @Override
    public String createTooltipText(JTable table, int row) {
        LoggingEvent event;
        Marker marker;
        EventWrapper wrapper;
        Serializable eventObj;
        String tooltip = null;
        Object value = table.getValueAt(row, 0);
        if (value instanceof EventWrapper && (eventObj = (wrapper = (EventWrapper)value).getEvent()) instanceof LoggingEvent && (marker = (event = (LoggingEvent)eventObj).getMarker()) != null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("<html>");
            MarkerTooltipGenerator.appendMarker(marker, buffer, null, false, true);
            buffer.append("</html>");
            tooltip = buffer.toString();
        }
        return tooltip;
    }

    public static void appendMarker(Marker marker, StringBuilder buffer, List<String> processedMarkers, boolean xhtml, boolean first) {
        if (marker != null) {
            if (processedMarkers == null) {
                processedMarkers = new ArrayList<String>();
            }
            String markerName = marker.getName();
            buffer.append(SimpleXml.escape((String)markerName));
            if (first) {
                if (xhtml) {
                    buffer.append("<br/>");
                } else {
                    buffer.append("<br>");
                }
            }
            if (!processedMarkers.contains(markerName)) {
                processedMarkers.add(markerName);
                if (marker.hasReferences()) {
                    buffer.append("<ul>");
                    Map children = marker.getReferences();
                    for (Map.Entry current : children.entrySet()) {
                        Marker childMarker = (Marker)current.getValue();
                        buffer.append("<li>");
                        MarkerTooltipGenerator.appendMarker(childMarker, buffer, processedMarkers, xhtml, false);
                        buffer.append("</li>");
                    }
                    buffer.append("</ul>");
                }
            }
        }
    }
}

