/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.table.renderer;

import de.huxhorn.lilith.data.access.AccessEvent;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.LoggerContext;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.swing.table.Colors;
import de.huxhorn.lilith.swing.table.ColorsProvider;
import de.huxhorn.lilith.swing.table.renderer.LabelCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class ApplicationRenderer
implements TableCellRenderer {
    private LabelCellRenderer renderer = new LabelCellRenderer();

    public ApplicationRenderer() {
        this.renderer.setHorizontalAlignment(0);
        this.renderer.setToolTipText(null);
        this.renderer.setIcon(null);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
        if (!isSelected) {
            boolean bl = isSelected = rowIndex == LabelCellRenderer.getSelectedRow(table);
        }
        if (!hasFocus && isSelected) {
            hasFocus = table.isFocusOwner();
        }
        this.renderer.setSelected(isSelected);
        this.renderer.setFocused(hasFocus);
        Color foreground = Color.BLACK;
        String text = null;
        if (value instanceof EventWrapper) {
            EventWrapper wrapper = (EventWrapper)value;
            Serializable evtObject = wrapper.getEvent();
            LoggerContext context = null;
            if (evtObject instanceof LoggingEvent) {
                context = ((LoggingEvent)evtObject).getLoggerContext();
            } else if (evtObject instanceof AccessEvent) {
                context = ((AccessEvent)evtObject).getLoggerContext();
            }
            if (context != null) {
                Map props = context.getProperties();
                if (props != null) {
                    text = (String)props.get("applicationIdentifier");
                }
                if (text == null) {
                    text = context.getName();
                }
            }
        }
        if (text == null) {
            text = "";
        }
        this.renderer.setText(text);
        boolean colorsInitialized = false;
        if (!hasFocus && !isSelected && table instanceof ColorsProvider && value instanceof EventWrapper) {
            EventWrapper wrapper = (EventWrapper)value;
            ColorsProvider cp = (ColorsProvider)((Object)table);
            Colors colors = cp.resolveColors(wrapper, rowIndex, vColIndex);
            colorsInitialized = this.renderer.updateColors(colors);
        }
        if (!colorsInitialized) {
            this.renderer.setForeground(foreground);
        }
        this.renderer.correctRowHeight(table);
        return this.renderer;
    }
}

