/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.statistics;

import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.swing.EventWrapperViewPanel;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.filefilters.PngFileFilter;
import de.huxhorn.lilith.swing.statistics.GraphImageProducer;
import de.huxhorn.lilith.swing.statistics.NinetyDaysProducer;
import de.huxhorn.lilith.swing.statistics.OneDayProducer;
import de.huxhorn.lilith.swing.statistics.OneYearProducer;
import de.huxhorn.lilith.swing.statistics.SevenDaysProducer;
import de.huxhorn.lilith.swing.statistics.TenHoursProducer;
import de.huxhorn.lilith.swing.statistics.ThirtyDaysProducer;
import de.huxhorn.lilith.swing.statistics.TwentyMinutesProducer;
import de.huxhorn.lilith.swing.statistics.TwoHoursProducer;
import de.huxhorn.sulky.io.IOUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.rrd4j.core.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsPanel
extends JPanel {
    private final Logger logger = LoggerFactory.getLogger(StatisticsPanel.class);
    private static final long REFRESH_DELAY = 10000L;
    private SourceIdentifier sourceIdentifier;
    private MainFrame mainFrame;
    private boolean running;
    private GraphImageProducer[] graphImageFactories;
    private int selectedGraph;
    private JComboBox timerangeComboBox;
    private JFileChooser saveFileChooser;
    private BufferedImage[] imageToggle;
    private int imageIndex;
    private JLabel graphLabel;
    private JCheckBox showMaxCheckBox;
    private JComboBox sourcesComboBox;
    private Thread updateThread;
    public static final String SOURCE_IDENTIFIER_PROPERTY = "sourceIdentifier";
    private Object[] previousSourcesArray;

    public StatisticsPanel(MainFrame owner) {
        this.mainFrame = owner;
        this.imageToggle = new BufferedImage[2];
        this.imageIndex = 0;
        this.running = false;
        this.createUI();
    }

    public void setSourceIdentifier(SourceIdentifier sourceIdentifier) {
        SourceIdentifier oldValue = this.sourceIdentifier;
        SourceIdentifier newValue = this.sourceIdentifier = sourceIdentifier;
        this.initUI();
        this.updateGraph();
        this.firePropertyChange(SOURCE_IDENTIFIER_PROPERTY, oldValue, newValue);
    }

    public SourceIdentifier getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    private void createUI() {
        ShowMaxAction showMaxAction = new ShowMaxAction();
        this.showMaxCheckBox = new JCheckBox(showMaxAction);
        this.showMaxCheckBox.setOpaque(false);
        this.showMaxCheckBox.setSelected(true);
        this.saveFileChooser = new JFileChooser();
        this.saveFileChooser.setFileSelectionMode(0);
        PngFileFilter pngFileFilter = new PngFileFilter();
        this.saveFileChooser.setFileFilter(pngFileFilter);
        this.graphImageFactories = new GraphImageProducer[]{new TwentyMinutesProducer(this.mainFrame), new TwoHoursProducer(this.mainFrame), new TenHoursProducer(this.mainFrame), new OneDayProducer(this.mainFrame), new SevenDaysProducer(this.mainFrame), new ThirtyDaysProducer(this.mainFrame), new NinetyDaysProducer(this.mainFrame), new OneYearProducer(this.mainFrame)};
        JPanel graphPanel = new JPanel(new GridLayout(1, 1));
        this.graphLabel = new JLabel();
        graphPanel.add(this.graphLabel);
        this.setLayout(new BorderLayout());
        this.add((Component)graphPanel, "Center");
        this.timerangeComboBox = new JComboBox<Object>(new Object[]{"20 minutes", "2 hours", "10 hours", "1 day", "7 days", "30 days", "90 days", "1 year"});
        this.timerangeComboBox.addActionListener(new TimerangeActionListener());
        this.sourcesComboBox = new JComboBox();
        this.sourcesComboBox.addActionListener(new SourcesActionListener());
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add(new JLabel("Source: "));
        toolbar.add(this.sourcesComboBox);
        toolbar.addSeparator();
        toolbar.add(new JLabel("Timerange: "));
        toolbar.add(this.timerangeComboBox);
        toolbar.add(this.showMaxCheckBox);
        toolbar.addSeparator();
        toolbar.add(new JButton(new SaveAction()));
        this.add((Component)toolbar, "North");
        this.setSelectedGraph(0);
    }

    private void initUI() {
        SortedMap<String, SourceIdentifier> stats = this.mainFrame.getAvailableStatistics();
        ArrayList<WrappedSourceIdentifier> wrappedSources = new ArrayList<WrappedSourceIdentifier>(stats.size() + 1);
        wrappedSources.add(new WrappedSourceIdentifier("Global", new SourceIdentifier("global")));
        for (Map.Entry<String, SourceIdentifier> current : stats.entrySet()) {
            WrappedSourceIdentifier wrapped = new WrappedSourceIdentifier(current.getKey(), current.getValue());
            wrappedSources.add(wrapped);
        }
        Object[] newSourcesArray = wrappedSources.toArray();
        if (!Arrays.equals(this.previousSourcesArray, newSourcesArray)) {
            this.previousSourcesArray = newSourcesArray;
            DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(newSourcesArray);
            this.sourcesComboBox.setModel(model);
        }
        int index = 0;
        if (this.sourceIdentifier != null) {
            ComboBoxModel model = this.sourcesComboBox.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                Object current = model.getElementAt(i);
                if (current instanceof WrappedSourceIdentifier) {
                    WrappedSourceIdentifier wrapped = (WrappedSourceIdentifier)current;
                    if (this.sourceIdentifier.getIdentifier().equals(wrapped.sourceIdentifier.getIdentifier())) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Equal");
                        }
                        index = i;
                        break;
                    }
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Not equal: {} != {}", (Object)this.sourceIdentifier, (Object)wrapped.sourceIdentifier);
                    continue;
                }
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn("Not instanceof WrappedSourceIdentifier");
            }
        }
        this.sourcesComboBox.setSelectedIndex(index);
    }

    private void setSelectedGraph(int i) {
        this.selectedGraph = i >= 0 && i < this.graphImageFactories.length ? i : 0;
        this.updateGraph();
    }

    private void updateGraph() {
        if (this.sourceIdentifier != null && this.selectedGraph >= 0 && this.selectedGraph < this.graphImageFactories.length) {
            GraphImageProducer graphImageFactory = this.graphImageFactories[this.selectedGraph];
            this.imageToggle[this.imageIndex] = graphImageFactory.createGraphImage(Util.getTime(), this.sourceIdentifier, this.imageToggle[this.imageIndex], this.showMaxCheckBox.isSelected());
            if (this.imageToggle[this.imageIndex] != null) {
                ImageIcon graphImageIcon = new ImageIcon();
                graphImageIcon.setImage(this.imageToggle[this.imageIndex]);
                this.graphLabel.setIcon(graphImageIcon);
                this.graphLabel.setText("");
            } else {
                this.graphLabel.setIcon(null);
                this.graphLabel.setText("Couldn't create graph image!");
            }
            this.imageIndex = this.imageIndex == 0 ? 1 : 0;
            this.graphLabel.repaint();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.setRunning(true);
        if (this.updateThread == null) {
            this.updateThread = new Thread(new GraphUpdateRunnable());
            this.updateThread.setDaemon(true);
            this.updateThread.start();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("addNotify!");
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.setRunning(false);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("removeNotify!");
        }
    }

    private synchronized void setRunning(boolean running) {
        this.running = running;
        if (!running) {
            this.graphLabel.setIcon(null);
            for (int i = 0; i < this.imageToggle.length; ++i) {
                if (this.imageToggle[i] == null) continue;
                this.imageToggle[i].flush();
                this.imageToggle[i] = null;
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info("Flushed image.");
            }
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeImage(File imageFile) throws IOException {
        Image resultImage = null;
        if (this.selectedGraph >= 0 && this.selectedGraph < this.graphImageFactories.length) {
            resultImage = this.graphImageFactories[this.selectedGraph].createGraphImage(Util.getTime(), this.sourceIdentifier, null, this.showMaxCheckBox.isSelected());
        }
        if (resultImage != null) {
            BufferedOutputStream imageOutput;
            block5: {
                String format = "png";
                imageOutput = null;
                try {
                    imageOutput = new BufferedOutputStream(new FileOutputStream(imageFile));
                    boolean writerFound = ImageIO.write((RenderedImage)((Object)resultImage), "png", imageOutput);
                    if (writerFound) break block5;
                    String msg = "Couldn't write image! No writer found for format 'png'!";
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error(msg);
                    }
                    throw new IOException(msg);
                }
                catch (Throwable throwable) {
                    IOUtilities.closeQuietly(imageOutput);
                    resultImage.flush();
                    throw throwable;
                }
            }
            IOUtilities.closeQuietly((OutputStream)imageOutput);
            resultImage.flush();
        }
    }

    private static class WrappedSourceIdentifier {
        public String resolvedName;
        public SourceIdentifier sourceIdentifier;

        public WrappedSourceIdentifier(String resolvedName, SourceIdentifier sourceIdentifier) {
            this.resolvedName = resolvedName;
            this.sourceIdentifier = sourceIdentifier;
        }

        public String toString() {
            return this.resolvedName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WrappedSourceIdentifier that = (WrappedSourceIdentifier)o;
            if (this.resolvedName != null ? !this.resolvedName.equals(that.resolvedName) : that.resolvedName != null) {
                return false;
            }
            return !(this.sourceIdentifier == null ? that.sourceIdentifier != null : !this.sourceIdentifier.equals((Object)that.sourceIdentifier));
        }

        public int hashCode() {
            int result = this.resolvedName != null ? this.resolvedName.hashCode() : 0;
            result = 29 * result + (this.sourceIdentifier != null ? this.sourceIdentifier.hashCode() : 0);
            return result;
        }
    }

    private class ShowMaxAction
    extends AbstractAction {
        public ShowMaxAction() {
            super("Show Max");
            this.putValue("ShortDescription", "Show Max");
        }

        public void actionPerformed(ActionEvent e) {
            StatisticsPanel.this.updateGraph();
        }
    }

    private class SaveAction
    extends AbstractAction {
        public SaveAction() {
            URL url = EventWrapperViewPanel.class.getResource("/tango/32x32/actions/document-save-as.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Save as...");
        }

        public void actionPerformed(ActionEvent e) {
            block5: {
                StatisticsPanel.this.saveFileChooser.setCurrentDirectory(StatisticsPanel.this.mainFrame.getApplicationPreferences().getImagePath());
                int returnVal = StatisticsPanel.this.saveFileChooser.showDialog(StatisticsPanel.this, "Save");
                if (returnVal == 0) {
                    File file = StatisticsPanel.this.saveFileChooser.getSelectedFile();
                    String filename = file.getAbsolutePath();
                    if (!filename.toLowerCase().endsWith(".png")) {
                        filename = filename + ".png";
                    }
                    file = new File(filename);
                    try {
                        StatisticsPanel.this.writeImage(file);
                        if (StatisticsPanel.this.logger.isInfoEnabled()) {
                            StatisticsPanel.this.logger.info("Wrote file '" + file.getAbsolutePath() + "'.");
                        }
                        File parent = file.getParentFile();
                        StatisticsPanel.this.mainFrame.getApplicationPreferences().setImagePath(parent);
                    }
                    catch (IOException ex) {
                        if (!StatisticsPanel.this.logger.isWarnEnabled()) break block5;
                        StatisticsPanel.this.logger.warn("Exception while writing file '" + file.getAbsolutePath() + "'!", (Throwable)ex);
                    }
                }
            }
        }
    }

    private class SourcesActionListener
    implements ActionListener {
        private SourcesActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object selected = StatisticsPanel.this.sourcesComboBox.getSelectedItem();
            if (StatisticsPanel.this.logger.isInfoEnabled()) {
                StatisticsPanel.this.logger.info("Selected source: {}", selected);
            }
            SourceIdentifier si = null;
            if (selected instanceof WrappedSourceIdentifier) {
                si = ((WrappedSourceIdentifier)selected).sourceIdentifier;
                if (StatisticsPanel.this.logger.isInfoEnabled()) {
                    StatisticsPanel.this.logger.info("Selected sourceIdentifier: {}", (Object)si);
                }
            } else if (StatisticsPanel.this.logger.isWarnEnabled()) {
                StatisticsPanel.this.logger.warn("Not instanceof WrappedSourceIdentifier: {}");
            }
            StatisticsPanel.this.setSourceIdentifier(si);
        }
    }

    private class TimerangeActionListener
    implements ActionListener {
        private TimerangeActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int index = StatisticsPanel.this.timerangeComboBox.getSelectedIndex();
            StatisticsPanel.this.setSelectedGraph(index);
        }
    }

    class SwingUpdateRunnable
    implements Runnable {
        SwingUpdateRunnable() {
        }

        public void run() {
            StatisticsPanel.this.updateGraph();
            if (StatisticsPanel.this.logger.isInfoEnabled()) {
                StatisticsPanel.this.logger.info("Updated statistics...");
            }
        }
    }

    class GraphUpdateRunnable
    implements Runnable {
        GraphUpdateRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                block11: {
                    StatisticsPanel statisticsPanel = StatisticsPanel.this;
                    synchronized (statisticsPanel) {
                        if (StatisticsPanel.this.running) {
                            break block11;
                        }
                        try {
                            StatisticsPanel.this.wait();
                        }
                        catch (InterruptedException ex) {
                            if (StatisticsPanel.this.logger.isInfoEnabled()) {
                                StatisticsPanel.this.logger.info("Interrupted...", (Throwable)ex);
                            }
                            return;
                        }
                    }
                }
                SwingUtilities.invokeLater(new SwingUpdateRunnable());
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ex) {
                    if (StatisticsPanel.this.logger.isInfoEnabled()) {
                        StatisticsPanel.this.logger.info("Interrupted...", (Throwable)ex);
                    }
                    return;
                }
            }
        }
    }
}

