/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.statistics;

import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.statistics.GraphImageProducer;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;
import org.rrd4j.graph.RrdGraphInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGraphImageProducer
implements GraphImageProducer {
    private final Logger logger = LoggerFactory.getLogger(AbstractGraphImageProducer.class);
    protected MainFrame mainFrame;
    protected SimpleDateFormat dateFormat;
    protected Dimension graphSize = new Dimension(600, 400);

    public AbstractGraphImageProducer(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    }

    protected File getRrdFile(SourceIdentifier sourceIdentifier) {
        File statisticsParent = new File(this.mainFrame.getApplicationPreferences().getStartupApplicationPath(), "statistics");
        return new File(statisticsParent, sourceIdentifier.getIdentifier() + ".rrd");
    }

    protected String createGraphTitle(SourceIdentifier sourceIdentifier) {
        return this.mainFrame.getPrimarySourceTitle(sourceIdentifier) + " @ " + this.dateFormat.format(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage createGraphImage(long nowInSeconds, SourceIdentifier sourceIdentifier, BufferedImage result, boolean showMax) {
        RrdGraphDef graphDef;
        RrdGraphDef rrdGraphDef = graphDef = this.getGraphDef(nowInSeconds, sourceIdentifier, showMax);
        synchronized (rrdGraphDef) {
            block10: {
                try {
                    RrdGraph graph = new RrdGraph(graphDef);
                    RrdGraphInfo graphInfo = graph.getRrdGraphInfo();
                    int width = graphInfo.getWidth();
                    int height = graphInfo.getHeight();
                    if (result != null && (result.getWidth() != width || result.getHeight() != height)) {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("Flushing previous image because of wrong size.");
                        }
                        result.flush();
                        result = null;
                    }
                    if (result == null) {
                        result = new BufferedImage(width, height, 1);
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("Created new image.");
                        }
                    }
                    graph.render(result.getGraphics());
                }
                catch (IOException ex) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Exception while creating graph!", (Throwable)ex);
                    }
                    if (result == null) break block10;
                    result.flush();
                    result = null;
                }
            }
        }
        return result;
    }

    public abstract RrdGraphDef getGraphDef(long var1, SourceIdentifier var3, boolean var4);
}

