/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.EventWrapperViewPanel;
import de.huxhorn.lilith.swing.preferences.EditLoggingLevelDialog;
import de.huxhorn.lilith.swing.preferences.PreferencesDialog;
import de.huxhorn.lilith.swing.preferences.table.LoggingLevelColumnModel;
import de.huxhorn.lilith.swing.preferences.table.LoggingLevelTableModel;
import de.huxhorn.lilith.swing.table.ColorScheme;
import de.huxhorn.sulky.swing.Windows;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingLevelPanel
extends JPanel {
    private final Logger logger = LoggerFactory.getLogger(LoggingLevelPanel.class);
    private PreferencesDialog preferencesDialog;
    private ApplicationPreferences applicationPreferences;
    private EditLoggingLevelDialog editDialog;
    private JTable table;
    private LoggingLevelTableModel tableModel;
    private EditConditionAction editAction;
    private Map<LoggingEvent.Level, ColorScheme> colors;
    private LoggingLevelColumnModel tableColumnModel;

    public LoggingLevelPanel(PreferencesDialog preferencesDialog) {
        this.preferencesDialog = preferencesDialog;
        this.applicationPreferences = preferencesDialog.getApplicationPreferences();
        this.createUI();
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        this.editDialog = new EditLoggingLevelDialog(this.preferencesDialog);
        this.tableModel = new LoggingLevelTableModel();
        this.table = new JTable(this.tableModel);
        this.table.addMouseListener(new ConditionTableMouseListener());
        this.tableColumnModel = new LoggingLevelColumnModel();
        this.table.setColumnModel(this.tableColumnModel);
        JScrollPane tableScrollPane = new JScrollPane(this.table);
        JPanel conditionsPanel = new JPanel(new GridLayout(1, 1));
        conditionsPanel.add(tableScrollPane);
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        ListSelectionModel sourceNameRowSelectionModel = this.table.getSelectionModel();
        sourceNameRowSelectionModel.setSelectionMode(0);
        sourceNameRowSelectionModel.addListSelectionListener(new ConditionTableRowSelectionListener());
        this.editAction = new EditConditionAction();
        JButton editConditionButton = new JButton(this.editAction);
        toolBar.add(editConditionButton);
        this.add((Component)toolBar, "North");
        this.add((Component)conditionsPanel, "Center");
    }

    public void initUI() {
        this.colors = this.applicationPreferences.getLevelColors();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Conditions retrieved: {}", this.colors);
        }
        this.tableColumnModel.setSchemes(this.colors);
        this.updateConditions();
    }

    public void updateConditions() {
        int selectedRow = this.table.getSelectedRow();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("selectedRow={}", (Object)selectedRow);
        }
        LoggingEvent.Level level = null;
        List<LoggingEvent.Level> levels = this.tableModel.getData();
        int conditionCount = levels.size();
        if (selectedRow > -1 && selectedRow < conditionCount) {
            level = levels.get(selectedRow);
        }
        this.editAction.setEnabled(level != null);
    }

    public void saveSettings() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Setting level colors to {}.", this.colors);
        }
        this.applicationPreferences.setLevelColors(this.colors);
    }

    public void edit(LoggingEvent.Level level) {
        if (level != null) {
            ColorScheme scheme = this.colors.get(level);
            this.editDialog.setScheme(scheme);
            this.editDialog.setLevel(level);
            Windows.showWindow((Window)this.editDialog, (Window)this.preferencesDialog, (boolean)true);
            if (this.editDialog.isCanceled()) {
                return;
            }
            scheme = this.editDialog.getScheme();
            this.colors.put(level, scheme);
            this.updateConditions();
        }
    }

    private class ConditionTableMouseListener
    implements MouseListener {
        public void mouseClicked(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            } else if (evt.getButton() == 1) {
                Point p = evt.getPoint();
                int row = LoggingLevelPanel.this.table.rowAtPoint(p);
                List<LoggingEvent.Level> levels = LoggingLevelPanel.this.tableModel.getData();
                if (row >= 0 && row < levels.size() && evt.getClickCount() >= 2) {
                    LoggingEvent.Level level = levels.get(row);
                    LoggingLevelPanel.this.edit(level);
                }
            }
        }

        private void showPopup(MouseEvent evt) {
        }

        public void mousePressed(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mouseReleased(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    private class EditConditionAction
    extends AbstractAction {
        private static final long serialVersionUID = 95425194239658313L;

        public EditConditionAction() {
            super("Edit");
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/actions/list-add.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Edit colors.");
        }

        public void actionPerformed(ActionEvent e) {
            List<LoggingEvent.Level> levels;
            int row;
            if (LoggingLevelPanel.this.logger.isDebugEnabled()) {
                LoggingLevelPanel.this.logger.debug("Edit");
            }
            if ((row = LoggingLevelPanel.this.table.getSelectedRow()) >= 0 && row < (levels = LoggingLevelPanel.this.tableModel.getData()).size()) {
                LoggingEvent.Level level = levels.get(row);
                LoggingLevelPanel.this.edit(level);
                LoggingLevelPanel.this.updateConditions();
            }
        }
    }

    private class ConditionTableRowSelectionListener
    implements ListSelectionListener {
        private ConditionTableRowSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            LoggingLevelPanel.this.updateConditions();
        }
    }
}

