/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericSortedListModel<T extends Comparable<? super T>>
extends AbstractListModel {
    private final List<T> data = new ArrayList<T>();
    private final Comparator<T> comparator;

    public GenericSortedListModel() {
        this(null);
    }

    public GenericSortedListModel(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    public void setData(List<T> data) {
        if (!((Object)this.data).equals(data)) {
            int size = this.data.size();
            if (size > 0) {
                this.data.clear();
                this.fireIntervalRemoved(this, 0, size - 1);
            }
            if ((size = data.size()) > 0) {
                this.data.addAll(data);
                if (this.comparator != null) {
                    Collections.sort(this.data, this.comparator);
                } else {
                    Collections.sort(this.data);
                }
                this.fireIntervalAdded(this, 0, size - 1);
            }
        }
    }

    public List<T> getData() {
        return new ArrayList<T>(this.data);
    }

    public void add(T element) {
        if (!this.data.contains(element)) {
            this.data.add(element);
            if (this.comparator != null) {
                Collections.sort(this.data, this.comparator);
            } else {
                Collections.sort(this.data);
            }
            int size = this.data.size();
            this.fireContentsChanged(this, 0, size - 1);
        }
    }

    public void remove(T element) {
        int index = this.data.indexOf(element);
        if (index >= 0) {
            this.data.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    @Override
    public T getElementAt(int index) {
        return (T)((Comparable)this.data.get(index));
    }
}

