/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.EventWrapperViewPanel;
import de.huxhorn.lilith.swing.preferences.PreferencesDialog;
import de.huxhorn.lilith.tray.TraySupport;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class GeneralPanel
extends JPanel {
    private PreferencesDialog preferencesDialog;
    private ApplicationPreferences applicationPreferences;
    private JCheckBox scrollingToBottomCheckbox;
    private JCheckBox coloringWholeRowCheckbox;
    private JCheckBox showFullCallstackCheckbox;
    private JCheckBox showStackTraceCheckbox;
    private JCheckBox usingWrappedExceptionStyleCheckbox;
    private JFileChooser applicationPathFileChooser;
    private JTextField appPathTextField;
    private JComboBox lookAndFeelCombo;
    private JComboBox defaultConditionCombo;
    private JCheckBox globalLoggingEnabledCheckbox;
    private JCheckBox loggingStatsEnabledCheckbox;
    private JCheckBox trayActiveCheckbox;
    private JCheckBox hidingOnCloseCheckbox;

    public GeneralPanel(PreferencesDialog preferencesDialog) {
        this.preferencesDialog = preferencesDialog;
        this.applicationPreferences = preferencesDialog.getApplicationPreferences();
        this.createUI();
    }

    private void createUI() {
        this.scrollingToBottomCheckbox = new JCheckBox("Initial 'Scrolling to Bottom' setting");
        this.coloringWholeRowCheckbox = new JCheckBox("Color whole row according to Level or Status");
        this.showFullCallstackCheckbox = new JCheckBox("Show full Callstack.");
        this.showStackTraceCheckbox = new JCheckBox("Show stacktrace of Throwables");
        this.usingWrappedExceptionStyleCheckbox = new JCheckBox("Use wrapped exception style.");
        this.applicationPathFileChooser = new JFileChooser();
        this.applicationPathFileChooser.setFileSelectionMode(1);
        this.appPathTextField = new JTextField();
        this.appPathTextField.setEditable(false);
        BrowseApplicationPathAction browseAppPathAction = new BrowseApplicationPathAction();
        JButton browseAppPathButton = new JButton(browseAppPathAction);
        JPanel appPathPanel = new JPanel();
        appPathPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Application Path"));
        appPathPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        appPathPanel.add((Component)this.appPathTextField, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        appPathPanel.add((Component)browseAppPathButton, gbc);
        this.lookAndFeelCombo = new JComboBox();
        this.defaultConditionCombo = new JComboBox();
        this.globalLoggingEnabledCheckbox = new JCheckBox("Enable global logs.");
        this.loggingStatsEnabledCheckbox = new JCheckBox("Enable logging statistics.");
        this.trayActiveCheckbox = new JCheckBox("Enable tray icon.");
        this.hidingOnCloseCheckbox = new JCheckBox("Hide windows on close.");
        this.hidingOnCloseCheckbox.setToolTipText("Hide all windows on close of main frame instead of exiting the application. This is only relevant if tray icon is enabled.");
        JPanel viewPanel = new JPanel(new GridLayout(2, 1));
        viewPanel.setBorder(new TitledBorder(new EtchedBorder(1), "View"));
        viewPanel.add(this.scrollingToBottomCheckbox);
        viewPanel.add(this.coloringWholeRowCheckbox);
        JPanel detailsPanel = new JPanel(new GridLayout(3, 1));
        detailsPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Details View"));
        detailsPanel.add(this.showFullCallstackCheckbox);
        detailsPanel.add(this.showStackTraceCheckbox);
        detailsPanel.add(this.usingWrappedExceptionStyleCheckbox);
        this.lookAndFeelCombo.setBorder(new TitledBorder(new EtchedBorder(1), "Look & Feel"));
        this.defaultConditionCombo.setBorder(new TitledBorder(new EtchedBorder(1), "Default search condition"));
        JPanel globalPanel = new JPanel(new GridLayout(4, 1));
        globalPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Global settings"));
        globalPanel.add(this.globalLoggingEnabledCheckbox);
        globalPanel.add(this.loggingStatsEnabledCheckbox);
        globalPanel.add(this.trayActiveCheckbox);
        globalPanel.add(this.hidingOnCloseCheckbox);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.gridwidth = 1;
        gbc2.weightx = 1.0;
        gbc2.anchor = 23;
        gbc2.fill = 2;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        this.add((Component)viewPanel, gbc2);
        gbc2.gridy = 1;
        this.add((Component)detailsPanel, gbc2);
        gbc2.gridy = 2;
        this.add((Component)this.lookAndFeelCombo, gbc2);
        gbc2.gridy = 3;
        this.add((Component)this.defaultConditionCombo, gbc2);
        gbc2.gridy = 4;
        this.add((Component)appPathPanel, gbc2);
        gbc2.gridy = 5;
        gbc2.weighty = 1.0;
        this.add((Component)globalPanel, gbc2);
    }

    public void initUI() {
        int idx;
        this.scrollingToBottomCheckbox.setSelected(this.applicationPreferences.isScrollingToBottom());
        this.coloringWholeRowCheckbox.setSelected(this.applicationPreferences.isColoringWholeRow());
        this.showFullCallstackCheckbox.setSelected(this.applicationPreferences.isShowingFullCallstack());
        this.showStackTraceCheckbox.setSelected(this.applicationPreferences.isShowingStackTrace());
        this.usingWrappedExceptionStyleCheckbox.setSelected(this.applicationPreferences.isUsingWrappedExceptionStyle());
        ArrayList<String> lookAndFeels = new ArrayList<String>();
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            lookAndFeels.add(info.getName());
        }
        Collections.sort(lookAndFeels);
        int selectedIndex = 0;
        String lookAndFeel = this.applicationPreferences.getLookAndFeel();
        if (lookAndFeel == null || "".equals(lookAndFeel)) {
            lookAndFeel = UIManager.getLookAndFeel().getName();
        }
        if ((idx = lookAndFeels.indexOf(lookAndFeel)) > -1) {
            selectedIndex = idx;
        } else {
            idx = lookAndFeels.indexOf(ApplicationPreferences.STARTUP_LOOK_AND_FEEL);
            if (idx > -1) {
                selectedIndex = idx;
            }
        }
        this.lookAndFeelCombo.setModel(new DefaultComboBoxModel<Object>(lookAndFeels.toArray()));
        this.lookAndFeelCombo.setSelectedIndex(selectedIndex);
        List<String> conditionNames = this.applicationPreferences.retrieveAllConditions();
        String defaultName = this.applicationPreferences.getDefaultConditionName();
        int idx2 = conditionNames.indexOf(defaultName);
        if (idx2 < 0) {
            idx2 = 0;
        }
        this.defaultConditionCombo.setModel(new DefaultComboBoxModel<Object>(conditionNames.toArray()));
        this.defaultConditionCombo.setSelectedIndex(idx2);
        String appPath = this.applicationPreferences.getApplicationPath().getAbsolutePath();
        this.appPathTextField.setText(appPath);
        this.appPathTextField.setToolTipText(appPath);
        this.globalLoggingEnabledCheckbox.setSelected(this.applicationPreferences.isGlobalLoggingEnabled());
        this.loggingStatsEnabledCheckbox.setSelected(this.applicationPreferences.isLoggingStatisticEnabled());
        this.trayActiveCheckbox.setSelected(this.applicationPreferences.isTrayActive());
        this.trayActiveCheckbox.setEnabled(TraySupport.isAvailable());
        this.hidingOnCloseCheckbox.setSelected(this.applicationPreferences.isHidingOnClose());
        this.hidingOnCloseCheckbox.setEnabled(TraySupport.isAvailable());
    }

    public void saveSettings() {
        this.applicationPreferences.setScrollingToBottom(this.scrollingToBottomCheckbox.isSelected());
        this.applicationPreferences.setColoringWholeRow(this.coloringWholeRowCheckbox.isSelected());
        this.applicationPreferences.setShowingFullCallstack(this.showFullCallstackCheckbox.isSelected());
        this.applicationPreferences.setShowingStackTrace(this.showStackTraceCheckbox.isSelected());
        this.applicationPreferences.setUsingWrappedExceptionStyle(this.usingWrappedExceptionStyleCheckbox.isSelected());
        this.applicationPreferences.setLookAndFeel((String)this.lookAndFeelCombo.getSelectedItem());
        this.applicationPreferences.setDefaultConditionName((String)this.defaultConditionCombo.getSelectedItem());
        this.applicationPreferences.setApplicationPath(new File(this.appPathTextField.getText()));
        this.applicationPreferences.setGlobalLoggingEnabled(this.globalLoggingEnabledCheckbox.isSelected());
        this.applicationPreferences.setLoggingStatisticEnabled(this.loggingStatsEnabledCheckbox.isSelected());
        this.applicationPreferences.setTrayActive(this.trayActiveCheckbox.isSelected());
        this.applicationPreferences.setHidingOnClose(this.hidingOnCloseCheckbox.isSelected());
    }

    private class BrowseApplicationPathAction
    extends AbstractAction {
        private static final long serialVersionUID = -5563121695654253673L;

        public BrowseApplicationPathAction() {
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/actions/document-open.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Browse for the application path.");
        }

        public void actionPerformed(ActionEvent e) {
            GeneralPanel.this.applicationPathFileChooser.setCurrentDirectory(GeneralPanel.this.applicationPreferences.getApplicationPath());
            int returnVal = GeneralPanel.this.applicationPathFileChooser.showDialog(GeneralPanel.this.preferencesDialog, "Select");
            if (returnVal == 0) {
                File file = GeneralPanel.this.applicationPathFileChooser.getSelectedFile();
                String appPath = file.getAbsolutePath();
                GeneralPanel.this.appPathTextField.setText(appPath);
                GeneralPanel.this.appPathTextField.setToolTipText(appPath);
            }
        }
    }
}

