/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import de.huxhorn.lilith.swing.EventWrapperViewPanel;
import de.huxhorn.lilith.swing.LilithKeyStrokes;
import de.huxhorn.lilith.swing.preferences.GenericSortedListModel;
import de.huxhorn.lilith.swing.preferences.PreferencesDialog;
import de.huxhorn.lilith.swing.preferences.Source;
import de.huxhorn.lilith.swing.preferences.SourceCellRenderer;
import de.huxhorn.sulky.swing.KeyStrokes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditSourceListDialog
extends JDialog {
    private final Logger logger = LoggerFactory.getLogger(EditSourceListDialog.class);
    private JList sourceList;
    private JList listList;
    private boolean adding;
    private boolean canceled;
    private JTextField sourceListName;
    private GenericSortedListModel<Source> sourcesListModel;
    private GenericSortedListModel<Source> listModel;
    private PreferencesDialog preferencesDialog;
    private AddSourceAction addSourceAction;
    private RemoveSourceAction removeSourceAction;
    private OkAction okAction;

    public EditSourceListDialog(PreferencesDialog owner) {
        super(owner);
        this.preferencesDialog = owner;
        this.setModal(true);
        this.createUi();
    }

    private void createUi() {
        this.okAction = new OkAction();
        CancelAction cancelAction = new CancelAction();
        this.sourceListName = new JTextField(25);
        this.sourceListName.addKeyListener(new NameKeyListener());
        SourceCellRenderer sourceCellRenderer = new SourceCellRenderer();
        this.sourcesListModel = new GenericSortedListModel();
        this.listModel = new GenericSortedListModel();
        this.sourceList = new JList<Source>(this.sourcesListModel);
        this.listList = new JList<Source>(this.listModel);
        this.sourceList.setCellRenderer(sourceCellRenderer);
        this.listList.setCellRenderer(sourceCellRenderer);
        this.sourceList.addMouseListener(new SourcesListMouseListener());
        this.listList.addMouseListener(new ListListMouseListener());
        JScrollPane sourceListScrollPane = new JScrollPane(this.sourceList);
        sourceListScrollPane.setBorder(new TitledBorder("Sources"));
        JScrollPane listScrollPane = new JScrollPane(this.listList);
        listScrollPane.setBorder(new TitledBorder("List content"));
        this.addSourceAction = new AddSourceAction();
        this.removeSourceAction = new RemoveSourceAction();
        JToolBar sourceToolbar = new JToolBar();
        sourceToolbar.setFloatable(false);
        JButton addSourceButton = new JButton(this.addSourceAction);
        JButton removeSourceButton = new JButton(this.removeSourceAction);
        sourceToolbar.add(addSourceButton);
        sourceToolbar.add(removeSourceButton);
        this.sourceList.addListSelectionListener(new SourceListSelectionListener());
        this.listList.addListSelectionListener(new ListListSelectionListener());
        JPanel listsPanel = new JPanel(new GridLayout(1, 2));
        listsPanel.add(sourceListScrollPane);
        listsPanel.add(listScrollPane);
        JPanel centerPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        centerPanel.add((Component)sourceToolbar, gbc);
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.fill = 1;
        centerPanel.add((Component)listsPanel, gbc);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 5, 0, 0);
        mainPanel.add((Component)new JLabel("Source List Name: "), gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        mainPanel.add((Component)this.sourceListName, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        mainPanel.add((Component)centerPanel, gbc);
        this.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(new JButton(this.okAction));
        buttonPanel.add(new JButton(cancelAction));
        this.add((Component)buttonPanel, "South");
        KeyStrokes.registerCommand((JComponent)mainPanel, (Action)cancelAction, (String)"CANCEL_ACTION");
        KeyStrokes.registerCommand((JComponent)buttonPanel, (Action)cancelAction, (String)"CANCEL_ACTION");
    }

    public void setAdding(boolean adding) {
        this.adding = adding;
        if (adding) {
            this.setTitle("Add a source list...");
        } else {
            this.setTitle("Edit a source list...");
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.initUI();
            this.sourceListName.requestFocusInWindow();
        }
        super.setVisible(b);
    }

    private void initUI() {
        HashMap<String, String> sourceNames = new HashMap<String, String>(this.preferencesDialog.getSourceNames());
        ArrayList<Source> sourcesList = new ArrayList<Source>();
        for (Map.Entry current : sourceNames.entrySet()) {
            Source source = new Source();
            source.setIdentifier((String)current.getKey());
            source.setName((String)current.getValue());
            sourcesList.add(source);
        }
        this.sourcesListModel.setData(sourcesList);
        this.updateActions();
    }

    private void updateActions() {
        this.okAction.update();
        this.addSourceAction.update();
        this.removeSourceAction.update();
    }

    public boolean isAdding() {
        return this.adding;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setSourceListName(String sourceName) {
        this.sourceListName.setText(sourceName);
    }

    public String getSourcListeName() {
        return this.sourceListName.getText();
    }

    public void setSources(List<Source> sources) {
        this.listModel.setData(sources);
    }

    public List<Source> getSources() {
        return this.listModel.getData();
    }

    private class NameKeyListener
    implements KeyListener {
        private NameKeyListener() {
        }

        public void keyTyped(KeyEvent e) {
            EditSourceListDialog.this.updateActions();
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    private class ListListSelectionListener
    implements ListSelectionListener {
        private ListListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            EditSourceListDialog.this.updateActions();
        }
    }

    private class SourceListSelectionListener
    implements ListSelectionListener {
        private SourceListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            EditSourceListDialog.this.updateActions();
        }
    }

    private class RemoveSourceAction
    extends AbstractAction {
        public RemoveSourceAction() {
            super("Remove");
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/actions/list-remove.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Remove the selected source(s).");
        }

        public void update() {
            this.setEnabled(!EditSourceListDialog.this.listList.isSelectionEmpty());
        }

        public void actionPerformed(ActionEvent e) {
            Object[] selected;
            if (EditSourceListDialog.this.logger.isDebugEnabled()) {
                EditSourceListDialog.this.logger.debug("Remove");
            }
            if ((selected = EditSourceListDialog.this.listList.getSelectedValues()) != null && selected.length > 0) {
                for (Object o : selected) {
                    EditSourceListDialog.this.listModel.remove((Source)o);
                }
            }
            EditSourceListDialog.this.updateActions();
        }
    }

    private class AddSourceAction
    extends AbstractAction {
        public AddSourceAction() {
            super("Add");
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/actions/list-add.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Add the selected source(s).");
        }

        public void update() {
            this.setEnabled(!EditSourceListDialog.this.sourceList.isSelectionEmpty());
        }

        public void actionPerformed(ActionEvent e) {
            Object[] selected;
            if (EditSourceListDialog.this.logger.isDebugEnabled()) {
                EditSourceListDialog.this.logger.debug("Add");
            }
            if ((selected = EditSourceListDialog.this.sourceList.getSelectedValues()) != null && selected.length > 0) {
                for (Object o : selected) {
                    EditSourceListDialog.this.listModel.add((Source)o);
                }
            }
            EditSourceListDialog.this.updateActions();
        }
    }

    private class ListListMouseListener
    extends MouseAdapter {
        private ListListMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            Source source;
            int index;
            if (e.getClickCount() > 1 && (index = EditSourceListDialog.this.listList.locationToIndex(e.getPoint())) != -1 && (source = (Source)EditSourceListDialog.this.listModel.getElementAt(index)) != null) {
                EditSourceListDialog.this.listModel.remove(source);
            }
        }
    }

    private class SourcesListMouseListener
    extends MouseAdapter {
        private SourcesListMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            Source source;
            int index;
            if (e.getClickCount() > 1 && (index = EditSourceListDialog.this.sourceList.locationToIndex(e.getPoint())) != -1 && (source = (Source)EditSourceListDialog.this.sourcesListModel.getElementAt(index)) != null) {
                EditSourceListDialog.this.listModel.add(source);
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("ESCAPE");
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            EditSourceListDialog.this.canceled = true;
            EditSourceListDialog.this.setVisible(false);
        }
    }

    private class OkAction
    extends AbstractAction {
        public OkAction() {
            super("Ok");
        }

        public void update() {
            String name = EditSourceListDialog.this.sourceListName.getText();
            if (name != null && !"".equals(name.trim())) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent e) {
            String name = EditSourceListDialog.this.sourceListName.getText();
            if (name != null && !"".equals(name.trim())) {
                EditSourceListDialog.this.canceled = false;
                EditSourceListDialog.this.setVisible(false);
            }
        }
    }
}

