/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.swing.LilithKeyStrokes;
import de.huxhorn.lilith.swing.preferences.ColorSchemeEditorPanel;
import de.huxhorn.lilith.swing.table.ColorScheme;
import de.huxhorn.sulky.swing.KeyStrokes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditLoggingLevelDialog
extends JDialog {
    private final Logger logger = LoggerFactory.getLogger(EditLoggingLevelDialog.class);
    private ColorScheme scheme;
    private boolean canceled;
    private ColorSchemeEditorPanel colorSchemeEditorPanel;

    public EditLoggingLevelDialog(Dialog owner) {
        super(owner);
        this.setModal(true);
        this.createUi();
    }

    private void createUi() {
        OkAction okAction = new OkAction();
        CancelAction cancelAction = new CancelAction();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.colorSchemeEditorPanel = new ColorSchemeEditorPanel();
        mainPanel.add((Component)this.colorSchemeEditorPanel, gbc);
        this.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(new JButton(okAction));
        buttonPanel.add(new JButton(new ResetAction()));
        buttonPanel.add(new JButton(cancelAction));
        this.add((Component)buttonPanel, "South");
        KeyStrokes.registerCommand((JComponent)mainPanel, (Action)cancelAction, (String)"CANCEL_ACTION");
        KeyStrokes.registerCommand((JComponent)buttonPanel, (Action)cancelAction, (String)"CANCEL_ACTION");
    }

    public void setVisible(boolean b) {
        if (b) {
            this.initUI();
        }
        super.setVisible(b);
    }

    public ColorScheme getScheme() {
        return this.scheme;
    }

    public void setScheme(ColorScheme scheme) {
        this.scheme = scheme;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void initUI() {
        if (this.scheme == null) {
            this.scheme = new ColorScheme().initDefaults();
        }
        this.colorSchemeEditorPanel.setColorScheme(this.scheme);
    }

    public void setLevel(LoggingEvent.Level level) {
        this.setTitle("Edit colors for " + level + "...");
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 5442950514112749763L;

        public CancelAction() {
            super("Cancel");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("ESCAPE");
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            EditLoggingLevelDialog.this.canceled = true;
            EditLoggingLevelDialog.super.setVisible(false);
        }
    }

    private class ResetAction
    extends AbstractAction {
        private static final long serialVersionUID = 3523022122100092148L;

        public ResetAction() {
            super("Reset");
        }

        public void actionPerformed(ActionEvent e) {
            EditLoggingLevelDialog.this.initUI();
        }
    }

    private class OkAction
    extends AbstractAction {
        private static final long serialVersionUID = -7380136684827113354L;

        public OkAction() {
            super("Ok");
        }

        public void actionPerformed(ActionEvent e) {
            EditLoggingLevelDialog.this.canceled = false;
            EditLoggingLevelDialog.this.colorSchemeEditorPanel.saveColors();
            EditLoggingLevelDialog.this.scheme = EditLoggingLevelDialog.this.colorSchemeEditorPanel.getColorScheme();
            EditLoggingLevelDialog.super.setVisible(false);
        }
    }
}

