/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.menu;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.Message;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.actions.AbstractLoggingFilterAction;
import de.huxhorn.lilith.swing.actions.EventWrapperRelated;
import de.huxhorn.lilith.swing.actions.FilterAction;
import de.huxhorn.lilith.swing.actions.FocusNDCAction;
import de.huxhorn.lilith.swing.actions.FocusNDCPatternAction;
import de.huxhorn.lilith.swing.actions.ViewContainerRelated;
import javax.swing.JMenu;

public class FocusNDCMenu
extends JMenu
implements ViewContainerRelated,
EventWrapperRelated {
    private static final long serialVersionUID = 2934068317229029302L;
    private ViewContainer viewContainer;
    private Message[] ndc;

    public FocusNDCMenu() {
        super("NDC");
        this.setToolTipText("Nested Diagnostic Context");
        this.setViewContainer(null);
        this.setEventWrapper(null);
    }

    public void setViewContainer(ViewContainer viewContainer) {
        this.viewContainer = viewContainer;
        this.updateState();
    }

    public ViewContainer getViewContainer() {
        return this.viewContainer;
    }

    public void setEventWrapper(EventWrapper eventWrapper) {
        Message[] ndc = null;
        LoggingEvent loggingEvent = AbstractLoggingFilterAction.resolveLoggingEvent(eventWrapper);
        if (loggingEvent != null) {
            ndc = loggingEvent.getNdc();
        }
        this.setNdc(ndc);
    }

    public void setNdc(Message[] ndc) {
        this.ndc = ndc;
        this.updateState();
    }

    private void updateState() {
        this.removeAll();
        if (this.viewContainer == null || this.ndc == null || this.ndc.length == 0) {
            this.setEnabled(false);
            return;
        }
        boolean first = true;
        for (Message current : this.ndc) {
            String message = current.getMessage();
            String messagePattern = current.getMessagePattern();
            if (message == null) continue;
            if (first) {
                first = false;
            } else {
                this.addSeparator();
            }
            this.add(this.createMessageAction(this.viewContainer, message));
            if (message.equals(messagePattern)) continue;
            this.add(this.createMessagePatternAction(this.viewContainer, messagePattern));
        }
        this.setEnabled(true);
    }

    protected FilterAction createMessageAction(ViewContainer viewContainer, String message) {
        return new FocusNDCAction(viewContainer, message);
    }

    protected FilterAction createMessagePatternAction(ViewContainer viewContainer, String pattern) {
        return new FocusNDCPatternAction(viewContainer, pattern);
    }
}

