/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.menu;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.actions.AbstractLoggingFilterAction;
import de.huxhorn.lilith.swing.actions.EventWrapperRelated;
import de.huxhorn.lilith.swing.actions.FilterAction;
import de.huxhorn.lilith.swing.actions.FocusMDCAction;
import de.huxhorn.lilith.swing.actions.ViewContainerRelated;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FocusMDCMenu
extends JMenu
implements ViewContainerRelated,
EventWrapperRelated {
    private static final long serialVersionUID = -1383728062587884548L;
    private SortedMap<String, String> mdc;
    private ViewContainer viewContainer;

    public FocusMDCMenu() {
        super("MDC");
        this.setToolTipText("Mapped Diagnostic Context");
        this.setViewContainer(null);
        this.setEventWrapper(null);
    }

    @Override
    public void setViewContainer(ViewContainer viewContainer) {
        this.viewContainer = viewContainer;
        this.updateState();
    }

    @Override
    public ViewContainer getViewContainer() {
        return this.viewContainer;
    }

    @Override
    public void setEventWrapper(EventWrapper eventWrapper) {
        Map mdc;
        TreeMap sorted = null;
        LoggingEvent loggingEvent = AbstractLoggingFilterAction.resolveLoggingEvent(eventWrapper);
        if (loggingEvent != null && (mdc = loggingEvent.getMdc()) != null && !mdc.isEmpty()) {
            sorted = new TreeMap(mdc);
        }
        this.setMdc(sorted);
    }

    public void setMdc(SortedMap<String, String> mdc) {
        this.mdc = mdc;
        this.updateState();
    }

    private void updateState() {
        this.removeAll();
        if (this.viewContainer == null || this.mdc == null || this.mdc.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        for (Map.Entry<String, String> entry : this.mdc.entrySet()) {
            this.add(this.createAction(this.viewContainer, entry.getKey(), entry.getValue()));
        }
        this.setEnabled(true);
    }

    protected FilterAction createAction(ViewContainer viewContainer, String key, String value) {
        return new FocusMDCAction(viewContainer, key, value);
    }
}

