/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.menu;

import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.actions.FocusLevelAction;
import de.huxhorn.lilith.swing.actions.ViewContainerRelated;
import javax.swing.JMenu;

public class FocusLevelMenu
extends JMenu
implements ViewContainerRelated {
    private static final long serialVersionUID = 5642118791633046024L;
    private final FocusLevelAction[] levelActions;
    private ViewContainer viewContainer;

    public FocusLevelMenu() {
        super("Level");
        this.setViewContainer(null);
        LoggingEvent.Level[] values = LoggingEvent.Level.values();
        this.levelActions = new FocusLevelAction[values.length - 1];
        for (int i = 0; i < values.length - 1; ++i) {
            this.levelActions[i] = new FocusLevelAction(values[i + 1]);
            this.add(this.levelActions[i]);
        }
    }

    public void setViewContainer(ViewContainer viewContainer) {
        this.viewContainer = viewContainer;
        this.updateState();
    }

    public ViewContainer getViewContainer() {
        return this.viewContainer;
    }

    private void updateState() {
        if (this.viewContainer == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
        for (FocusLevelAction current : this.levelActions) {
            current.setViewContainer(this.viewContainer);
        }
    }
}

