/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.menu;

import de.huxhorn.lilith.data.access.HttpStatus;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.actions.FilterAction;
import de.huxhorn.lilith.swing.actions.FocusHttpStatusTypeAction;
import de.huxhorn.lilith.swing.actions.ViewContainerRelated;
import javax.swing.JMenu;

public class FocusHttpStatusTypeMenu
extends JMenu
implements ViewContainerRelated {
    private static final long serialVersionUID = -6987929141687901690L;
    private final FilterAction[] statusTypeActions;
    private ViewContainer viewContainer;

    public FocusHttpStatusTypeMenu() {
        super("Status Type");
        this.setViewContainer(null);
        HttpStatus.Type[] values = HttpStatus.Type.values();
        this.statusTypeActions = new FilterAction[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.statusTypeActions[i] = this.createAction(values[i]);
            this.add(this.statusTypeActions[i]);
        }
    }

    protected FilterAction createAction(HttpStatus.Type type) {
        return new FocusHttpStatusTypeAction(type);
    }

    public void setViewContainer(ViewContainer viewContainer) {
        this.viewContainer = viewContainer;
        this.updateState();
    }

    public ViewContainer getViewContainer() {
        return this.viewContainer;
    }

    private void updateState() {
        if (this.viewContainer == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
        for (FilterAction current : this.statusTypeActions) {
            current.setViewContainer(this.viewContainer);
        }
    }
}

