/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.menu;

import de.huxhorn.lilith.data.access.AccessEvent;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.actions.AbstractAccessFilterAction;
import de.huxhorn.lilith.swing.actions.AbstractLoggingFilterAction;
import de.huxhorn.lilith.swing.actions.EventWrapperRelated;
import de.huxhorn.lilith.swing.actions.FilterAction;
import de.huxhorn.lilith.swing.actions.FocusCallLocationAction;
import de.huxhorn.lilith.swing.actions.FocusFormattedMessageAction;
import de.huxhorn.lilith.swing.actions.FocusHttpMethodAction;
import de.huxhorn.lilith.swing.actions.FocusHttpRemoteUserAction;
import de.huxhorn.lilith.swing.actions.FocusHttpRequestUriAction;
import de.huxhorn.lilith.swing.actions.FocusHttpRequestUrlAction;
import de.huxhorn.lilith.swing.actions.FocusHttpStatusCodeAction;
import de.huxhorn.lilith.swing.actions.FocusMessagePatternAction;
import de.huxhorn.lilith.swing.actions.NegateFilterAction;
import de.huxhorn.lilith.swing.actions.ViewContainerRelated;
import de.huxhorn.lilith.swing.menu.ExcludeHttpStatusTypeMenu;
import de.huxhorn.lilith.swing.menu.ExcludeLoggerMenu;
import de.huxhorn.lilith.swing.menu.ExcludeMDCMenu;
import de.huxhorn.lilith.swing.menu.ExcludeMarkerMenu;
import de.huxhorn.lilith.swing.menu.ExcludeNDCMenu;
import de.huxhorn.lilith.swing.menu.ExcludeSavedConditionsMenu;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcludeMenu
extends JMenu
implements ViewContainerRelated,
EventWrapperRelated {
    private static final long serialVersionUID = -663125573199455498L;
    private final ApplicationPreferences applicationPreferences;
    private EventWrapper eventWrapper;
    private ExcludeSavedConditionsMenu savedMenu;
    private FilterAction messagePatternAction;
    private JMenuItem messagePatternItem;
    private FilterAction formattedMessageAction;
    private JMenuItem formattedMessageItem;
    private FilterAction callLocationAction;
    private JMenuItem callLocationItem;
    private ExcludeMDCMenu mdcMenu;
    private ExcludeMarkerMenu markerMenu;
    private ExcludeNDCMenu ndcMenu;
    private ExcludeLoggerMenu loggerMenu;
    private FilterAction statusCodeAction;
    private JMenuItem statusCodeItem;
    private ExcludeHttpStatusTypeMenu statusTypeMenu;
    private FilterAction methodAction;
    private JMenuItem methodItem;
    private FilterAction requestUriAction;
    private JMenuItem requestUriItem;
    private FilterAction requestUrlAction;
    private JMenuItem requestUrlItem;
    private FilterAction remoteUserAction;
    private JMenuItem remoteUserItem;
    private ViewContainer viewContainer;

    public ExcludeMenu(ApplicationPreferences applicationPreferences) {
        super("Exclude");
        this.applicationPreferences = applicationPreferences;
        this.createUI();
        this.setViewContainer(null);
        this.setEventWrapper(null);
    }

    private void createUI() {
        this.savedMenu = new ExcludeSavedConditionsMenu(this.applicationPreferences);
        this.messagePatternAction = new NegateFilterAction(new FocusMessagePatternAction());
        this.formattedMessageAction = new NegateFilterAction(new FocusFormattedMessageAction());
        this.callLocationAction = new NegateFilterAction(new FocusCallLocationAction());
        this.messagePatternItem = new JMenuItem(this.messagePatternAction);
        this.formattedMessageItem = new JMenuItem(this.formattedMessageAction);
        this.callLocationItem = new JMenuItem(this.callLocationAction);
        this.mdcMenu = new ExcludeMDCMenu();
        this.markerMenu = new ExcludeMarkerMenu();
        this.ndcMenu = new ExcludeNDCMenu();
        this.loggerMenu = new ExcludeLoggerMenu();
        this.statusCodeAction = new NegateFilterAction(new FocusHttpStatusCodeAction());
        this.statusCodeItem = new JMenuItem(this.statusCodeAction);
        this.statusTypeMenu = new ExcludeHttpStatusTypeMenu();
        this.methodAction = new NegateFilterAction(new FocusHttpMethodAction());
        this.methodItem = new JMenuItem(this.methodAction);
        this.requestUriAction = new NegateFilterAction(new FocusHttpRequestUriAction());
        this.requestUriItem = new JMenuItem(this.requestUriAction);
        this.requestUrlAction = new NegateFilterAction(new FocusHttpRequestUrlAction());
        this.requestUrlItem = new JMenuItem(this.requestUrlAction);
        this.remoteUserAction = new NegateFilterAction(new FocusHttpRemoteUserAction());
        this.remoteUserItem = new JMenuItem(this.remoteUserAction);
    }

    @Override
    public void setEventWrapper(EventWrapper eventWrapper) {
        this.eventWrapper = eventWrapper;
        this.messagePatternAction.setEventWrapper(eventWrapper);
        this.formattedMessageAction.setEventWrapper(eventWrapper);
        this.callLocationAction.setEventWrapper(eventWrapper);
        this.mdcMenu.setEventWrapper(eventWrapper);
        this.markerMenu.setEventWrapper(eventWrapper);
        this.ndcMenu.setEventWrapper(eventWrapper);
        this.loggerMenu.setEventWrapper(eventWrapper);
        this.statusCodeAction.setEventWrapper(eventWrapper);
        this.methodAction.setEventWrapper(eventWrapper);
        this.requestUriAction.setEventWrapper(eventWrapper);
        this.requestUrlAction.setEventWrapper(eventWrapper);
        this.remoteUserAction.setEventWrapper(eventWrapper);
        this.updateState();
    }

    @Override
    public void setViewContainer(ViewContainer viewContainer) {
        this.viewContainer = viewContainer;
        this.savedMenu.setViewContainer(viewContainer);
        this.messagePatternAction.setViewContainer(viewContainer);
        this.formattedMessageAction.setViewContainer(viewContainer);
        this.callLocationAction.setViewContainer(viewContainer);
        this.mdcMenu.setViewContainer(viewContainer);
        this.markerMenu.setViewContainer(viewContainer);
        this.ndcMenu.setViewContainer(viewContainer);
        this.loggerMenu.setViewContainer(viewContainer);
        this.statusCodeAction.setViewContainer(viewContainer);
        this.statusTypeMenu.setViewContainer(viewContainer);
        this.methodAction.setViewContainer(viewContainer);
        this.requestUriAction.setViewContainer(viewContainer);
        this.requestUrlAction.setViewContainer(viewContainer);
        this.remoteUserAction.setViewContainer(viewContainer);
        this.updateState();
    }

    @Override
    public ViewContainer getViewContainer() {
        return this.viewContainer;
    }

    private void updateState() {
        EventWrapper wrapper = this.eventWrapper;
        this.removeAll();
        LoggingEvent loggingEvent = AbstractLoggingFilterAction.resolveLoggingEvent(wrapper);
        if (loggingEvent != null) {
            this.add(this.savedMenu);
            this.addSeparator();
            this.add(this.messagePatternItem);
            this.add(this.formattedMessageItem);
            this.addSeparator();
            this.add(this.callLocationItem);
            this.addSeparator();
            this.add(this.mdcMenu);
            this.add(this.markerMenu);
            this.add(this.ndcMenu);
            this.addSeparator();
            this.add(this.loggerMenu);
            this.setEnabled(this.messagePatternItem.isEnabled() || this.formattedMessageItem.isEnabled() || this.callLocationItem.isEnabled() || this.mdcMenu.isEnabled() || this.markerMenu.isEnabled() || this.loggerMenu.isEnabled() || this.savedMenu.isEnabled());
            return;
        }
        AccessEvent accessEvent = AbstractAccessFilterAction.resolveAccessEvent(this.eventWrapper);
        if (accessEvent != null) {
            this.add(this.savedMenu);
            this.addSeparator();
            this.add(this.statusCodeItem);
            this.add(this.statusTypeMenu);
            this.addSeparator();
            this.add(this.methodItem);
            this.addSeparator();
            this.add(this.requestUriItem);
            this.add(this.requestUrlItem);
            this.addSeparator();
            this.add(this.remoteUserItem);
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    public void setConditionNames(List<String> conditionNames) {
        this.savedMenu.setConditionNames(conditionNames);
    }
}

