/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.callables;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.swing.EventWrapperViewPanel;
import de.huxhorn.lilith.swing.table.model.EventWrapperTableModel;
import de.huxhorn.sulky.conditions.Condition;
import de.huxhorn.sulky.tasks.AbstractProgressingCallable;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindPreviousCallable<T extends Serializable>
extends AbstractProgressingCallable<Long> {
    private final Logger logger = LoggerFactory.getLogger(FindPreviousCallable.class);
    private int currentRow;
    private Condition condition;
    private EventWrapperTableModel<T> tableModel;
    private EventWrapperViewPanel<T> viewPanel;

    public FindPreviousCallable(EventWrapperViewPanel<T> viewPanel, int currentRow, Condition condition) {
        super(200L, 1000L);
        this.viewPanel = viewPanel;
        this.tableModel = viewPanel.getTableModel();
        this.currentRow = currentRow;
        this.condition = condition;
    }

    public EventWrapperViewPanel<T> getViewPanel() {
        return this.viewPanel;
    }

    public Long call() throws Exception {
        int row = this.currentRow;
        if (row > -1) {
            --row;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Searching previous starting at {}.", (Object)row);
            }
            this.tableModel.getRowCount();
            int maxCount = row;
            int numberOfSteps = maxCount - 1;
            if (numberOfSteps < 1) {
                numberOfSteps = 1;
            }
            this.setNumberOfSteps(numberOfSteps);
            for (int i = 0; i < maxCount; ++i) {
                Object obj;
                this.setCurrentStep(i);
                int current = row - i;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Processing row {}", (Object)current);
                }
                if ((obj = this.tableModel.getValueAt(current, 0)) == null) {
                    return -1L;
                }
                if (obj instanceof EventWrapper) {
                    if (!this.condition.isTrue(obj)) continue;
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Found previous at {}.", (Object)current);
                    }
                    return current;
                }
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn("Unexpected class! {}", (Object)obj.getClass().getName());
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Didn't find previous.");
        }
        return -1L;
    }
}

