/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.callables;

import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.callables.IndexingCallable;
import de.huxhorn.sulky.tasks.AbstractProgressingCallable;
import java.io.File;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckFileChangeCallable
extends AbstractProgressingCallable<Long> {
    private final Logger logger = LoggerFactory.getLogger(CheckFileChangeCallable.class);
    private File dataFile;
    private File indexFile;
    private static final int POLL_INTERVAL = 1000;
    private ViewContainer<?> viewContainer;
    private FlushRunnable flushRunnable;

    public CheckFileChangeCallable(File dataFile, File indexFile, ViewContainer<?> viewContainer) {
        this.dataFile = dataFile;
        this.indexFile = indexFile;
        this.viewContainer = viewContainer;
        this.flushRunnable = new FlushRunnable();
    }

    public Long call() throws Exception {
        this.setNumberOfSteps(-1L);
        while (true) {
            block6: {
                long indexModified;
                long dataModified;
                if ((dataModified = this.dataFile.lastModified()) > (indexModified = this.indexFile.lastModified())) {
                    try {
                        IndexingCallable indexing = new IndexingCallable(this.dataFile, this.indexFile, true);
                        indexing.call();
                        SwingUtilities.invokeAndWait(this.flushRunnable);
                    }
                    catch (IOException ex) {
                        if (!this.logger.isInfoEnabled()) break block6;
                        this.logger.info("Exception while reindexing log file. Ignoring it...", (Throwable)ex);
                    }
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                return 0L;
            }
        }
    }

    public String toString() {
        return this.dataFile.getAbsolutePath();
    }

    private class FlushRunnable
    implements Runnable {
        private FlushRunnable() {
        }

        public void run() {
            CheckFileChangeCallable.this.viewContainer.flush();
        }
    }
}

