/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.callables;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.engine.EventSource;
import de.huxhorn.lilith.swing.TextPreprocessor;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.buffers.FileBuffer;
import de.huxhorn.sulky.buffers.filtering.FilteringBuffer;
import de.huxhorn.sulky.conditions.Condition;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallableMetaData {
    public static final String FIND_TASK_META_CONDITION = "Condition";
    public static final String FIND_TASK_META_SOURCE_IDENTIFIER = "SourceIdentifier";
    public static final String FIND_TASK_META_START_ROW = "StartRow";
    public static final String FIND_TASK_META_DATA_FILE = "DataFile";

    public static <T extends Serializable> Map<String, String> createFindMetaData(Condition condition, EventSource<T> eventSource, int startRow) {
        String conditionStr = null;
        if (condition != null) {
            conditionStr = TextPreprocessor.formatCondition(condition);
        }
        Buffer buffer = null;
        String sourceIdentifierStr = null;
        if (eventSource != null) {
            buffer = eventSource.getBuffer();
            SourceIdentifier si = eventSource.getSourceIdentifier();
            if (si != null) {
                sourceIdentifierStr = si.toString();
            }
        }
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put(FIND_TASK_META_CONDITION, conditionStr);
        metaData.put(FIND_TASK_META_START_ROW, "" + startRow);
        if (sourceIdentifierStr != null) {
            metaData.put(FIND_TASK_META_SOURCE_IDENTIFIER, sourceIdentifierStr);
        }
        CallableMetaData.resolveDataFile(metaData, buffer);
        return metaData;
    }

    public static <T extends Serializable> Map<String, String> createFilteringMetaData(Condition condition, EventSource<T> eventSource) {
        String conditionStr = null;
        if (condition != null) {
            conditionStr = TextPreprocessor.formatCondition(condition);
        }
        Buffer buffer = null;
        String sourceIdentifierStr = null;
        if (eventSource != null) {
            buffer = eventSource.getBuffer();
            SourceIdentifier si = eventSource.getSourceIdentifier();
            if (si != null) {
                sourceIdentifierStr = si.toString();
            }
        }
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put(FIND_TASK_META_CONDITION, conditionStr);
        if (sourceIdentifierStr != null) {
            metaData.put(FIND_TASK_META_SOURCE_IDENTIFIER, sourceIdentifierStr);
        }
        CallableMetaData.resolveDataFile(metaData, buffer);
        return metaData;
    }

    private static <T extends Serializable> void resolveDataFile(Map<String, String> metaData, Buffer<EventWrapper<T>> buffer) {
        FileBuffer fileBuffer;
        File file;
        Buffer sourceBuffer = FilteringBuffer.resolveSourceBuffer(buffer);
        if (sourceBuffer instanceof FileBuffer && (file = (fileBuffer = (FileBuffer)sourceBuffer).getDataFile()) != null) {
            metaData.put(FIND_TASK_META_DATA_FILE, file.getAbsolutePath());
        }
    }
}

