/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.actions;

import de.huxhorn.lilith.conditions.HttpStatusCodeCondition;
import de.huxhorn.lilith.data.access.HttpStatus;
import de.huxhorn.lilith.swing.actions.AbstractAccessFilterAction;
import de.huxhorn.sulky.conditions.Condition;

public class FocusHttpStatusCodeAction
extends AbstractAccessFilterAction {
    private static final long serialVersionUID = -4237035769242851225L;
    private Integer statusCode;

    public FocusHttpStatusCodeAction() {
        super("Status code");
    }

    protected void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
        if (statusCode != null) {
            HttpStatus status = HttpStatus.getStatus((int)statusCode);
            if (status != null) {
                this.putValue("ShortDescription", status.getCode() + " - " + status.getDescription());
            } else {
                this.putValue("ShortDescription", statusCode);
            }
            this.setEnabled(true);
        } else {
            this.putValue("ShortDescription", null);
            this.setEnabled(false);
        }
    }

    protected void updateState() {
        if (this.viewContainer == null) {
            this.setStatusCode(null);
            return;
        }
        if (this.accessEvent != null) {
            int statusCode = this.accessEvent.getStatusCode();
            if (statusCode < 100 || statusCode >= 600) {
                this.setStatusCode(null);
            } else {
                this.setStatusCode(statusCode);
            }
        }
    }

    public Condition resolveCondition() {
        if (this.statusCode == null) {
            return null;
        }
        return new HttpStatusCodeCondition("" + this.statusCode);
    }
}

