/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.actions;

import de.huxhorn.lilith.conditions.HttpRequestUrlCondition;
import de.huxhorn.lilith.swing.TextPreprocessor;
import de.huxhorn.lilith.swing.actions.AbstractAccessFilterAction;
import de.huxhorn.sulky.conditions.Condition;

public class FocusHttpRequestUrlAction
extends AbstractAccessFilterAction {
    private static final long serialVersionUID = 4719237241681033351L;
    private String searchString;

    public FocusHttpRequestUrlAction() {
        super("Request URL");
    }

    protected void setSearchString(String searchString) {
        this.searchString = searchString;
        this.putValue("ShortDescription", TextPreprocessor.cropLine(searchString));
        this.setEnabled(searchString != null);
    }

    protected void updateState() {
        if (this.viewContainer == null) {
            this.setSearchString(null);
            return;
        }
        if (this.accessEvent != null) {
            this.setSearchString(this.accessEvent.getRequestURL());
        } else {
            this.setSearchString(null);
        }
    }

    public Condition resolveCondition() {
        if (this.searchString == null) {
            return null;
        }
        return new HttpRequestUrlCondition(this.searchString);
    }
}

