/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.data.access.AccessEvent;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.json.LoggingJsonEncoder;
import de.huxhorn.lilith.data.logging.xml.LoggingXmlEncoder;
import de.huxhorn.lilith.engine.EventSource;
import de.huxhorn.lilith.services.clipboard.AccessUriFormatter;
import de.huxhorn.lilith.services.clipboard.ClipboardFormatter;
import de.huxhorn.lilith.services.clipboard.ClipboardFormatterData;
import de.huxhorn.lilith.services.clipboard.GroovyFormatter;
import de.huxhorn.lilith.services.clipboard.LoggingCallLocationFormatter;
import de.huxhorn.lilith.services.clipboard.LoggingCallStackFormatter;
import de.huxhorn.lilith.services.clipboard.LoggingLoggerNameFormatter;
import de.huxhorn.lilith.services.clipboard.LoggingMarkerFormatter;
import de.huxhorn.lilith.services.clipboard.LoggingMdcFormatter;
import de.huxhorn.lilith.services.clipboard.LoggingMessageFormatter;
import de.huxhorn.lilith.services.clipboard.LoggingMessagePatternFormatter;
import de.huxhorn.lilith.services.clipboard.LoggingNdcFormatter;
import de.huxhorn.lilith.services.clipboard.LoggingThrowableFormatter;
import de.huxhorn.lilith.services.sender.EventSender;
import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.EventWrapperViewPanel;
import de.huxhorn.lilith.swing.Icons;
import de.huxhorn.lilith.swing.LilithKeyStrokes;
import de.huxhorn.lilith.swing.LoggingViewState;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.TextPreprocessor;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.ViewWindow;
import de.huxhorn.lilith.swing.menu.ExcludeMenu;
import de.huxhorn.lilith.swing.menu.FocusMenu;
import de.huxhorn.lilith.swing.table.EventWrapperViewTable;
import de.huxhorn.sulky.conditions.Condition;
import de.huxhorn.sulky.swing.KeyStrokes;
import de.huxhorn.sulky.swing.PersistentTableColumnModel;
import java.awt.AWTError;
import java.awt.Container;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;
import org.apache.commons.lang3.SystemUtils;
import org.simplericity.macify.eawt.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewActions {
    private final Logger logger = LoggerFactory.getLogger(ViewActions.class);
    private static final char ALT_SYMBOL = '\u2325';
    private static final char COMMAND_SYMBOL = '\u2318';
    private JToolBar toolbar;
    private JMenuBar menubar;
    private MainFrame mainFrame;
    private ViewContainer viewContainer;
    private JToggleButton scrollToBottomButton;
    private ExportMenuAction exportMenuAction;
    private AttachToolBarAction attachToolBarAction;
    private AttachMenuAction attachMenuAction;
    private DisconnectToolBarAction disconnectToolBarAction;
    private DisconnectMenuAction disconnectMenuAction;
    private PauseToolBarAction pauseToolBarAction;
    private PauseMenuAction pauseMenuAction;
    private FindPreviousAction findPreviousAction;
    private FindNextAction findNextAction;
    private FindPreviousActiveAction findPreviousActiveAction;
    private FindNextActiveAction findNextActiveAction;
    private ResetFindAction resetFindAction;
    private ScrollToBottomMenuAction scrollToBottomMenuAction;
    private EditSourceNameMenuAction editSourceNameMenuAction;
    private SaveLayoutAction saveLayoutAction;
    private ResetLayoutAction resetLayoutAction;
    private SaveConditionMenuAction saveConditionMenuAction;
    private ZoomInMenuAction zoomInMenuAction;
    private ZoomOutMenuAction zoomOutMenuAction;
    private ResetZoomMenuAction resetZoomMenuAction;
    private NextTabAction nextTabAction;
    private PreviousTabAction previousTabAction;
    private CloseFilterAction closeFilterAction;
    private CloseOtherFiltersAction closeOtherFiltersAction;
    private CloseAllFiltersAction closeAllFiltersAction;
    private RemoveInactiveAction removeInactiveAction;
    private CloseAllAction closeAllAction;
    private CloseOtherAction closeOtherAction;
    private MinimizeAllAction minimizeAllAction;
    private MinimizeAllOtherAction minimizeAllOtherAction;
    private JMenuItem removeInactiveItem;
    private JMenu windowMenu;
    private AboutAction aboutAction;
    private PreferencesMenuAction preferencesMenuAction;
    private FindMenuAction findMenuAction;
    private JMenu searchMenu;
    private JMenu viewMenu;
    private JMenu columnsMenu;
    private ClearMenuAction clearMenuAction;
    private FocusMessageAction focusMessageAction;
    private FocusEventsAction focusEventsAction;
    private ChangeListener containerChangeListener;
    private ScrollToBottomToolBarAction scrollToBottomToolBarAction;
    private ClearToolBarAction clearToolBarAction;
    private FindToolBarAction findToolBarAction;
    private CopySelectionAction copySelectionAction;
    private CopyToClipboardAction copyEventAction;
    private ShowUnfilteredEventAction showUnfilteredEventAction;
    private JPopupMenu popup;
    private GotoSourceAction gotoSourceAction;
    private JMenu sendToPopupMenu;
    private FocusMenu focusMenu;
    private ExcludeMenu excludeMenu;
    private FocusMenu focusPopupMenu;
    private ExcludeMenu excludePopupMenu;
    private JMenu filterPopupMenu;
    private JMenu copyPopupMenu;
    private PropertyChangeListener containerPropertyChangeListener;
    private EventWrapper eventWrapper;
    private JMenuItem showTaskManagerItem;
    private JMenuItem closeAllItem;
    private JMenuItem minimizeAllItem;
    private JMenuItem closeAllOtherItem;
    private JMenuItem minimizeAllOtherItem;
    private JMenu editMenu;
    private JMenu recentFilesMenu;
    private ClearRecentFilesAction clearRecentFilesAction;
    private JMenu customCopyMenu;
    private JMenu customCopyPopupMenu;
    private Map<String, CopyToClipboardAction> groovyClipboardActions;
    private Map<String, ClipboardFormatterData> groovyClipboardData;
    private List<CopyToClipboardAction> copyLoggingActions;
    private List<CopyToClipboardAction> copyAccessActions;
    private Map<KeyStroke, CopyToClipboardAction> keyStrokeActionMapping;

    public ViewActions(MainFrame mainFrame, ViewContainer viewContainer) {
        this(mainFrame);
        this.setViewContainer(viewContainer);
    }

    public ViewActions(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.containerChangeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ViewActions.this.updateActions();
            }
        };
        this.containerPropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedEvent".equals(evt.getPropertyName())) {
                    ViewActions.this.setEventWrapper((EventWrapper)evt.getNewValue());
                }
            }
        };
        this.keyStrokeActionMapping = new HashMap<KeyStroke, CopyToClipboardAction>();
        OpenMenuAction openMenuAction = new OpenMenuAction();
        this.clearRecentFilesAction = new ClearRecentFilesAction();
        OpenInactiveLogMenuAction openInactiveLogMenuAction = new OpenInactiveLogMenuAction();
        ImportMenuAction importMenuAction = new ImportMenuAction();
        this.exportMenuAction = new ExportMenuAction();
        CleanAllInactiveLogsMenuAction cleanAllInactiveLogsMenuAction = new CleanAllInactiveLogsMenuAction();
        this.preferencesMenuAction = new PreferencesMenuAction();
        ExitMenuAction exitMenuAction = new ExitMenuAction();
        this.showUnfilteredEventAction = new ShowUnfilteredEventAction();
        this.gotoSourceAction = new GotoSourceAction();
        this.copySelectionAction = new CopySelectionAction();
        this.copyEventAction = new CopyToClipboardAction(new EventFormatter());
        this.copyLoggingActions = new ArrayList<CopyToClipboardAction>();
        this.copyLoggingActions.add(new CopyToClipboardAction(new EventJsonFormatter()));
        this.copyLoggingActions.add(new CopyToClipboardAction(new EventXmlFormatter()));
        this.copyLoggingActions.add(new CopyToClipboardAction(new LoggingMessageFormatter()));
        this.copyLoggingActions.add(new CopyToClipboardAction(new LoggingMessagePatternFormatter()));
        this.copyLoggingActions.add(new CopyToClipboardAction(new LoggingLoggerNameFormatter()));
        this.copyLoggingActions.add(new CopyToClipboardAction(new LoggingThrowableFormatter()));
        this.copyLoggingActions.add(new CopyToClipboardAction(new LoggingCallStackFormatter()));
        this.copyLoggingActions.add(new CopyToClipboardAction(new LoggingCallLocationFormatter()));
        this.copyLoggingActions.add(new CopyToClipboardAction(new LoggingMarkerFormatter()));
        this.copyLoggingActions.add(new CopyToClipboardAction(new LoggingMdcFormatter()));
        this.copyLoggingActions.add(new CopyToClipboardAction(new LoggingNdcFormatter()));
        this.copyAccessActions = new ArrayList<CopyToClipboardAction>();
        this.copyAccessActions.add(new CopyToClipboardAction(new AccessUriFormatter()));
        this.prepareClipboardActions(this.copyLoggingActions, this.keyStrokeActionMapping);
        this.prepareClipboardActions(this.copyAccessActions, this.keyStrokeActionMapping);
        this.findMenuAction = new FindMenuAction();
        this.findPreviousAction = new FindPreviousAction();
        this.findNextAction = new FindNextAction();
        this.findPreviousActiveAction = new FindPreviousActiveAction();
        this.findNextActiveAction = new FindNextActiveAction();
        this.resetFindAction = new ResetFindAction();
        this.scrollToBottomMenuAction = new ScrollToBottomMenuAction();
        this.pauseMenuAction = new PauseMenuAction();
        this.clearMenuAction = new ClearMenuAction();
        this.attachMenuAction = new AttachMenuAction();
        this.disconnectMenuAction = new DisconnectMenuAction();
        this.focusMessageAction = new FocusMessageAction();
        this.focusEventsAction = new FocusEventsAction();
        this.editSourceNameMenuAction = new EditSourceNameMenuAction();
        this.saveLayoutAction = new SaveLayoutAction();
        this.resetLayoutAction = new ResetLayoutAction();
        this.saveConditionMenuAction = new SaveConditionMenuAction();
        this.zoomInMenuAction = new ZoomInMenuAction();
        this.zoomOutMenuAction = new ZoomOutMenuAction();
        this.resetZoomMenuAction = new ResetZoomMenuAction();
        this.previousTabAction = new PreviousTabAction();
        this.nextTabAction = new NextTabAction();
        this.closeFilterAction = new CloseFilterAction();
        this.closeOtherFiltersAction = new CloseOtherFiltersAction();
        this.closeAllFiltersAction = new CloseAllFiltersAction();
        ShowTaskManagerAction showTaskManagerAction = new ShowTaskManagerAction();
        this.closeAllAction = new CloseAllAction();
        this.closeOtherAction = new CloseOtherAction();
        this.minimizeAllAction = new MinimizeAllAction();
        this.minimizeAllOtherAction = new MinimizeAllOtherAction();
        this.removeInactiveAction = new RemoveInactiveAction();
        KeyboardHelpAction keyboardHelpAction = new KeyboardHelpAction();
        ShowLoveMenuAction showLoveMenuAction = new ShowLoveMenuAction();
        TipOfTheDayAction tipOfTheDayAction = new TipOfTheDayAction();
        DebugAction debugAction = new DebugAction();
        this.aboutAction = new AboutAction();
        CheckForUpdateAction checkForUpdateAction = new CheckForUpdateAction();
        TroubleshootingAction troubleshootingAction = new TroubleshootingAction();
        this.scrollToBottomToolBarAction = new ScrollToBottomToolBarAction();
        this.pauseToolBarAction = new PauseToolBarAction();
        this.clearToolBarAction = new ClearToolBarAction();
        this.findToolBarAction = new FindToolBarAction();
        this.attachToolBarAction = new AttachToolBarAction();
        this.disconnectToolBarAction = new DisconnectToolBarAction();
        this.showTaskManagerItem = new JMenuItem(showTaskManagerAction);
        this.closeAllItem = new JMenuItem(this.closeAllAction);
        this.closeAllOtherItem = new JMenuItem(this.closeOtherAction);
        this.minimizeAllItem = new JMenuItem(this.minimizeAllAction);
        this.minimizeAllOtherItem = new JMenuItem(this.minimizeAllOtherAction);
        this.removeInactiveItem = new JMenuItem(this.removeInactiveAction);
        this.toolbar = new JToolBar(0);
        this.toolbar.setFloatable(false);
        this.scrollToBottomButton = new JToggleButton(this.scrollToBottomToolBarAction);
        this.toolbar.add(this.scrollToBottomButton);
        JButton pauseButton = new JButton(this.pauseToolBarAction);
        this.toolbar.add(pauseButton);
        JButton clearButton = new JButton(this.clearToolBarAction);
        this.toolbar.add(clearButton);
        JButton findButton = new JButton(this.findToolBarAction);
        this.toolbar.add(findButton);
        JButton disconnectButton = new JButton(this.disconnectToolBarAction);
        this.toolbar.add(disconnectButton);
        this.toolbar.addSeparator();
        JButton attachButton = new JButton(this.attachToolBarAction);
        this.toolbar.add(attachButton);
        this.toolbar.addSeparator();
        PreferencesToolBarAction preferencesToolBarAction = new PreferencesToolBarAction();
        JButton preferencesButton = new JButton(preferencesToolBarAction);
        this.toolbar.add(preferencesButton);
        this.toolbar.addSeparator();
        ShowLoveToolbarAction showLoveToolbarAction = new ShowLoveToolbarAction();
        JButton showLoveButton = new JButton(showLoveToolbarAction);
        this.toolbar.add(showLoveButton);
        this.recentFilesMenu = new JMenu("Recent Files");
        Application app = mainFrame.getApplication();
        this.menubar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('f');
        fileMenu.add(openMenuAction);
        fileMenu.add(this.recentFilesMenu);
        fileMenu.add(openInactiveLogMenuAction);
        fileMenu.add(cleanAllInactiveLogsMenuAction);
        fileMenu.add(importMenuAction);
        fileMenu.add(this.exportMenuAction);
        if (!app.isMac()) {
            fileMenu.addSeparator();
            fileMenu.add(this.preferencesMenuAction);
            fileMenu.addSeparator();
            fileMenu.add(exitMenuAction);
        }
        this.editMenu = new JMenu("Edit");
        this.editMenu.setMnemonic('e');
        this.editMenu.add(this.copySelectionAction);
        this.editMenu.addSeparator();
        this.editMenu.add(this.copyEventAction);
        this.editMenu.addSeparator();
        for (CopyToClipboardAction current : this.copyLoggingActions) {
            this.editMenu.add(current);
        }
        this.editMenu.addSeparator();
        for (CopyToClipboardAction current : this.copyAccessActions) {
            this.editMenu.add(current);
        }
        this.editMenu.addSeparator();
        this.customCopyMenu = new JMenu("Custom copy");
        this.customCopyPopupMenu = new JMenu("Custom copy");
        this.editMenu.add(this.customCopyMenu);
        this.editMenu.addSeparator();
        PasteStackTraceElementAction pasteStackTraceElementAction = new PasteStackTraceElementAction();
        this.editMenu.add(pasteStackTraceElementAction);
        this.searchMenu = new JMenu("Search");
        this.searchMenu.setMnemonic('s');
        this.searchMenu.add(this.findMenuAction);
        this.searchMenu.add(this.resetFindAction);
        this.searchMenu.add(this.findPreviousAction);
        this.searchMenu.add(this.findNextAction);
        this.searchMenu.add(this.findPreviousActiveAction);
        this.searchMenu.add(this.findNextActiveAction);
        this.searchMenu.addSeparator();
        this.searchMenu.add(this.saveConditionMenuAction);
        this.searchMenu.addSeparator();
        this.focusMenu = new FocusMenu(mainFrame.getApplicationPreferences());
        this.excludeMenu = new ExcludeMenu(mainFrame.getApplicationPreferences());
        this.searchMenu.add(this.focusMenu);
        this.searchMenu.add(this.excludeMenu);
        this.viewMenu = new JMenu("View");
        this.viewMenu.setMnemonic('v');
        this.viewMenu.add(this.scrollToBottomMenuAction);
        this.viewMenu.add(this.pauseMenuAction);
        this.viewMenu.add(this.clearMenuAction);
        this.viewMenu.add(this.attachMenuAction);
        this.viewMenu.add(this.disconnectMenuAction);
        this.viewMenu.add(this.focusEventsAction);
        this.viewMenu.add(this.focusMessageAction);
        this.viewMenu.add(this.editSourceNameMenuAction);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.zoomInMenuAction);
        this.viewMenu.add(this.zoomOutMenuAction);
        this.viewMenu.add(this.resetZoomMenuAction);
        this.viewMenu.addSeparator();
        JMenu layoutMenu = new JMenu("Layout");
        this.columnsMenu = new JMenu("Columns");
        layoutMenu.add(this.columnsMenu);
        layoutMenu.addSeparator();
        layoutMenu.add(this.saveLayoutAction);
        layoutMenu.add(this.resetLayoutAction);
        this.viewMenu.add(layoutMenu);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.previousTabAction);
        this.viewMenu.add(this.nextTabAction);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.closeFilterAction);
        this.viewMenu.add(this.closeOtherFiltersAction);
        this.viewMenu.add(this.closeAllFiltersAction);
        this.windowMenu = new JMenu("Window");
        this.windowMenu.setMnemonic('w');
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('h');
        helpMenu.add(keyboardHelpAction);
        helpMenu.add(showLoveMenuAction);
        helpMenu.add(tipOfTheDayAction);
        helpMenu.add(checkForUpdateAction);
        helpMenu.add(troubleshootingAction);
        helpMenu.addSeparator();
        helpMenu.add(debugAction);
        if (!app.isMac()) {
            helpMenu.addSeparator();
            helpMenu.add(this.aboutAction);
        }
        this.menubar.add(fileMenu);
        this.menubar.add(this.editMenu);
        this.menubar.add(this.searchMenu);
        this.menubar.add(this.viewMenu);
        this.menubar.add(this.windowMenu);
        this.menubar.add(helpMenu);
        this.updateWindowMenu();
        this.updateRecentFiles();
        this.updateActions();
    }

    public PreferencesMenuAction getPreferencesAction() {
        return this.preferencesMenuAction;
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }

    public JMenuBar getMenuBar() {
        return this.menubar;
    }

    public void setViewContainer(ViewContainer viewContainer) {
        if (this.viewContainer != viewContainer) {
            if (this.viewContainer != null) {
                this.viewContainer.removeChangeListener(this.containerChangeListener);
                this.viewContainer.removePropertyChangeListener(this.containerPropertyChangeListener);
            }
            this.viewContainer = viewContainer;
            if (this.viewContainer != null) {
                this.viewContainer.addChangeListener(this.containerChangeListener);
                this.viewContainer.addPropertyChangeListener(this.containerPropertyChangeListener);
                this.setEventWrapper(this.viewContainer.getSelectedEvent());
            }
            this.updateActions();
        }
    }

    public ViewContainer getViewContainer() {
        return this.viewContainer;
    }

    public void updateWindowMenu() {
        this.updateWindowMenu(this.windowMenu);
    }

    public void updateActions() {
        boolean hasView = false;
        boolean hasFilter = false;
        boolean isActive = false;
        EventSource eventSource = null;
        EventWrapperViewPanel eventWrapperViewPanel = null;
        if (this.viewContainer != null) {
            hasView = true;
            eventWrapperViewPanel = this.viewContainer.getSelectedView();
            if (eventWrapperViewPanel != null) {
                eventSource = eventWrapperViewPanel.getEventSource();
                hasFilter = eventWrapperViewPanel.getFilterCondition() != null;
                isActive = eventWrapperViewPanel.getState() == LoggingViewState.ACTIVE;
            }
            this.copySelectionAction.setView(eventWrapperViewPanel);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("updateActions() eventSource={}", eventSource);
        }
        this.exportMenuAction.setView(eventWrapperViewPanel);
        this.searchMenu.setEnabled(hasView);
        this.findMenuAction.setEnabled(hasView);
        this.resetFindAction.setEnabled(hasFilter);
        this.findPreviousAction.setEnabled(hasFilter);
        this.findNextAction.setEnabled(hasFilter);
        Condition condition = this.mainFrame.getFindActiveCondition();
        this.findPreviousActiveAction.setEnabled(hasView && condition != null);
        this.findNextActiveAction.setEnabled(hasView && condition != null);
        this.viewMenu.setEnabled(hasView);
        this.scrollToBottomMenuAction.setEnabled(hasView);
        this.editSourceNameMenuAction.setEnabled(hasView);
        this.saveLayoutAction.setEnabled(hasView);
        this.resetLayoutAction.setEnabled(hasView);
        this.pauseMenuAction.setEnabled(hasView);
        this.clearMenuAction.setEnabled(hasView);
        this.attachMenuAction.setEnabled(hasView);
        this.disconnectMenuAction.setEnabled(isActive);
        this.focusEventsAction.setEnabled(hasView);
        this.focusMessageAction.setEnabled(hasView);
        this.updateShowHideMenu();
        this.previousTabAction.updateAction();
        this.nextTabAction.updateAction();
        this.disconnectToolBarAction.setEnabled(isActive);
        this.scrollToBottomMenuAction.updateAction();
        this.editSourceNameMenuAction.updateAction();
        this.saveConditionMenuAction.updateAction();
        this.zoomInMenuAction.updateAction();
        this.zoomOutMenuAction.updateAction();
        this.resetZoomMenuAction.updateAction();
        this.pauseMenuAction.updateAction();
        this.attachMenuAction.updateAction();
        this.closeFilterAction.updateAction();
        this.closeOtherFiltersAction.updateAction();
        this.closeAllFiltersAction.updateAction();
        this.scrollToBottomButton.setSelected(this.isScrollingToBottom());
        this.pauseToolBarAction.updateAction();
        this.attachToolBarAction.updateAction();
        this.scrollToBottomToolBarAction.setEnabled(hasView);
        this.pauseToolBarAction.setEnabled(hasView);
        this.clearToolBarAction.setEnabled(hasView);
        this.findToolBarAction.setEnabled(hasView);
        this.attachToolBarAction.setEnabled(hasView);
        this.disconnectToolBarAction.setEnabled(isActive);
        if (eventSource != null) {
            this.showUnfilteredEventAction.setEnabled(eventSource.getFilter() != null);
        } else {
            this.showUnfilteredEventAction.setEnabled(false);
        }
    }

    private void updateShowHideMenu() {
        EventWrapperViewTable table;
        EventWrapperViewPanel viewPanel;
        this.columnsMenu.removeAll();
        if (this.viewContainer != null && (viewPanel = this.viewContainer.getSelectedView()) != null && (table = viewPanel.getTable()) != null) {
            PersistentTableColumnModel tableColumnModel = table.getTableColumnModel();
            List cli = tableColumnModel.getColumnLayoutInfos();
            for (PersistentTableColumnModel.TableColumnLayoutInfo current : cli) {
                boolean visible = current.isVisible();
                JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(new ShowHideAction(tableColumnModel, current.getColumnName(), visible));
                cbmi.setSelected(visible);
                this.columnsMenu.add(cbmi);
            }
        }
    }

    void setShowingFilters(boolean showingFilters) {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.setShowingFilters(showingFilters);
        }
    }

    boolean isScrollingToBottom() {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            return eventWrapperViewPanel.isScrollingToBottom();
        }
        return false;
    }

    void setScrollingToBottom(boolean scrollingToBottom) {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.setScrollingToBottom(scrollingToBottom);
        }
    }

    boolean isPaused() {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            return eventWrapperViewPanel.isPaused();
        }
        return false;
    }

    void setPaused(boolean paused) {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.setPaused(paused);
        }
    }

    void clear() {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.clear();
        }
    }

    void focusTable() {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.focusTable();
        }
    }

    private void editCondition() {
        Condition currentFilter;
        Condition condition;
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null && (condition = eventWrapperViewPanel.getCombinedCondition(currentFilter = eventWrapperViewPanel.getTable().getFilterCondition())) != null) {
            this.mainFrame.getPreferencesDialog().editCondition(condition);
        }
    }

    private void editSourceName() {
        String sourceIdentifier;
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null && !"global".equals(sourceIdentifier = eventWrapperViewPanel.getEventSource().getSourceIdentifier().getIdentifier()) && !"Lilith".equals(sourceIdentifier)) {
            this.mainFrame.getPreferencesDialog().editSourceName(sourceIdentifier);
        }
    }

    private void attachDetach() {
        ViewContainer container = this.getViewContainer();
        if (container != null) {
            MainFrame mainFrame = container.getMainFrame();
            ViewWindow window = container.resolveViewWindow();
            if (window instanceof JFrame) {
                window.closeWindow();
                mainFrame.showInternalFrame(container);
            } else if (window instanceof JInternalFrame) {
                window.closeWindow();
                mainFrame.showFrame(container);
            }
        }
        this.focusTable();
    }

    private void disconnect() {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.closeConnection(eventWrapperViewPanel.getEventSource().getSourceIdentifier());
        }
    }

    private void focusMessage() {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.focusMessagePane();
        }
    }

    private void focusEvents() {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.focusTable();
        }
    }

    private void findNext() {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.findNext(eventWrapperViewPanel.getSelectedRow(), eventWrapperViewPanel.getFilterCondition());
        }
    }

    private void findNextActive() {
        EventWrapperViewPanel eventWrapperViewPanel;
        Condition condition = this.mainFrame.getFindActiveCondition();
        if (this.viewContainer != null && condition != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.findNext(eventWrapperViewPanel.getSelectedRow(), condition);
        }
    }

    private void findPrevious() {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.findPrevious(eventWrapperViewPanel.getSelectedRow(), eventWrapperViewPanel.getFilterCondition());
        }
    }

    private void findPreviousActive() {
        EventWrapperViewPanel eventWrapperViewPanel;
        Condition condition = this.mainFrame.getFindActiveCondition();
        if (this.viewContainer != null && condition != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.findPrevious(eventWrapperViewPanel.getSelectedRow(), condition);
        }
    }

    private void resetFind() {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.resetFind();
        }
    }

    private void closeCurrentFilter() {
        if (this.viewContainer != null) {
            this.viewContainer.closeCurrentFilter();
        }
    }

    private void closeOtherFilters() {
        if (this.viewContainer != null) {
            this.viewContainer.closeOtherFilters();
        }
    }

    private void closeAllFilters() {
        if (this.viewContainer != null) {
            this.viewContainer.closeAllFilters();
        }
    }

    private void previousTab() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PreviousTab");
        }
        if (this.viewContainer != null) {
            int viewCount = this.viewContainer.getViewCount();
            int viewIndex = this.viewContainer.getViewIndex();
            if (viewIndex > -1) {
                int newView = viewIndex - 1;
                if (newView < 0) {
                    newView = viewCount - 1;
                }
                if (newView >= 0 && newView < viewCount) {
                    this.viewContainer.setViewIndex(newView);
                }
            }
        }
    }

    private void nextTab() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("NextTab");
        }
        if (this.viewContainer != null) {
            int viewIndex = this.viewContainer.getViewIndex();
            int viewCount = this.viewContainer.getViewCount();
            if (viewIndex > -1) {
                int newView = viewIndex + 1;
                if (newView >= viewCount) {
                    newView = 0;
                }
                if (newView >= 0) {
                    this.viewContainer.setViewIndex(newView);
                }
            }
        }
    }

    private void showUnfilteredEvent() {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.showUnfilteredEvent();
        }
    }

    private void initPopup() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("initPopup()");
        }
        this.popup = new JPopupMenu();
        JMenuItem showUnfilteredMenuItem = new JMenuItem(this.showUnfilteredEventAction);
        Font f = showUnfilteredMenuItem.getFont();
        Font boldFont = f.deriveFont(1);
        showUnfilteredMenuItem.setFont(boldFont);
        this.popup.add(showUnfilteredMenuItem);
        this.filterPopupMenu = new JMenu("Filter");
        this.popup.add(this.filterPopupMenu);
        this.filterPopupMenu.add(this.closeFilterAction);
        this.filterPopupMenu.add(this.closeOtherFiltersAction);
        this.filterPopupMenu.add(this.closeAllFiltersAction);
        this.popup.addSeparator();
        this.popup.add(this.saveConditionMenuAction);
        this.popup.addSeparator();
        this.focusPopupMenu = new FocusMenu(this.mainFrame.getApplicationPreferences());
        this.excludePopupMenu = new ExcludeMenu(this.mainFrame.getApplicationPreferences());
        this.popup.add(this.focusPopupMenu);
        this.popup.add(this.excludePopupMenu);
        this.popup.addSeparator();
        this.updateCustomCopyMenu(this.eventWrapper);
        this.copyPopupMenu = new JMenu("Copy");
        this.popup.add(this.copyPopupMenu);
        this.copyPopupMenu.add(this.copySelectionAction);
        this.copyPopupMenu.addSeparator();
        this.copyPopupMenu.add(this.copyEventAction);
        this.copyPopupMenu.addSeparator();
        for (CopyToClipboardAction current : this.copyLoggingActions) {
            this.copyPopupMenu.add(current);
        }
        this.copyPopupMenu.addSeparator();
        for (CopyToClipboardAction current : this.copyAccessActions) {
            this.copyPopupMenu.add(current);
        }
        this.copyPopupMenu.addSeparator();
        this.copyPopupMenu.add(this.customCopyPopupMenu);
        this.sendToPopupMenu = new JMenu("Send to");
        this.popup.add(this.sendToPopupMenu);
        this.popup.add(this.gotoSourceAction);
    }

    private void setEventWrapper(EventWrapper wrapper) {
        Serializable event;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("setEventWrapper: {}", (Object)wrapper);
        }
        this.eventWrapper = wrapper;
        this.gotoSourceAction.setEventWrapper(this.eventWrapper);
        this.copyEventAction.setEventWrapper(this.eventWrapper);
        for (CopyToClipboardAction current : this.copyLoggingActions) {
            current.setEventWrapper(this.eventWrapper);
        }
        for (CopyToClipboardAction current : this.copyAccessActions) {
            current.setEventWrapper(this.eventWrapper);
        }
        boolean enableEditMenu = this.eventWrapper == null ? false : (event = this.eventWrapper.getEvent()) instanceof LoggingEvent || event instanceof AccessEvent;
        this.editMenu.setEnabled(enableEditMenu);
        this.updateCustomCopyMenu(this.eventWrapper);
        this.focusMenu.setViewContainer(this.viewContainer);
        this.focusMenu.setEventWrapper(this.eventWrapper);
        this.excludeMenu.setViewContainer(this.viewContainer);
        this.excludeMenu.setEventWrapper(this.eventWrapper);
    }

    private void updateCustomCopyMenu(EventWrapper wrapper) {
        ApplicationPreferences prefs = this.mainFrame.getApplicationPreferences();
        String[] scripts = prefs.getClipboardFormatterScriptFiles();
        boolean changed = false;
        if (this.groovyClipboardActions == null) {
            this.groovyClipboardActions = new HashMap<String, CopyToClipboardAction>();
            changed = true;
        }
        if (this.groovyClipboardData == null) {
            this.groovyClipboardData = new HashMap<String, ClipboardFormatterData>();
            changed = true;
        }
        if (scripts == null || scripts.length == 0) {
            if (this.groovyClipboardActions.size() > 0) {
                this.groovyClipboardActions.clear();
                this.groovyClipboardData.clear();
                changed = true;
            }
        } else {
            List<String> scriptsList = Arrays.asList(scripts);
            for (String current : scriptsList) {
                if (this.groovyClipboardActions.containsKey(current)) continue;
                GroovyFormatter newFormatter = new GroovyFormatter();
                newFormatter.setGroovyFileName(prefs.resolveClipboardFormatterScriptFile(current).getAbsolutePath());
                CopyToClipboardAction newAction = new CopyToClipboardAction(newFormatter);
                this.groovyClipboardActions.put(current, newAction);
                changed = true;
            }
            ArrayList deletedList = new ArrayList();
            for (Map.Entry<String, CopyToClipboardAction> current : this.groovyClipboardActions.entrySet()) {
                if (scriptsList.contains(current.getKey())) continue;
                deletedList.add(current.getKey());
            }
            for (Map.Entry<String, CopyToClipboardAction> current : deletedList) {
                this.groovyClipboardActions.remove(current);
                changed = true;
            }
        }
        for (Map.Entry<String, CopyToClipboardAction> current : this.groovyClipboardActions.entrySet()) {
            ClipboardFormatterData data;
            String key = current.getKey();
            CopyToClipboardAction value = current.getValue();
            ClipboardFormatter formatter = value.getClipboardFormatter();
            if (formatter == null || (data = new ClipboardFormatterData(formatter)).equals(this.groovyClipboardData.get(key))) continue;
            changed = true;
            this.groovyClipboardData.put(key, data);
            value.setClipboardFormatter(formatter);
        }
        if (changed) {
            this.customCopyMenu.removeAll();
            this.customCopyPopupMenu.removeAll();
            boolean enabled = false;
            if (this.groovyClipboardActions.size() > 0) {
                enabled = true;
                TreeSet<CopyToClipboardAction> sorted = new TreeSet<CopyToClipboardAction>(CopyToClipboardByNameComparator.INSTANCE);
                for (Map.Entry<String, CopyToClipboardAction> current : this.groovyClipboardActions.entrySet()) {
                    sorted.add(current.getValue());
                }
                HashMap<KeyStroke, CopyToClipboardAction> freshMapping = new HashMap<KeyStroke, CopyToClipboardAction>(this.keyStrokeActionMapping);
                this.prepareClipboardActions(sorted, freshMapping);
                for (CopyToClipboardAction current : sorted) {
                    this.customCopyMenu.add(current);
                    this.customCopyPopupMenu.add(current);
                }
            }
            this.customCopyMenu.setEnabled(enabled);
            this.customCopyPopupMenu.setEnabled(enabled);
        }
        for (Map.Entry<String, CopyToClipboardAction> current : this.groovyClipboardActions.entrySet()) {
            CopyToClipboardAction value = current.getValue();
            value.setEventWrapper(wrapper);
        }
    }

    private void prepareClipboardActions(Collection<CopyToClipboardAction> actions, Map<KeyStroke, CopyToClipboardAction> mapping) {
        if (actions == null) {
            throw new IllegalArgumentException("actions must not be null!");
        }
        if (mapping == null) {
            throw new IllegalArgumentException("mapping must not be null!");
        }
        for (CopyToClipboardAction current : actions) {
            CopyToClipboardAction existingAction;
            ClipboardFormatter formatter;
            Object obj = current.getValue("AcceleratorKey");
            if (!(obj instanceof KeyStroke) || (formatter = current.getClipboardFormatter()) == null) continue;
            boolean reset = false;
            String name = formatter.getName();
            KeyStroke currentKeyStroke = (KeyStroke)obj;
            String existingActionName = LilithKeyStrokes.getActionName(currentKeyStroke);
            if (existingActionName != null) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("KeyStroke '{}' of formatter '{}' would collide with native Lilith action '{}'. Ignoring...", new Object[]{currentKeyStroke, name, existingActionName});
                }
                reset = true;
            }
            if ((existingAction = mapping.get(currentKeyStroke)) != null) {
                String existingFormatterName = null;
                ClipboardFormatter existingFormatter = existingAction.getClipboardFormatter();
                if (existingFormatter != null) {
                    existingFormatterName = existingFormatter.getName();
                }
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("KeyStroke '{}' of formatter '{}' would collide with other formatter '{}'. Ignoring...", new Object[]{currentKeyStroke, name, existingFormatterName});
                }
                reset = true;
            }
            if (reset) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Resetting accelerator for formatter '{}'.", (Object)name);
                }
                current.putValue("AcceleratorKey", null);
                continue;
            }
            mapping.put(currentKeyStroke, current);
        }
    }

    public void updateWindowMenu(JMenu windowMenu) {
        SwingUtilities.invokeLater(new UpdateWindowMenuRunnable(windowMenu));
    }

    public ActionListener getAboutAction() {
        return this.aboutAction;
    }

    private void updatePopup() {
        boolean enableCopyMenu;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("updatePopup()");
        }
        if (this.popup == null) {
            this.initPopup();
        }
        this.sendToPopupMenu.removeAll();
        if (this.eventWrapper == null) {
            this.sendToPopupMenu.setEnabled(false);
            enableCopyMenu = false;
        } else {
            Serializable eventObj = this.eventWrapper.getEvent();
            if (eventObj instanceof LoggingEvent) {
                enableCopyMenu = true;
                Map<String, EventSender<LoggingEvent>> senders = this.mainFrame.getLoggingEventSenders();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Senders: {}", senders);
                }
                if (senders.size() == 0) {
                    this.sendToPopupMenu.setEnabled(false);
                } else {
                    this.sendToPopupMenu.setEnabled(true);
                    for (Map.Entry<String, EventSender<LoggingEvent>> current : senders.entrySet()) {
                        this.sendToPopupMenu.add(new SendAction<LoggingEvent>(current.getKey(), current.getValue(), this.eventWrapper));
                    }
                }
            } else if (eventObj instanceof AccessEvent) {
                enableCopyMenu = true;
                Map<String, EventSender<AccessEvent>> senders = this.mainFrame.getAccessEventSenders();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Senders: {}", senders);
                }
                if (senders.size() == 0) {
                    this.sendToPopupMenu.setEnabled(false);
                } else {
                    this.sendToPopupMenu.setEnabled(true);
                    for (Map.Entry<String, EventSender<AccessEvent>> current : senders.entrySet()) {
                        this.sendToPopupMenu.add(new SendAction<AccessEvent>(current.getKey(), current.getValue(), this.eventWrapper));
                    }
                }
            } else {
                enableCopyMenu = false;
                this.sendToPopupMenu.setEnabled(false);
            }
        }
        boolean enableFilterMenu = this.closeFilterAction.isEnabled() || this.closeOtherFiltersAction.isEnabled() || this.closeAllFiltersAction.isEnabled();
        this.filterPopupMenu.setEnabled(enableFilterMenu);
        this.copyPopupMenu.setEnabled(enableCopyMenu);
        this.focusPopupMenu.setViewContainer(this.viewContainer);
        this.focusPopupMenu.setEventWrapper(this.eventWrapper);
        this.excludePopupMenu.setViewContainer(this.viewContainer);
        this.excludePopupMenu.setEventWrapper(this.eventWrapper);
    }

    public JPopupMenu getPopupMenu() {
        this.updatePopup();
        return this.popup;
    }

    public void updateRecentFiles() {
        ApplicationPreferences prefs = this.mainFrame.getApplicationPreferences();
        List<String> recentFilesStrings = prefs.getRecentFiles();
        if (recentFilesStrings == null || recentFilesStrings.size() == 0) {
            this.recentFilesMenu.removeAll();
            this.recentFilesMenu.setEnabled(false);
        } else {
            boolean fullPath = prefs.isShowingFullRecentPath();
            this.recentFilesMenu.removeAll();
            for (String current : recentFilesStrings) {
                this.recentFilesMenu.add(new OpenFileAction(current, fullPath));
            }
            this.recentFilesMenu.addSeparator();
            this.recentFilesMenu.add(this.clearRecentFilesAction);
            this.recentFilesMenu.setEnabled(true);
        }
    }

    public void setConditionNames(List<String> conditionNames) {
        this.focusMenu.setConditionNames(conditionNames);
        this.focusPopupMenu.setConditionNames(conditionNames);
        this.excludeMenu.setConditionNames(conditionNames);
        this.excludePopupMenu.setConditionNames(conditionNames);
    }

    static {
        Logger logger = LoggerFactory.getLogger(ViewActions.class);
        JMenuItem item = new JMenuItem();
        Font font = item.getFont();
        if (logger.isDebugEnabled()) {
            logger.debug("Can display '{}': {}", (Object)Character.valueOf('\u2325'), (Object)font.canDisplay('\u2325'));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Can display '{}': {}", (Object)Character.valueOf('\u2318'), (Object)font.canDisplay('\u2318'));
        }
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.addKeyEventDispatcher(new EggListener());
    }

    private static class EggListener
    implements KeyEventDispatcher {
        private final Logger logger = LoggerFactory.getLogger(EggListener.class);
        private int step = 0;

        private EggListener() {
        }

        public boolean dispatchKeyEvent(KeyEvent e) {
            block19: {
                if (e.getID() == 402) {
                    if ((this.step == 2 || this.step == 3) && e.getKeyCode() == 40) {
                        ++this.step;
                    } else if ((this.step == 4 || this.step == 6) && e.getKeyCode() == 37) {
                        ++this.step;
                    } else if ((this.step == 5 || this.step == 7) && e.getKeyCode() == 39) {
                        ++this.step;
                    } else if (this.step == 8 && e.getKeyCode() == 66) {
                        ++this.step;
                    } else {
                        if (this.step == 9 && e.getKeyCode() == 65) {
                            this.step = 0;
                            try {
                                MainFrame.openUrl(new URL("http://z0r.de"));
                                if (this.logger.isInfoEnabled()) {
                                    this.logger.info("Yay!");
                                }
                                break block19;
                            }
                            catch (MalformedURLException ex) {
                                if (this.logger.isWarnEnabled()) {
                                    this.logger.warn("lolwut?", (Throwable)ex);
                                }
                                break block19;
                            }
                        }
                        if ((this.step == 0 || this.step == 1) && e.getKeyCode() == 38) {
                            ++this.step;
                        } else if (e.getKeyCode() == 38) {
                            if (this.step != 2) {
                                this.step = 1;
                            }
                        } else {
                            this.step = 0;
                        }
                    }
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CopyToClipboardByNameComparator
    implements Comparator<CopyToClipboardAction> {
        public static final CopyToClipboardByNameComparator INSTANCE = new CopyToClipboardByNameComparator();

        private CopyToClipboardByNameComparator() {
        }

        @Override
        public int compare(CopyToClipboardAction o1, CopyToClipboardAction o2) {
            String n2;
            ClipboardFormatter f2;
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            ClipboardFormatter f1 = o1.getClipboardFormatter();
            if (f1 == (f2 = o2.getClipboardFormatter())) {
                return 0;
            }
            if (f1 == null) {
                return -1;
            }
            if (f2 == null) {
                return 1;
            }
            String n1 = f1.getName();
            if (n1 == (n2 = f2.getName())) {
                return 0;
            }
            if (n1 == null) {
                return -1;
            }
            if (n2 == null) {
                return 1;
            }
            return n1.compareTo(n2);
        }
    }

    private static class ShowHideAction
    extends AbstractAction {
        private static final long serialVersionUID = 7775753128032553866L;
        private boolean visible;
        private String columnName;
        private PersistentTableColumnModel tableColumnModel;

        public ShowHideAction(PersistentTableColumnModel tableColumnModel, String columnName, boolean visible) {
            super(columnName);
            this.columnName = columnName;
            this.visible = visible;
            this.tableColumnModel = tableColumnModel;
        }

        public void actionPerformed(ActionEvent e) {
            this.visible = !this.visible;
            Iterator iter = this.tableColumnModel.getColumns(false);
            TableColumn found = null;
            while (iter.hasNext()) {
                TableColumn current = (TableColumn)iter.next();
                if (!this.columnName.equals(current.getIdentifier())) continue;
                found = current;
                break;
            }
            if (found != null) {
                this.tableColumnModel.setColumnVisible(found, this.visible);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SendAction<T extends Serializable>
    extends AbstractAction {
        private static final long serialVersionUID = 6612401555757959404L;
        private EventSender<T> sender;
        private T event;

        public SendAction(String name, EventSender<T> sender, EventWrapper<T> wrapper) {
            super(name);
            this.sender = sender;
            this.event = wrapper.getEvent();
            this.setEnabled(this.event != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.sender.send(this.event);
        }
    }

    private class GotoSourceAction
    extends AbstractAction {
        private static final long serialVersionUID = 4284532761807647658L;
        private ExtendedStackTraceElement stackTraceElement;

        public GotoSourceAction() {
            super("Go to source");
            this.putValue("ShortDescription", "Show source in IDEA if everything is ok ;)");
        }

        public void setEventWrapper(EventWrapper wrapper) {
            LoggingEvent loggingEvent;
            ExtendedStackTraceElement[] callStack;
            if (wrapper == null) {
                this.setStackTraceElement(null);
                return;
            }
            Serializable event = wrapper.getEvent();
            if (event instanceof LoggingEvent && (callStack = (loggingEvent = (LoggingEvent)event).getCallStack()) != null && callStack.length > 0) {
                this.setStackTraceElement(callStack[0]);
                return;
            }
            this.setStackTraceElement(null);
        }

        public void setStackTraceElement(ExtendedStackTraceElement stackTraceElement) {
            this.stackTraceElement = stackTraceElement;
            this.setEnabled(this.stackTraceElement != null);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.goToSource(this.stackTraceElement.getStackTraceElement());
        }
    }

    private class ShowUnfilteredEventAction
    extends AbstractAction {
        private static final long serialVersionUID = -3282222163767568550L;

        public ShowUnfilteredEventAction() {
            super("Show unfiltered");
            this.putValue("ShortDescription", "Show unfiltered event.");
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.showUnfilteredEvent();
        }
    }

    private static class CopyToClipboardAction
    extends AbstractAction {
        private static final long serialVersionUID = 7832452126107208925L;
        private final Logger logger = LoggerFactory.getLogger(CopyToClipboardAction.class);
        private ClipboardFormatter clipboardFormatter;
        private transient EventWrapper wrapper;

        private CopyToClipboardAction(ClipboardFormatter clipboardFormatter) {
            this.setClipboardFormatter(clipboardFormatter);
            this.setEventWrapper(null);
        }

        public ClipboardFormatter getClipboardFormatter() {
            return this.clipboardFormatter;
        }

        public void setClipboardFormatter(ClipboardFormatter clipboardFormatter) {
            if (clipboardFormatter == null) {
                throw new IllegalArgumentException("clipboardFormatter must not be null!");
            }
            this.clipboardFormatter = clipboardFormatter;
            this.putValue("Name", clipboardFormatter.getName());
            this.putValue("ShortDescription", clipboardFormatter.getDescription());
            String acc = clipboardFormatter.getAccelerator();
            if (acc != null) {
                KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)acc);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("accelerator for '{}': {}", (Object)acc, (Object)accelerator);
                }
                if (accelerator != null) {
                    this.putValue("AcceleratorKey", accelerator);
                } else if (this.logger.isWarnEnabled()) {
                    this.logger.warn("'{}' did not represent a valid KeyStroke!", (Object)acc);
                }
            }
        }

        public void setEventWrapper(EventWrapper wrapper) {
            if (this.clipboardFormatter == null) {
                throw new IllegalStateException("clipboardFormatter must not be null!");
            }
            this.setEnabled(this.clipboardFormatter.isCompatible(wrapper));
            this.wrapper = wrapper;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.clipboardFormatter == null) {
                throw new IllegalStateException("clipboardFormatter must not be null!");
            }
            String text = this.clipboardFormatter.toString(this.wrapper);
            if (text != null) {
                MainFrame.copyText(text);
            }
        }
    }

    private class EventXmlFormatter
    implements ClipboardFormatter {
        private static final long serialVersionUID = 2263706767713579277L;
        private LoggingXmlEncoder encoder = new LoggingXmlEncoder(false, true);

        private EventXmlFormatter() {
        }

        public String getName() {
            return "Copy event as XML";
        }

        public String getDescription() {
            return "Copies the XML representation of the event to the clipboard.";
        }

        public String getAccelerator() {
            return null;
        }

        public boolean isCompatible(Object object) {
            if (object instanceof EventWrapper) {
                EventWrapper wrapper = (EventWrapper)object;
                Serializable eventObj = wrapper.getEvent();
                return eventObj instanceof LoggingEvent;
            }
            return false;
        }

        public String toString(Object object) {
            block3: {
                EventWrapper wrapper;
                Serializable ser;
                if (object instanceof EventWrapper && (ser = (wrapper = (EventWrapper)object).getEvent()) instanceof LoggingEvent) {
                    LoggingEvent event = (LoggingEvent)ser;
                    byte[] bytes = this.encoder.encode(event);
                    try {
                        return new String(bytes, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        if (!ViewActions.this.logger.isErrorEnabled()) break block3;
                        ViewActions.this.logger.error("Couldn't create UTF-8 string!", (Throwable)e);
                    }
                }
            }
            return null;
        }
    }

    private class EventJsonFormatter
    implements ClipboardFormatter {
        private static final long serialVersionUID = 2263706767713579277L;
        private LoggingJsonEncoder encoder = new LoggingJsonEncoder(false, true, true);

        private EventJsonFormatter() {
        }

        public String getName() {
            return "Copy event as JSON";
        }

        public String getDescription() {
            return "Copies the JSON representation of the event to the clipboard.";
        }

        public String getAccelerator() {
            return null;
        }

        public boolean isCompatible(Object object) {
            if (object instanceof EventWrapper) {
                EventWrapper wrapper = (EventWrapper)object;
                Serializable eventObj = wrapper.getEvent();
                return eventObj instanceof LoggingEvent;
            }
            return false;
        }

        public String toString(Object object) {
            block3: {
                EventWrapper wrapper;
                Serializable ser;
                if (object instanceof EventWrapper && (ser = (wrapper = (EventWrapper)object).getEvent()) instanceof LoggingEvent) {
                    LoggingEvent event = (LoggingEvent)ser;
                    byte[] bytes = this.encoder.encode(event);
                    try {
                        return new String(bytes, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        if (!ViewActions.this.logger.isErrorEnabled()) break block3;
                        ViewActions.this.logger.error("Couldn't create UTF-8 string!", (Throwable)e);
                    }
                }
            }
            return null;
        }
    }

    private class EventFormatter
    implements ClipboardFormatter {
        private static final long serialVersionUID = 2263706767713579277L;

        private EventFormatter() {
        }

        public String getName() {
            return "Copy event";
        }

        public String getDescription() {
            return "Copies the HTML code of this events details view to the clipboard.";
        }

        public String getAccelerator() {
            return null;
        }

        public boolean isCompatible(Object object) {
            if (object instanceof EventWrapper) {
                EventWrapper wrapper = (EventWrapper)object;
                Serializable eventObj = wrapper.getEvent();
                return eventObj instanceof LoggingEvent || eventObj instanceof AccessEvent;
            }
            return false;
        }

        public String toString(Object object) {
            if (object instanceof EventWrapper) {
                EventWrapper wrapper = (EventWrapper)object;
                return ViewActions.this.mainFrame.createMessage(wrapper);
            }
            return null;
        }
    }

    private class PasteStackTraceElementAction
    extends AbstractAction {
        private static final long serialVersionUID = -7630719409103575849L;
        private static final String AT_PREFIX = "at ";
        private final Logger logger;
        private Clipboard clipboard;

        private PasteStackTraceElementAction() {
            super("Paste StackTraceElement");
            this.logger = LoggerFactory.getLogger(PasteStackTraceElementAction.class);
            this.putValue("ShortDescription", "Paste StackTraceElement from clipboard and open code in IDE if available.");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("PASTE_STACK_TRACE_ELEMENT_ACTION");
            this.putValue("AcceleratorKey", accelerator);
            boolean enable = true;
            try {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                this.clipboard = toolkit.getSystemClipboard();
            }
            catch (AWTError ex) {
                enable = false;
            }
            catch (HeadlessException ex) {
                enable = false;
            }
            catch (SecurityException ex) {
                enable = false;
            }
            this.setEnabled(enable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            ExtendedStackTraceElement xste;
            String text = null;
            BufferedReader reader = null;
            try {
                Transferable transferable = this.clipboard.getContents(null);
                if (transferable != null && (text = (reader = new BufferedReader(DataFlavor.getTextPlainUnicodeFlavor().getReaderForText(transferable))).readLine()) != null && (text = text.trim()).startsWith(AT_PREFIX)) {
                    text = text.substring(AT_PREFIX.length());
                }
            }
            catch (IllegalStateException ex) {
            }
            catch (IllegalArgumentException ex) {
            }
            catch (UnsupportedFlavorException ex) {
            }
            catch (IOException ex) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e1) {}
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Line from clipboard: {}", text);
            }
            if (text != null && (xste = ExtendedStackTraceElement.parseStackTraceElement(text)) != null) {
                StackTraceElement ste = xste.getStackTraceElement();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Parsed StackTraceElement: {}", (Object)ste);
                }
                ViewActions.this.mainFrame.goToSource(ste);
            }
        }
    }

    private class CopySelectionAction
    extends AbstractAction {
        private static final long serialVersionUID = -551520865313383753L;
        private EventWrapperViewPanel view;

        public CopySelectionAction() {
            super("Copy selection");
            this.putValue("ShortDescription", "Copies the selection to the clipboard.");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("COPY_SELECTION_ACTION");
            this.putValue("AcceleratorKey", accelerator);
            this.setView(null);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.view != null) {
                this.view.copySelection();
            }
        }

        public void setView(EventWrapperViewPanel view) {
            this.view = view;
            this.setEnabled(view != null);
        }
    }

    private class NextTabAction
    extends AbstractAction {
        private static final long serialVersionUID = 6997026628818486446L;

        public NextTabAction() {
            super("Next tab");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("NEXT_TAB_ACTION");
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
        }

        public void updateAction() {
            if (ViewActions.this.viewContainer != null) {
                int viewCount = ViewActions.this.viewContainer.getViewCount();
                if (viewCount > 1) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.nextTab();
        }
    }

    private class PreviousTabAction
    extends AbstractAction {
        private static final long serialVersionUID = 3841435361964210123L;

        public PreviousTabAction() {
            super("Previous tab");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("PREVIOUS_TAB_ACTION");
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
        }

        public void updateAction() {
            if (ViewActions.this.viewContainer != null) {
                int viewCount = ViewActions.this.viewContainer.getViewCount();
                if (viewCount > 1) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.previousTab();
        }
    }

    class CleanAllInactiveLogsMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 626049491764655228L;

        public CleanAllInactiveLogsMenuAction() {
            super("Clean all inactive logs");
            this.putValue("SmallIcon", Icons.CLEAR_MENU_ICON);
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("CLEAN_ALL_INACTIVE_LOGS_ACTION");
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("MnemonicKey", 99);
        }

        public void actionPerformed(ActionEvent e) {
            if (ViewActions.this.logger.isInfoEnabled()) {
                ViewActions.this.logger.info("Clean all inactive logs");
            }
            ViewActions.this.mainFrame.cleanAllInactiveLogs();
        }
    }

    class ExportMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = -5912177735718627089L;
        private EventWrapperViewPanel view;

        public ExportMenuAction() {
            super("Export...");
            this.putValue("SmallIcon", Icons.EXPORT_MENU_ICON);
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("EXPORT_ACTION");
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("MnemonicKey", 101);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.exportFile(this.view);
        }

        public void setView(EventWrapperViewPanel eventWrapperViewPanel) {
            this.view = eventWrapperViewPanel;
            this.setEnabled(this.view != null);
        }
    }

    class ImportMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 7500131416548647712L;

        public ImportMenuAction() {
            super("Import...");
            this.putValue("SmallIcon", Icons.OPEN_INACTIVE_MENU_ICON);
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("IMPORT_ACTION");
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("MnemonicKey", 105);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.importFile();
        }
    }

    class OpenMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 7500131416548647712L;

        public OpenMenuAction() {
            super("Open...");
            this.putValue("SmallIcon", Icons.OPEN_INACTIVE_MENU_ICON);
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("OPEN_ACTION");
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("MnemonicKey", 111);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.open();
        }
    }

    class OpenInactiveLogMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 7500131416548647712L;

        public OpenInactiveLogMenuAction() {
            super("Open inactive log...");
            this.putValue("SmallIcon", Icons.OPEN_INACTIVE_MENU_ICON);
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("OPEN_INACTIVE_ACTION");
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("MnemonicKey", 111);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.openInactiveLogs();
        }
    }

    class ExitMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 6693131597277483031L;

        public ExitMenuAction() {
            super("Exit");
            this.putValue("SmallIcon", Icons.EXIT_MENU_ICON);
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("EXIT_ACTION");
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("MnemonicKey", 120);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.exit();
        }
    }

    class DebugAction
    extends AbstractAction {
        private static final long serialVersionUID = -1837786931224404611L;

        public DebugAction() {
            super("Debug");
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.showDebugDialog();
        }
    }

    class ShowLoveToolbarAction
    extends AbstractAction {
        private static final long serialVersionUID = -8956952034828513214L;

        public ShowLoveToolbarAction() {
            this.putValue("SmallIcon", Icons.LOVE_TOOLBAR_ICON);
            this.putValue("ShortDescription", "Show some Love...");
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.openHelp("love.xhtml");
        }
    }

    class ShowLoveMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 7535022992770523208L;

        public ShowLoveMenuAction() {
            super("Show some Love...");
            this.putValue("SmallIcon", Icons.LOVE_MENU_ICON);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.openHelp("love.xhtml");
        }
    }

    class PreferencesToolBarAction
    extends AbstractAction {
        private static final long serialVersionUID = 8353604009441967874L;

        public PreferencesToolBarAction() {
            this.putValue("SmallIcon", Icons.PREFERENCES_TOOLBAR_ICON);
            this.putValue("ShortDescription", "Preferences...");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("PREFERENCES_ACTION");
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("MnemonicKey", 112);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.showPreferencesDialog();
        }
    }

    class PreferencesMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = -196036112324455446L;

        public PreferencesMenuAction() {
            super("Preferences...");
            this.putValue("SmallIcon", Icons.PREFERENCES_MENU_ICON);
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("PREFERENCES_ACTION");
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("MnemonicKey", 112);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.showPreferencesDialog();
        }
    }

    class TipOfTheDayAction
    extends AbstractAction {
        private static final long serialVersionUID = -3703967582739382172L;

        public TipOfTheDayAction() {
            super("Tip of the Day...");
            this.putValue("SmallIcon", Icons.TOTD_ICON);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.showTipOfTheDayDialog();
        }
    }

    class KeyboardHelpAction
    extends AbstractAction {
        private static final long serialVersionUID = 6942092383339768508L;

        public KeyboardHelpAction() {
            super("Help Topics");
            this.putValue("SmallIcon", Icons.HELP_MENU_ICON);
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("HELP_ACTION");
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.showHelp();
        }
    }

    class TroubleshootingAction
    extends AbstractAction {
        private static final long serialVersionUID = 529742851501771901L;

        public TroubleshootingAction() {
            super("Troubleshooting...");
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.troubleshooting();
        }
    }

    class CheckForUpdateAction
    extends AbstractAction {
        private static final long serialVersionUID = 529742851501771901L;

        public CheckForUpdateAction() {
            super("Check for Update...");
            this.putValue("SmallIcon", Icons.CHECK_UPDATE_ICON);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.checkForUpdate(true);
        }
    }

    class ResetLayoutAction
    extends AbstractAction {
        private static final long serialVersionUID = -8396518428359553649L;

        public ResetLayoutAction() {
            super("Reset layout");
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
        }

        public void actionPerformed(ActionEvent e) {
            EventWrapperViewTable table;
            EventWrapperViewPanel viewPanel;
            if (ViewActions.this.viewContainer != null && (viewPanel = ViewActions.this.viewContainer.getSelectedView()) != null && (table = viewPanel.getTable()) != null) {
                table.resetLayout();
            }
        }
    }

    class SaveLayoutAction
    extends AbstractAction {
        private static final long serialVersionUID = 6135867758474252484L;

        public SaveLayoutAction() {
            super("Save layout");
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
        }

        public void actionPerformed(ActionEvent e) {
            EventWrapperViewTable table;
            EventWrapperViewPanel viewPanel;
            if (ViewActions.this.viewContainer != null && (viewPanel = ViewActions.this.viewContainer.getSelectedView()) != null && (table = viewPanel.getTable()) != null) {
                table.saveLayout();
            }
        }
    }

    class AboutAction
    extends AbstractAction {
        private static final long serialVersionUID = -372250750198620913L;

        public AboutAction() {
            super("About...");
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.showAboutDialog();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UpdateWindowMenuRunnable
    implements Runnable {
        private JMenu windowMenu;

        public UpdateWindowMenuRunnable(JMenu windowMenu) {
            this.windowMenu = windowMenu;
        }

        @Override
        public void run() {
            EventWrapperViewPanel<LoggingEvent> panel;
            JMenuItem menuItem;
            ViewContainer<LoggingEvent> value;
            JMenuItem menuItem2;
            ViewContainer<LoggingEvent> value2;
            SourceIdentifier si;
            EventSource<LoggingEvent> key;
            ViewActions.this.mainFrame.removeInactiveViews(true, false);
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("Updating Views-Menu.");
            }
            this.windowMenu.removeAll();
            JMenu statisticsMenu = this.createStatisticsMenu();
            this.windowMenu.add(statisticsMenu);
            this.windowMenu.add(ViewActions.this.showTaskManagerItem);
            this.windowMenu.addSeparator();
            this.windowMenu.add(ViewActions.this.closeAllItem);
            this.windowMenu.add(ViewActions.this.closeAllOtherItem);
            this.windowMenu.add(ViewActions.this.minimizeAllItem);
            this.windowMenu.add(ViewActions.this.minimizeAllOtherItem);
            this.windowMenu.add(ViewActions.this.removeInactiveItem);
            int activeCounter = 0;
            int inactiveCounter = 0;
            int viewCounter = 0;
            Font inactiveFont = this.windowMenu.getFont();
            inactiveFont = inactiveFont.deriveFont(0);
            SortedMap<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> sortedLoggingViews = ViewActions.this.mainFrame.getSortedLoggingViews();
            SortedMap<EventSource<AccessEvent>, ViewContainer<AccessEvent>> sortedAccessViews = ViewActions.this.mainFrame.getSortedAccessViews();
            boolean first = true;
            for (Map.Entry<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> entry : sortedLoggingViews.entrySet()) {
                key = entry.getKey();
                si = key.getSourceIdentifier();
                if (!"Lilith".equals(si.getIdentifier())) continue;
                ViewContainer<LoggingEvent> value22 = entry.getValue();
                if (value22.resolveViewWindow() != null) {
                    ++viewCounter;
                }
                if (first) {
                    first = false;
                    this.windowMenu.addSeparator();
                }
                JMenuItem menuItem22 = this.createLoggingMenuItem(key, value22);
                this.windowMenu.add(menuItem22);
            }
            for (Map.Entry<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> entry : sortedLoggingViews.entrySet()) {
                key = entry.getKey();
                si = key.getSourceIdentifier();
                if ("Lilith".equals(si.getIdentifier())) continue;
                value2 = entry.getValue();
                if (value2.resolveViewWindow() != null) {
                    ++viewCounter;
                }
                if (!key.isGlobal()) continue;
                if (first) {
                    first = false;
                    this.windowMenu.addSeparator();
                }
                menuItem2 = this.createLoggingMenuItem(key, value2);
                this.windowMenu.add(menuItem2);
            }
            for (Map.Entry<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> entry : sortedAccessViews.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                if (value.resolveViewWindow() != null) {
                    ++viewCounter;
                }
                if (!key.isGlobal()) continue;
                if (first) {
                    first = false;
                    this.windowMenu.addSeparator();
                }
                JMenuItem menuItem3 = this.createAccessMenuItem(key, value);
                this.windowMenu.add(menuItem3);
            }
            first = true;
            for (Map.Entry<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> entry : sortedLoggingViews.entrySet()) {
                key = entry.getKey();
                si = key.getSourceIdentifier();
                if ("Lilith".equals(si.getIdentifier())) continue;
                value2 = entry.getValue();
                EventWrapperViewPanel<LoggingEvent> panel2 = value2.getDefaultView();
                if (key.isGlobal() || LoggingViewState.ACTIVE != panel2.getState()) continue;
                if (first) {
                    first = false;
                    this.windowMenu.addSeparator();
                }
                menuItem = this.createLoggingMenuItem(key, value2);
                this.windowMenu.add(menuItem);
                ++activeCounter;
            }
            for (Map.Entry<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> entry : sortedLoggingViews.entrySet()) {
                key = entry.getKey();
                si = key.getSourceIdentifier();
                if ("Lilith".equals(si.getIdentifier())) continue;
                value2 = entry.getValue();
                EventWrapperViewPanel<LoggingEvent> panel2 = value2.getDefaultView();
                if (key.isGlobal() || LoggingViewState.ACTIVE == panel2.getState()) continue;
                if (first) {
                    first = false;
                    this.windowMenu.addSeparator();
                }
                menuItem = this.createLoggingMenuItem(key, value2);
                menuItem.setFont(inactiveFont);
                this.windowMenu.add(menuItem);
                ++inactiveCounter;
            }
            first = true;
            for (Map.Entry<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> entry : sortedAccessViews.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                panel = value.getDefaultView();
                if (key.isGlobal() || LoggingViewState.ACTIVE != panel.getState()) continue;
                if (first) {
                    first = false;
                    this.windowMenu.addSeparator();
                }
                menuItem2 = this.createAccessMenuItem(key, value);
                this.windowMenu.add(menuItem2);
                ++activeCounter;
            }
            for (Map.Entry<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> entry : sortedAccessViews.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                panel = value.getDefaultView();
                if (key.isGlobal() || LoggingViewState.ACTIVE == panel.getState()) continue;
                if (first) {
                    first = false;
                    this.windowMenu.addSeparator();
                }
                menuItem2 = this.createAccessMenuItem(key, value);
                menuItem2.setFont(inactiveFont);
                this.windowMenu.add(menuItem2);
                ++inactiveCounter;
            }
            boolean hasInactive = inactiveCounter != 0;
            ViewActions.this.removeInactiveAction.setEnabled(hasInactive);
            boolean bl = viewCounter != 0;
            ViewActions.this.minimizeAllAction.setEnabled(bl);
            ViewActions.this.closeAllAction.setEnabled(bl);
            if (ViewActions.this.viewContainer == null || viewCounter <= 1) {
                ViewActions.this.minimizeAllOtherAction.setEnabled(false);
                ViewActions.this.closeOtherAction.setEnabled(false);
            } else {
                ViewActions.this.minimizeAllOtherAction.setEnabled(true);
                ViewActions.this.closeOtherAction.setEnabled(true);
            }
            ViewActions.this.mainFrame.setActiveConnectionsCounter(activeCounter);
            if (this.windowMenu.isPopupMenuVisible()) {
                this.windowMenu.setPopupMenuVisible(false);
                this.windowMenu.setPopupMenuVisible(true);
            }
        }

        private JMenuItem createLoggingMenuItem(EventSource<LoggingEvent> key, ViewContainer<LoggingEvent> viewContainer) {
            JMenuItem result = new JMenuItem(new ViewLoggingAction(viewContainer));
            Container compParent = viewContainer.getParent();
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("\n\nParent for {}: {}\n", (Object)key.getSourceIdentifier(), (Object)compParent);
            }
            if (compParent == null) {
                result.setIcon(Icons.EMPTY_16_ICON);
            } else {
                result.setIcon(Icons.WINDOW_16_ICON);
            }
            return result;
        }

        private JMenuItem createAccessMenuItem(EventSource<AccessEvent> key, ViewContainer<AccessEvent> viewContainer) {
            JMenuItem result = new JMenuItem(new ViewAccessAction(viewContainer));
            Container compParent = viewContainer.getParent();
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("\n\nParent for {}: {}\n", (Object)key.getSourceIdentifier(), (Object)compParent);
            }
            if (compParent == null) {
                result.setIcon(Icons.EMPTY_16_ICON);
            } else {
                result.setIcon(Icons.WINDOW_16_ICON);
            }
            return result;
        }

        private JMenu createStatisticsMenu() {
            StatisticsMenuAction statisticsMenuAction = new StatisticsMenuAction();
            JMenu result = new JMenu(statisticsMenuAction);
            if (!SystemUtils.IS_JAVA_1_6) {
                statisticsMenuAction.setEnabled(false);
            } else {
                SortedMap<String, SourceIdentifier> sources = ViewActions.this.mainFrame.getAvailableStatistics();
                JMenuItem menuItem = new JMenuItem(new ViewStatisticsAction("Global", new SourceIdentifier("global")));
                result.add(menuItem);
                result.addSeparator();
                for (Map.Entry<String, SourceIdentifier> current : sources.entrySet()) {
                    String key = current.getKey();
                    SourceIdentifier value = current.getValue();
                    JMenuItem menuItem2 = new JMenuItem(new ViewStatisticsAction(key, value));
                    result.add(menuItem2);
                }
            }
            return result;
        }
    }

    class ViewStatisticsAction
    extends AbstractAction {
        private static final long serialVersionUID = 4453230971326526165L;
        private SourceIdentifier sourceIentifier;

        public ViewStatisticsAction(String name, SourceIdentifier sourceIdentifier) {
            super(name);
            this.sourceIentifier = sourceIdentifier;
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.showStatistics(this.sourceIentifier);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ViewAccessAction
    extends AbstractAction {
        private static final long serialVersionUID = 8054851261518410946L;
        private EventSource<AccessEvent> eventSource;

        public ViewAccessAction(ViewContainer<AccessEvent> container) {
            super(ViewActions.this.mainFrame.resolveSourceTitle(container));
            this.eventSource = container.getEventSource();
            if (this.eventSource.isGlobal()) {
                KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("VIEW_GLOBAL_ACCESS_LOGS_ACTION");
                this.putValue("AcceleratorKey", accelerator);
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ViewActions.this.mainFrame.showAccessView(this.eventSource);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ViewLoggingAction
    extends AbstractAction {
        private static final long serialVersionUID = 6967472316665780683L;
        private EventSource<LoggingEvent> eventSource;

        public ViewLoggingAction(ViewContainer<LoggingEvent> container) {
            super(ViewActions.this.mainFrame.resolveSourceTitle(container));
            this.eventSource = container.getEventSource();
            if (this.eventSource.isGlobal()) {
                KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("VIEW_GLOBAL_CLASSIC_LOGS_ACTION");
                this.putValue("AcceleratorKey", accelerator);
            } else {
                SourceIdentifier si = this.eventSource.getSourceIdentifier();
                if (si != null && "Lilith".equals(si.getIdentifier())) {
                    KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("VIEW_LILITH_LOGS_ACTION");
                    this.putValue("AcceleratorKey", accelerator);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ViewActions.this.mainFrame.showLoggingView(this.eventSource);
        }
    }

    private class CloseAllFiltersAction
    extends AbstractAction {
        private static final long serialVersionUID = 1212878326080544663L;

        public CloseAllFiltersAction() {
            super("Close all filters");
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
            this.putValue("MnemonicKey", 97);
        }

        public void updateAction() {
            int viewCount = 0;
            if (ViewActions.this.viewContainer != null) {
                viewCount = ViewActions.this.viewContainer.getViewCount();
            }
            if (viewCount > 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.closeAllFilters();
        }
    }

    private class CloseOtherFiltersAction
    extends AbstractAction {
        private static final long serialVersionUID = -6399148183817841417L;

        public CloseOtherFiltersAction() {
            super("Close all other filters");
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
            this.putValue("MnemonicKey", 111);
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("CLOSE_OTHER_FILTERS_ACTION");
            this.putValue("AcceleratorKey", accelerator);
        }

        public void updateAction() {
            if (ViewActions.this.viewContainer != null) {
                int viewIndex = ViewActions.this.viewContainer.getViewIndex();
                int viewCount = ViewActions.this.viewContainer.getViewCount();
                if (viewIndex > -1 && (viewIndex == 0 && viewCount > 1 || viewCount > 2)) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.closeOtherFilters();
        }
    }

    private class CloseFilterAction
    extends AbstractAction {
        private static final long serialVersionUID = -842677137302613585L;

        public CloseFilterAction() {
            super("Close this filter");
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
            this.putValue("MnemonicKey", 99);
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("CLOSE_FILTER_ACTION");
            this.putValue("AcceleratorKey", accelerator);
        }

        public void updateAction() {
            if (ViewActions.this.viewContainer != null) {
                int viewIndex = ViewActions.this.viewContainer.getViewIndex();
                if (viewIndex > 0) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.closeCurrentFilter();
        }
    }

    private class ScrollToBottomToolBarAction
    extends AbstractAction {
        private static final long serialVersionUID = -7793074053120455264L;

        public ScrollToBottomToolBarAction() {
            this.putValue("SmallIcon", Icons.TAIL_TOOLBAR_ICON);
            this.putValue("ShortDescription", "Tail (\"scroll to bottom\")");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("SCROLL_TO_BOTTOM_ACTION");
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            boolean tail = !ViewActions.this.isScrollingToBottom();
            ViewActions.this.setScrollingToBottom(tail);
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("tail={}", (Object)tail);
            }
            ViewActions.this.focusTable();
        }
    }

    private class ScrollToBottomMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = -6698886479454486019L;
        private Icon selectedIcon;
        private Icon unselectedIcon;

        public ScrollToBottomMenuAction() {
            super("Tail");
            this.selectedIcon = Icons.TAIL_MENU_ICON;
            this.unselectedIcon = Icons.EMPTY_16_ICON;
            this.updateAction();
            this.putValue("ShortDescription", "Tail (\"scroll to bottom\")");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("SCROLL_TO_BOTTOM_ACTION");
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            boolean tail = !ViewActions.this.isScrollingToBottom();
            ViewActions.this.setScrollingToBottom(tail);
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("tail={}", (Object)tail);
            }
            ViewActions.this.focusTable();
        }

        public void updateAction() {
            if (ViewActions.this.isScrollingToBottom()) {
                this.putValue("SmallIcon", this.selectedIcon);
            } else {
                this.putValue("SmallIcon", this.unselectedIcon);
            }
        }
    }

    private class ResetFindAction
    extends AbstractAction {
        private static final long serialVersionUID = -1245378100755440576L;

        public ResetFindAction() {
            super("Reset find");
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("RESET_FIND_ACTION");
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.resetFind();
        }
    }

    private class FindPreviousActiveAction
    extends AbstractAction {
        private static final long serialVersionUID = 2473715367685180389L;

        public FindPreviousActiveAction() {
            super("Find previous active");
            this.putValue("SmallIcon", Icons.FIND_PREV_MENU_ICON);
            this.putValue("ShortDescription", "Find previous match of any active condition.");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("FIND_PREVIOUS_ACTIVE_ACTION");
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.findPreviousActive();
        }
    }

    private class FindNextActiveAction
    extends AbstractAction {
        private static final long serialVersionUID = 8153060295931745089L;

        public FindNextActiveAction() {
            super("Find next active");
            this.putValue("SmallIcon", Icons.FIND_NEXT_MENU_ICON);
            this.putValue("ShortDescription", "Find next match of any active condition.");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("FIND_NEXT_ACTIVE_ACTION");
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.findNextActive();
        }
    }

    private class FindPreviousAction
    extends AbstractAction {
        private static final long serialVersionUID = -284066693780808511L;

        public FindPreviousAction() {
            super("Find previous");
            this.putValue("SmallIcon", Icons.FIND_PREV_MENU_ICON);
            this.putValue("ShortDescription", "Find previous match of the current filter.");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("FIND_PREVIOUS_ACTION");
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.findPrevious();
        }
    }

    private class FindNextAction
    extends AbstractAction {
        private static final long serialVersionUID = 4771628062043742857L;

        public FindNextAction() {
            super("Find next");
            this.putValue("SmallIcon", Icons.FIND_NEXT_MENU_ICON);
            this.putValue("ShortDescription", "Find next match of the current filter.");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("FIND_NEXT_ACTION");
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.findNext();
        }
    }

    private class FocusEventsAction
    extends AbstractAction {
        private static final long serialVersionUID = 4207817900003297701L;

        public FocusEventsAction() {
            super("Focus events");
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
            this.putValue("ShortDescription", "Focus the table containing the events.");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("FOCUS_EVENTS_ACTION");
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.focusEvents();
        }
    }

    private class FocusMessageAction
    extends AbstractAction {
        private static final long serialVersionUID = -421929316399318971L;

        public FocusMessageAction() {
            super("Focus message");
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
            this.putValue("ShortDescription", "Focus detailed message view.");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("FOCUS_MESSAGE_ACTION");
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.focusMessage();
        }
    }

    private class DisconnectToolBarAction
    extends AbstractAction {
        private static final long serialVersionUID = -8665004340745035737L;

        public DisconnectToolBarAction() {
            this.putValue("SmallIcon", Icons.DISCONNECT_TOOLBAR_ICON);
            this.putValue("ShortDescription", "Disconnect");
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.disconnect();
        }
    }

    private class DisconnectMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 8971640305824353589L;

        public DisconnectMenuAction() {
            super("Disconnect");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("DISCONNECT_ACTION");
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("SmallIcon", Icons.DISCONNECT_MENU_ICON);
            this.putValue("ShortDescription", "Terminates this connection");
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.disconnect();
        }
    }

    private static class StatisticsMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = -6336357605789928345L;

        public StatisticsMenuAction() {
            super("Statistics");
            this.putValue("SmallIcon", Icons.STATISTICS_MENU_ICON);
            this.putValue("ShortDescription", "Statistics");
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private class FindToolBarAction
    extends AbstractAction {
        private static final long serialVersionUID = -4080152597948489206L;

        public FindToolBarAction() {
            this.putValue("SmallIcon", Icons.FIND_TOOLBAR_ICON);
            this.putValue("ShortDescription", "Find");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("FIND_ACTION");
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.setShowingFilters(true);
        }
    }

    private class FindMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 2241714830900044485L;

        public FindMenuAction() {
            super("Find");
            this.putValue("SmallIcon", Icons.FIND_MENU_ITEM);
            this.putValue("ShortDescription", "Opens the Find panel.");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("FIND_ACTION");
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.setShowingFilters(true);
        }
    }

    private class PauseToolBarAction
    extends AbstractAction {
        private static final long serialVersionUID = -5118623805829814815L;
        private Icon pausedIcon = Icons.PAUSED_TOOLBAR_ICON;
        private Icon unpausedIcon = Icons.UNPAUSED_TOOLBAR_ICON;

        public PauseToolBarAction() {
            this.updateAction();
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("PAUSE_ACTION");
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.setPaused(!ViewActions.this.isPaused());
            this.updateAction();
            ViewActions.this.focusTable();
        }

        public void updateAction() {
            if (ViewActions.this.isPaused()) {
                this.putValue("SmallIcon", this.pausedIcon);
                this.putValue("ShortDescription", "Unpause");
            } else {
                this.putValue("SmallIcon", this.unpausedIcon);
                this.putValue("ShortDescription", "Pause");
            }
        }
    }

    private class PauseMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = -5242236903640590549L;
        private Icon pausedIcon = Icons.PAUSED_MENU_ICON;
        private Icon unpausedIcon = Icons.UNPAUSED_MENU_ICON;

        public PauseMenuAction() {
            this.updateAction();
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("PAUSE_ACTION");
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.setPaused(!ViewActions.this.isPaused());
            this.updateAction();
            ViewActions.this.focusTable();
        }

        public void updateAction() {
            if (ViewActions.this.isPaused()) {
                this.putValue("SmallIcon", this.pausedIcon);
                this.putValue("Name", "Unpause");
            } else {
                this.putValue("SmallIcon", this.unpausedIcon);
                this.putValue("Name", "Pause");
            }
        }
    }

    private class AttachToolBarAction
    extends AbstractAction {
        private static final long serialVersionUID = -6338324258055926639L;
        private Icon attachIcon = Icons.ATTACH_TOOLBAR_ICON;
        private Icon detachIcon = Icons.DETACH_TOOLBAR_ICON;

        public AttachToolBarAction() {
            this.updateAction();
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.attachDetach();
            this.updateAction();
        }

        public void updateAction() {
            ViewContainer container = ViewActions.this.getViewContainer();
            if (container != null) {
                ViewWindow window = container.resolveViewWindow();
                if (window instanceof JInternalFrame) {
                    this.putValue("SmallIcon", this.detachIcon);
                    this.putValue("ShortDescription", "Detach");
                    return;
                }
                if (window instanceof JFrame) {
                    this.putValue("SmallIcon", this.attachIcon);
                    this.putValue("ShortDescription", "Attach");
                    return;
                }
            }
            this.putValue("SmallIcon", this.detachIcon);
            this.putValue("ShortDescription", "Detach");
        }
    }

    private class AttachMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = -6686061036755515933L;
        private Icon attachIcon = Icons.ATTACH_MENU_ICON;
        private Icon detachIcon = Icons.DETACH_MENU_ICON;

        public AttachMenuAction() {
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("ATTACH_ACTION");
            this.putValue("AcceleratorKey", accelerator);
            this.updateAction();
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.attachDetach();
            this.updateAction();
        }

        public void updateAction() {
            ViewContainer container = ViewActions.this.getViewContainer();
            if (container != null) {
                ViewWindow window = container.resolveViewWindow();
                if (window instanceof JInternalFrame) {
                    this.putValue("SmallIcon", this.detachIcon);
                    this.putValue("Name", "Detach");
                } else if (window instanceof JFrame) {
                    this.putValue("SmallIcon", this.attachIcon);
                    this.putValue("Name", "Attach");
                }
            }
        }
    }

    private class EditSourceNameMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 2807692748192366344L;

        public EditSourceNameMenuAction() {
            super("Edit source name...");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("EDIT_SOURCE_NAME_ACTION");
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
            this.putValue("ShortDescription", "Edit the source name of the current view.");
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.editSourceName();
        }

        public void updateAction() {
            String sourceIdentifier;
            EventWrapperViewPanel eventWrapperViewPanel;
            boolean enable = false;
            if (ViewActions.this.viewContainer != null && (eventWrapperViewPanel = ViewActions.this.viewContainer.getSelectedView()) != null && !"global".equals(sourceIdentifier = eventWrapperViewPanel.getEventSource().getSourceIdentifier().getIdentifier()) && !"Lilith".equals(sourceIdentifier)) {
                enable = true;
            }
            this.setEnabled(enable);
        }
    }

    private class SaveConditionMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = -8380709624103338783L;

        public SaveConditionMenuAction() {
            super("Save condition...");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("EDIT_CONDITION_ACTION");
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
            this.putValue("ShortDescription", "Add the condition of the current view.");
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.editCondition();
        }

        public void updateAction() {
            Condition currentFilter;
            Condition condition;
            EventWrapperViewPanel eventWrapperViewPanel;
            boolean enable = false;
            String tooltip = null;
            if (ViewActions.this.viewContainer != null && (eventWrapperViewPanel = ViewActions.this.viewContainer.getSelectedView()) != null && (condition = eventWrapperViewPanel.getCombinedCondition(currentFilter = eventWrapperViewPanel.getTable().getFilterCondition())) != null) {
                tooltip = TextPreprocessor.preformattedTooltip(TextPreprocessor.cropTextBlock(TextPreprocessor.formatCondition(condition)));
                enable = true;
            }
            this.putValue("ShortDescription", tooltip);
            this.setEnabled(enable);
        }
    }

    private class ResetZoomMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = -8380709624103338783L;

        public ResetZoomMenuAction() {
            super("Reset Zoom");
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
            this.putValue("ShortDescription", "Reset Zoom of the details view.");
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.resetZoom();
        }

        public void updateAction() {
            EventWrapperViewPanel eventWrapperViewPanel;
            boolean enable = false;
            if (ViewActions.this.viewContainer != null && (eventWrapperViewPanel = ViewActions.this.viewContainer.getSelectedView()) != null) {
                enable = true;
            }
            this.setEnabled(enable);
        }
    }

    private class ZoomOutMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = -8380709624103338783L;

        public ZoomOutMenuAction() {
            super("Zoom out");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("ZOOM_OUT_ACTION");
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
            this.putValue("ShortDescription", "Zoom out on the details view.");
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.zoomOut();
        }

        public void updateAction() {
            EventWrapperViewPanel eventWrapperViewPanel;
            boolean enable = false;
            if (ViewActions.this.viewContainer != null && (eventWrapperViewPanel = ViewActions.this.viewContainer.getSelectedView()) != null) {
                enable = true;
            }
            this.setEnabled(enable);
        }
    }

    private class ZoomInMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = -8380709624103338783L;

        public ZoomInMenuAction() {
            super("Zoom in");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("ZOOM_IN_ACTION");
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
            this.putValue("ShortDescription", "Zoom in on the details view.");
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.zoomIn();
        }

        public void updateAction() {
            EventWrapperViewPanel eventWrapperViewPanel;
            boolean enable = false;
            if (ViewActions.this.viewContainer != null && (eventWrapperViewPanel = ViewActions.this.viewContainer.getSelectedView()) != null) {
                enable = true;
            }
            this.setEnabled(enable);
        }
    }

    private class ClearMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 776175842981192877L;

        public ClearMenuAction() {
            super("Clear");
            this.putValue("SmallIcon", Icons.CLEAR_MENU_ICON);
            this.putValue("ShortDescription", "Clear this view.");
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.clear();
        }
    }

    private class ClearToolBarAction
    extends AbstractAction {
        private static final long serialVersionUID = -4713267797278778997L;

        public ClearToolBarAction() {
            this.putValue("SmallIcon", Icons.CLEAR_TOOLBAR_ICON);
            this.putValue("ShortDescription", "Clear");
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.clear();
        }
    }

    private class MinimizeAllOtherAction
    extends AbstractAction {
        private static final long serialVersionUID = -2357859864329239268L;

        public MinimizeAllOtherAction() {
            super("Minimize all other");
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.minimizeAllViews(ViewActions.this.viewContainer);
            ViewActions.this.mainFrame.updateWindowMenus();
        }
    }

    private class MinimizeAllAction
    extends AbstractAction {
        private static final long serialVersionUID = -8828005158469519472L;

        public MinimizeAllAction() {
            super("Minimize all");
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.minimizeAllViews(null);
            ViewActions.this.mainFrame.updateWindowMenus();
        }
    }

    private class CloseOtherAction
    extends AbstractAction {
        private static final long serialVersionUID = -3031217070975763827L;

        public CloseOtherAction() {
            super("Close all other");
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.closeAllViews(ViewActions.this.viewContainer);
            ViewActions.this.mainFrame.updateWindowMenus();
        }
    }

    private class CloseAllAction
    extends AbstractAction {
        private static final long serialVersionUID = -1587444647880660196L;

        public CloseAllAction() {
            super("Close all");
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("CLOSE_ALL_ACTION");
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.closeAllViews(null);
            ViewActions.this.mainFrame.updateWindowMenus();
        }
    }

    private class ShowTaskManagerAction
    extends AbstractAction {
        private static final long serialVersionUID = -8228641057263498624L;

        public ShowTaskManagerAction() {
            super("Task Manager");
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.showTaskManager();
        }
    }

    private class RemoveInactiveAction
    extends AbstractAction {
        private static final long serialVersionUID = -6662970580652310690L;

        public RemoveInactiveAction() {
            super("Remove inactive");
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("REMOVE_INACTIVE_ACTION");
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("MnemonicKey", 114);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.removeInactiveViews(false, false);
            ViewActions.this.mainFrame.updateWindowMenus();
        }
    }

    private class ClearRecentFilesAction
    extends AbstractAction {
        private static final long serialVersionUID = 2330892725802760973L;

        public ClearRecentFilesAction() {
            super("Clear Recent Files");
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
            this.putValue("MnemonicKey", 99);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.getApplicationPreferences().clearRecentFiles();
        }
    }

    private class OpenFileAction
    extends AbstractAction {
        private static final long serialVersionUID = 3138705799791457944L;
        private String absoluteName;

        public OpenFileAction(String absoluteName, boolean fullPath) {
            this.absoluteName = absoluteName;
            String name = absoluteName;
            if (!fullPath) {
                File f = new File(absoluteName);
                name = f.getName();
            }
            this.putValue("Name", name);
            this.putValue("SmallIcon", Icons.EMPTY_16_ICON);
            this.putValue("ShortDescription", absoluteName);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.open(new File(this.absoluteName));
        }
    }
}

