/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.sulky.conditions.And;
import de.huxhorn.sulky.conditions.Condition;
import de.huxhorn.sulky.conditions.ConditionGroup;
import de.huxhorn.sulky.conditions.ConditionWrapper;
import de.huxhorn.sulky.conditions.Not;
import de.huxhorn.sulky.conditions.Or;
import de.huxhorn.sulky.formatting.SimpleXml;
import java.util.List;

public class TextPreprocessor {
    private static final int MAX_LINE_LENGTH = 100;
    private static final int MAX_LINES = 40;
    private static final String TAB_REPLACEMENT = "    ";
    private static final String LINE_TRUNCATION = "[..]";
    private static final String INDENT = "    ";

    public static String cropLine(String text) {
        return TextPreprocessor.cropLine(text, 100, LINE_TRUNCATION);
    }

    public static String cropToSingleLine(String text) {
        return TextPreprocessor.cropLine(text, 0, null);
    }

    private static String cropLine(String text, int maxLineLength, String lineTruncationMarker) {
        if (text == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int newlineIndex = text.indexOf(10);
        if (newlineIndex > -1) {
            int newlineCounter = 0;
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) != '\n') continue;
                ++newlineCounter;
            }
            TextPreprocessor.appendTruncated(text.subSequence(0, newlineIndex), result, maxLineLength, lineTruncationMarker);
            if (newlineCounter == 1) {
                result.append(" [+1 line]");
            } else if (newlineCounter > 1) {
                result.append(" [+").append(newlineCounter).append(" lines]");
            }
        } else {
            TextPreprocessor.appendTruncated(text, result, maxLineLength, lineTruncationMarker);
        }
        return result.toString();
    }

    public static String cropTextBlock(String text) {
        return TextPreprocessor.cropTextBlock(text, 100, LINE_TRUNCATION, 40, "    ");
    }

    private static String cropTextBlock(String text, int maxLineLength, String lineTruncationMarker, int maxLines, String tabReplacement) {
        if (text == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        StringBuilder lineBuilder = new StringBuilder();
        int lineCounter = 0;
        for (int i = 0; i < text.length(); ++i) {
            char current = text.charAt(i);
            if (current == '\t') {
                if (tabReplacement != null) {
                    lineBuilder.append(tabReplacement);
                    continue;
                }
                lineBuilder.append('\t');
                continue;
            }
            if (current == '\n') {
                if (lineCounter < maxLines) {
                    TextPreprocessor.appendTruncated(lineBuilder, result, maxLineLength, lineTruncationMarker);
                    result.append('\n');
                }
                lineBuilder.setLength(0);
                ++lineCounter;
                continue;
            }
            if (current == '\r') continue;
            lineBuilder.append(current);
        }
        if (lineCounter >= maxLines) {
            int remaining = lineCounter - maxLines + 1;
            result.append("[.. ").append(remaining).append(" more lines ..]");
        } else {
            TextPreprocessor.appendTruncated(lineBuilder, result, maxLineLength, lineTruncationMarker);
        }
        return result.toString();
    }

    private static void appendTruncated(CharSequence sourceBuilder, StringBuilder targetBuilder, int maxLineLength, String lineTruncationMarker) {
        if (maxLineLength < 1 || sourceBuilder.length() <= maxLineLength) {
            targetBuilder.append(sourceBuilder);
            return;
        }
        if (lineTruncationMarker == null) {
            targetBuilder.append(sourceBuilder.subSequence(0, maxLineLength));
        } else {
            targetBuilder.append(sourceBuilder.subSequence(0, maxLineLength - lineTruncationMarker.length()));
            targetBuilder.append(lineTruncationMarker);
        }
    }

    public static String wrapWithPre(String text) {
        if (text == null) {
            return null;
        }
        text = SimpleXml.escape((String)text);
        text = text.replace("\n", "<br>");
        return "<tt><pre>" + text + "</pre></tt>";
    }

    public static String preformattedTooltip(String text) {
        if (text == null) {
            return null;
        }
        return "<html>" + TextPreprocessor.wrapWithPre(text) + "</html>";
    }

    public static String formatCondition(Condition condition) {
        if (condition == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        TextPreprocessor.formatCondition(condition, result, 0);
        return result.toString();
    }

    private static void formatCondition(Condition condition, StringBuilder result, int indent) {
        if (condition == null) {
            TextPreprocessor.appendIndent(result, indent);
            result.append("null");
        } else if (condition instanceof ConditionWrapper) {
            ConditionWrapper wrapper = (ConditionWrapper)condition;
            String operator = wrapper instanceof Not ? "!" : wrapper.getClass().getSimpleName();
            Condition c = wrapper.getCondition();
            TextPreprocessor.appendIndent(result, indent);
            result.append(operator).append("(");
            if (c == null) {
                result.append("null");
            } else {
                result.append("\n");
                TextPreprocessor.formatCondition(c, result, indent + 1);
                TextPreprocessor.appendIndent(result, indent);
            }
            result.append(")");
        } else if (condition instanceof ConditionGroup) {
            ConditionGroup group = (ConditionGroup)condition;
            String operator = group instanceof And ? "&&" : (group instanceof Or ? "||" : group.getClass().getSimpleName());
            List conditions = group.getConditions();
            TextPreprocessor.appendIndent(result, indent);
            result.append("(");
            if (conditions == null || conditions.isEmpty()) {
                result.append("[").append(operator).append(" without conditions.]");
            } else {
                result.append("\n");
                boolean first = true;
                for (Condition current : conditions) {
                    if (first) {
                        first = false;
                    } else {
                        TextPreprocessor.appendIndent(result, indent + 1);
                        result.append(operator).append("\n");
                    }
                    TextPreprocessor.formatCondition(current, result, indent + 1);
                }
                TextPreprocessor.appendIndent(result, indent);
            }
            result.append(")");
        } else {
            TextPreprocessor.appendIndent(result, indent);
            result.append(condition);
        }
        if (indent > 0) {
            result.append("\n");
        }
    }

    private static void appendIndent(StringBuilder result, int indent) {
        for (int i = 0; i < indent; ++i) {
            result.append("    ");
        }
    }
}

