/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.swing.LilithKeyStrokes;
import de.huxhorn.sulky.swing.KeyStrokes;
import de.huxhorn.sulky.tasks.Task;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressGlassPane
extends JPanel {
    private final Logger logger = LoggerFactory.getLogger(ProgressGlassPane.class);
    private CancelAction cancelAction;
    private JProgressBar progressBar;
    private JButton cancelButton;

    public ProgressGlassPane() {
        super(new GridBagLayout());
        MouseEventEater eater = new MouseEventEater();
        this.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        JLabel searchLabel = new JLabel("Searching...");
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)searchLabel, gbc);
        this.progressBar = new JProgressBar(0, 0, 100);
        this.progressBar.setStringPainted(true);
        gbc.gridy = 1;
        this.add((Component)this.progressBar, gbc);
        this.cancelAction = new CancelAction();
        this.cancelButton = new JButton(this.cancelAction);
        gbc.gridy = 2;
        this.add((Component)this.cancelButton, gbc);
        this.addKeyListener(new KeyAdapter(){});
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                ProgressGlassPane.this.cancelButton.requestFocusInWindow();
            }
        });
        this.setFocusTraversalKeysEnabled(false);
        KeyStrokes.registerCommand((JComponent)this, (Action)this.cancelAction, (String)"CANCEL_ACTION");
        this.addMouseListener(eater);
        this.addMouseMotionListener(eater);
    }

    public JInternalFrame resolveInternalFrame() {
        Container parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof JInternalFrame); parent = parent.getParent()) {
        }
        return (JInternalFrame)parent;
    }

    protected void paintComponent(Graphics g) {
        Rectangle clip = g.getClipBounds();
        Graphics2D g2 = (Graphics2D)g.create();
        AlphaComposite alpha = AlphaComposite.getInstance(3, 0.65f);
        g2.setComposite(alpha);
        g2.setColor(Color.WHITE);
        g2.fillRect(clip.x, clip.y, clip.width, clip.height);
        g2.dispose();
        this.paintComponents(g);
    }

    public void setProgress(int progressValue) {
        this.progressBar.setValue(progressValue);
    }

    public CancelAction getFindCancelAction() {
        return this.cancelAction;
    }

    private static class MouseEventEater
    implements MouseListener,
    MouseMotionListener {
        private MouseEventEater() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CancelAction
    extends AbstractAction {
        private Task<Long> task;

        public CancelAction() {
            this.putValue("Name", "Cancel");
            this.putValue("ShortDescription", "Cancel search.");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("ESCAPE");
            this.putValue("AcceleratorKey", accelerator);
            this.setTask(null);
        }

        public Task<Long> getTask() {
            return this.task;
        }

        public void setTask(Task<Long> task) {
            this.task = task;
            this.setEnabled(this.task != null);
        }

        public void cancelSearch() {
            Task<Long> task = this.task;
            if (task != null) {
                task.getFuture().cancel(true);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.cancelSearch();
        }
    }
}

