/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.sulky.swing.KeyStrokes;
import java.util.HashMap;
import java.util.Map;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LilithKeyStrokes {
    private static final Map<String, KeyStroke> actionKeyStrokes = new HashMap<String, KeyStroke>();
    private static final Map<KeyStroke, String> keyStrokeActions = new HashMap<KeyStroke, String>();
    public static final String ATTACH_ACTION = "ATTACH_ACTION";
    public static final String CLEAN_ALL_INACTIVE_LOGS_ACTION = "CLEAN_ALL_INACTIVE_LOGS_ACTION";
    public static final String CLOSE_ALL_ACTION = "CLOSE_ALL_ACTION";
    public static final String CLOSE_FILTER_ACTION = "CLOSE_FILTER_ACTION";
    public static final String CLOSE_OTHER_FILTERS_ACTION = "CLOSE_OTHER_FILTERS_ACTION";
    public static final String COPY_SELECTION_ACTION = "COPY_SELECTION_ACTION";
    public static final String DISCONNECT_ACTION = "DISCONNECT_ACTION";
    public static final String EDIT_CONDITION_ACTION = "EDIT_CONDITION_ACTION";
    public static final String EDIT_SOURCE_NAME_ACTION = "EDIT_SOURCE_NAME_ACTION";
    public static final String ENTER = "ENTER";
    public static final String ESCAPE = "ESCAPE";
    public static final String EXIT_ACTION = "EXIT_ACTION";
    public static final String EXPORT_ACTION = "EXPORT_ACTION";
    public static final String FIND_ACTION = "FIND_ACTION";
    public static final String FIND_NEXT_ACTION = "FIND_NEXT_ACTION";
    public static final String FIND_NEXT_ACTIVE_ACTION = "FIND_NEXT_ACTIVE_ACTION";
    public static final String FIND_PREVIOUS_ACTION = "FIND_PREVIOUS_ACTION";
    public static final String FIND_PREVIOUS_ACTIVE_ACTION = "FIND_PREVIOUS_ACTIVE_ACTION";
    public static final String FOCUS_EVENTS_ACTION = "FOCUS_EVENTS_ACTION";
    public static final String FOCUS_MESSAGE_ACTION = "FOCUS_MESSAGE_ACTION";
    public static final String HELP_ACTION = "HELP_ACTION";
    public static final String IMPORT_ACTION = "IMPORT_ACTION";
    public static final String NEXT_TAB_ACTION = "NEXT_TAB_ACTION";
    public static final String OPEN_ACTION = "OPEN_ACTION";
    public static final String OPEN_INACTIVE_ACTION = "OPEN_INACTIVE_ACTION";
    public static final String PASTE_STACK_TRACE_ELEMENT_ACTION = "PASTE_STACK_TRACE_ELEMENT_ACTION";
    public static final String PAUSE_ACTION = "PAUSE_ACTION";
    public static final String PREFERENCES_ACTION = "PREFERENCES_ACTION";
    public static final String PREVIOUS_TAB_ACTION = "PREVIOUS_TAB_ACTION";
    public static final String REMOVE_INACTIVE_ACTION = "REMOVE_INACTIVE_ACTION";
    public static final String REPLACE_FILTER_ACTION = "REPLACE_FILTER_ACTION";
    public static final String RESET_FIND_ACTION = "RESET_FIND_ACTION";
    public static final String SCROLL_TO_BOTTOM_ACTION = "SCROLL_TO_BOTTOM_ACTION";
    public static final String VIEW_GLOBAL_ACCESS_LOGS_ACTION = "VIEW_GLOBAL_ACCESS_LOGS_ACTION";
    public static final String VIEW_GLOBAL_CLASSIC_LOGS_ACTION = "VIEW_GLOBAL_CLASSIC_LOGS_ACTION";
    public static final String VIEW_LILITH_LOGS_ACTION = "VIEW_LILITH_LOGS_ACTION";
    public static final String ZOOM_IN_ACTION = "ZOOM_IN_ACTION";
    public static final String ZOOM_OUT_ACTION = "ZOOM_OUT_ACTION";

    private static void addKeyStroke(String actionName, String keyStrokeString) {
        Logger logger = LoggerFactory.getLogger(LilithKeyStrokes.class);
        KeyStroke keyStroke = KeyStrokes.resolveAcceleratorKeyStroke((String)keyStrokeString);
        if (keyStroke == null) {
            if (logger.isErrorEnabled()) {
                logger.error("KeyStroke '{}' for '{}' did not resolve to a KeyStroke!", (Object)keyStrokeString, (Object)actionName);
            }
            return;
        }
        String existingActionName = keyStrokeActions.get(keyStroke);
        if (existingActionName != null) {
            if (logger.isWarnEnabled()) {
                logger.warn("KeyStroke '{}' is already used for '{}'! Ignoring '{}'.", new Object[]{keyStrokeString, existingActionName, actionName});
            }
            return;
        }
        KeyStroke existingKeyStroke = actionKeyStrokes.get(actionName);
        if (existingKeyStroke != null) {
            if (logger.isWarnEnabled()) {
                logger.warn("Duplicate entry for '{}'! Won't overwrite '{}' with '{}'.", new Object[]{actionName, existingKeyStroke, keyStroke});
            }
            return;
        }
        actionKeyStrokes.put(actionName, keyStroke);
        keyStrokeActions.put(keyStroke, actionName);
    }

    public static KeyStroke getKeyStroke(String actionName) {
        return actionKeyStrokes.get(actionName);
    }

    public static String getActionName(KeyStroke keyStroke) {
        return keyStrokeActions.get(keyStroke);
    }

    static {
        LilithKeyStrokes.addKeyStroke(ATTACH_ACTION, "command shift A");
        LilithKeyStrokes.addKeyStroke(CLEAN_ALL_INACTIVE_LOGS_ACTION, "command shift X");
        LilithKeyStrokes.addKeyStroke(CLOSE_ALL_ACTION, "command shift alt W");
        LilithKeyStrokes.addKeyStroke(CLOSE_FILTER_ACTION, "command W");
        LilithKeyStrokes.addKeyStroke(CLOSE_OTHER_FILTERS_ACTION, "command shift W");
        LilithKeyStrokes.addKeyStroke(COPY_SELECTION_ACTION, "command C");
        LilithKeyStrokes.addKeyStroke(DISCONNECT_ACTION, "command shift D");
        LilithKeyStrokes.addKeyStroke(EDIT_CONDITION_ACTION, "command I");
        LilithKeyStrokes.addKeyStroke(EDIT_SOURCE_NAME_ACTION, "command B");
        LilithKeyStrokes.addKeyStroke(ENTER, ENTER);
        LilithKeyStrokes.addKeyStroke(ESCAPE, ESCAPE);
        LilithKeyStrokes.addKeyStroke(EXIT_ACTION, "command Q");
        LilithKeyStrokes.addKeyStroke(EXPORT_ACTION, "command shift E");
        LilithKeyStrokes.addKeyStroke(FIND_ACTION, "command F");
        LilithKeyStrokes.addKeyStroke(FIND_NEXT_ACTION, "command shift G");
        LilithKeyStrokes.addKeyStroke(FIND_NEXT_ACTIVE_ACTION, "command shift L");
        LilithKeyStrokes.addKeyStroke(FIND_PREVIOUS_ACTION, "command G");
        LilithKeyStrokes.addKeyStroke(FIND_PREVIOUS_ACTIVE_ACTION, "command L");
        LilithKeyStrokes.addKeyStroke(FOCUS_EVENTS_ACTION, "command E");
        LilithKeyStrokes.addKeyStroke(FOCUS_MESSAGE_ACTION, "command M");
        LilithKeyStrokes.addKeyStroke(HELP_ACTION, "F1");
        LilithKeyStrokes.addKeyStroke(IMPORT_ACTION, "command shift I");
        LilithKeyStrokes.addKeyStroke(NEXT_TAB_ACTION, "command K");
        LilithKeyStrokes.addKeyStroke(OPEN_ACTION, "command O");
        LilithKeyStrokes.addKeyStroke(OPEN_INACTIVE_ACTION, "command shift O");
        LilithKeyStrokes.addKeyStroke(PASTE_STACK_TRACE_ELEMENT_ACTION, "command shift V");
        LilithKeyStrokes.addKeyStroke(PAUSE_ACTION, "command P");
        LilithKeyStrokes.addKeyStroke(PREFERENCES_ACTION, "command COMMA");
        LilithKeyStrokes.addKeyStroke(PREVIOUS_TAB_ACTION, "command J");
        LilithKeyStrokes.addKeyStroke(REMOVE_INACTIVE_ACTION, "command R");
        LilithKeyStrokes.addKeyStroke(REPLACE_FILTER_ACTION, "shift ENTER");
        LilithKeyStrokes.addKeyStroke(RESET_FIND_ACTION, "command shift F");
        LilithKeyStrokes.addKeyStroke(SCROLL_TO_BOTTOM_ACTION, "command T");
        LilithKeyStrokes.addKeyStroke(VIEW_GLOBAL_ACCESS_LOGS_ACTION, "command 2");
        LilithKeyStrokes.addKeyStroke(VIEW_GLOBAL_CLASSIC_LOGS_ACTION, "command 1");
        LilithKeyStrokes.addKeyStroke(VIEW_LILITH_LOGS_ACTION, "command 0");
        LilithKeyStrokes.addKeyStroke(ZOOM_IN_ACTION, "command PERIOD");
        LilithKeyStrokes.addKeyStroke(ZOOM_OUT_ACTION, "command shift PERIOD");
    }
}

