/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

class HtmlTransferable
implements Transferable {
    public static final DataFlavor XHTML_FLAVOR = new DataFlavor("application/xhtml+xml; charset=\"UTF-8\"", "HTML");
    public static final DataFlavor PLAIN_TEXT_FLAVOR = new DataFlavor("text/plain; charset=\"UTF-8\"", "UTF-8 Text");
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{XHTML_FLAVOR, PLAIN_TEXT_FLAVOR};
    private String html;
    private byte[] data;

    public HtmlTransferable(String html) {
        this.html = html;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bos, "UTF-8");
            osw.append(html);
            osw.flush();
            osw.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.data = bos.toByteArray();
    }

    public String getHtml() {
        return this.html;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])FLAVORS.clone();
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor aFlavor : FLAVORS) {
            if (!flavor.equals(aFlavor)) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(XHTML_FLAVOR) || flavor.equals(PLAIN_TEXT_FLAVOR)) {
            return new ByteArrayInputStream(this.data);
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

