/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import de.huxhorn.lilith.conditions.GroovyCondition;
import de.huxhorn.lilith.conditions.SearchStringCondition;
import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.EventWrapperViewPanel;
import de.huxhorn.lilith.swing.LilithKeyStrokes;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.ProgressGlassPane;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.preferences.SavedCondition;
import de.huxhorn.sulky.conditions.Condition;
import de.huxhorn.sulky.conditions.Not;
import de.huxhorn.sulky.swing.KeyStrokes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindPanel<T extends Serializable>
extends JPanel {
    private final Logger logger = LoggerFactory.getLogger(FindPanel.class);
    private static final String GROOVY_IDENTIFIER = "#groovy#";
    private static final String SAVED_CONDITION_IDENTIFIER = "#condition#";
    private static final Color ERROR_COLOR = new Color(0x990000);
    private static final Color NO_ERROR_COLOR = Color.BLACK;
    public static final String CONDITION_PROPERTY = "condition";
    private MainFrame mainFrame;
    private EventWrapperViewPanel<T> eventWrapperViewPanel;
    private FindNextAction findNextAction;
    private FindPreviousAction findPrevAction;
    private CloseFindAction closeFindAction;
    private JButton closeFindButton;
    private JToggleButton findNotButton;
    private JButton findPrevButton;
    private JButton findNextButton;
    private Condition condition;
    private ApplicationPreferences applicationPreferences;
    private List<String> previousSearchStrings;
    private List<String> conditionNames;
    private JComboBox findTypeCombo;
    private BasicEventList<String> findTypeEventList;
    private JComboBox findTextCombo;
    private BasicEventList<String> findTextEventList;

    public FindPanel(EventWrapperViewPanel<T> eventWrapperViewPanel) {
        this.eventWrapperViewPanel = eventWrapperViewPanel;
        this.mainFrame = this.eventWrapperViewPanel.getMainFrame();
        this.applicationPreferences = this.mainFrame.getApplicationPreferences();
        this.previousSearchStrings = this.applicationPreferences.getPreviousSearchStrings();
        this.conditionNames = this.applicationPreferences.getConditionNames();
        this.initUi();
    }

    private void initUi() {
        this.closeFindAction = new CloseFindAction();
        this.closeFindButton = new JButton(this.closeFindAction);
        this.closeFindButton.setMargin(new Insets(0, 0, 0, 0));
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 21;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.closeFindButton, gbc);
        gbc.gridx = 1;
        this.add((Component)new JLabel(" Find: "), gbc);
        FindTypeSelectionActionListener findTypeModifiedListener = new FindTypeSelectionActionListener();
        this.findTypeCombo = new JComboBox();
        this.findTypeEventList = new BasicEventList();
        AutoCompleteSupport findTypeComboAutoSupport = AutoCompleteSupport.install((JComboBox)this.findTypeCombo, this.findTypeEventList);
        findTypeComboAutoSupport.setFirstItem((Object)"");
        findTypeComboAutoSupport.setStrict(true);
        findTypeComboAutoSupport.setCorrectsCase(true);
        findTypeComboAutoSupport.setTextMatchingStrategy(TextMatcherEditor.IDENTICAL_STRATEGY);
        findTypeComboAutoSupport.setFilterMode(0);
        findTypeComboAutoSupport.setBeepOnStrictViolation(false);
        this.findTypeCombo.addActionListener(findTypeModifiedListener);
        this.findNotButton = new JToggleButton("!");
        this.findNotButton.addActionListener(findTypeModifiedListener);
        this.findNotButton.setToolTipText("Not - inverts condition");
        this.findNotButton.setMargin(new Insets(0, 0, 0, 0));
        this.findTextCombo = new JComboBox();
        this.findTextEventList = new BasicEventList();
        AutoCompleteSupport findTextComboAutoSupport = AutoCompleteSupport.install((JComboBox)this.findTextCombo, this.findTextEventList);
        findTextComboAutoSupport.setFirstItem((Object)"");
        findTextComboAutoSupport.setStrict(false);
        findTextComboAutoSupport.setCorrectsCase(false);
        findTextComboAutoSupport.setTextMatchingStrategy(TextMatcherEditor.NORMALIZED_STRATEGY);
        findTextComboAutoSupport.setFilterMode(0);
        gbc.gridx = 2;
        gbc.fill = 3;
        this.add((Component)this.findNotButton, gbc);
        gbc.gridx = 3;
        gbc.fill = 3;
        this.add((Component)this.findTypeCombo, gbc);
        gbc.gridx = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.findTextCombo, gbc);
        this.findPrevAction = new FindPreviousAction();
        this.findPrevButton = new JButton(this.findPrevAction);
        this.findPrevButton.setMargin(new Insets(0, 0, 0, 0));
        gbc.gridx = 5;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        this.add((Component)this.findPrevButton, gbc);
        this.findNextAction = new FindNextAction();
        this.findNextButton = new JButton(this.findNextAction);
        this.findNextButton.setMargin(new Insets(0, 0, 0, 0));
        gbc.gridx = 6;
        this.add((Component)this.findNextButton, gbc);
        FindTextFieldListener findTextFieldListener = new FindTextFieldListener();
        JTextComponent findEditorComponent = this.getFindEditorComponent();
        if (findEditorComponent instanceof JTextField) {
            ((JTextField)findEditorComponent).addActionListener(findTextFieldListener);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("findEditorComponent ({}) is not instanceof JTextField!", (Object)findEditorComponent.getClass().getName());
        }
        if (findEditorComponent != null) {
            findEditorComponent.getDocument().addDocumentListener(findTextFieldListener);
            findEditorComponent.setForeground(NO_ERROR_COLOR);
        }
        ReplaceFilterAction replaceFilterAction = new ReplaceFilterAction();
        KeyStrokes.registerCommand((JComponent)this, (Action)this.findNextAction, (String)"FIND_NEXT_ACTION");
        KeyStrokes.registerCommand((JComponent)this, (Action)this.findPrevAction, (String)"FIND_PREV_ACTION");
        KeyStrokes.registerCommand((JComponent)this, (Action)this.closeFindAction, (String)"CLOSE_FIND_ACTION");
        KeyStrokes.registerCommand((JComponent)this.findTextCombo, (Action)replaceFilterAction, (String)"REPLACE_FILTER_ACTION");
        MyFocusTraversalPolicy focusTraversalPolicy = new MyFocusTraversalPolicy();
        this.setFocusTraversalPolicy(focusTraversalPolicy);
        this.setFocusCycleRoot(false);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusable(true);
    }

    private void setCondition(Condition condition) {
        Condition oldValue;
        block2: {
            oldValue = this.getCondition();
            try {
                this.condition = condition != null ? condition.clone() : null;
            }
            catch (CloneNotSupportedException e) {
                this.condition = null;
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn("Condition {} does not support cloning!", (Object)condition, (Object)e);
            }
        }
        Condition newValue = this.getCondition();
        this.findPrevAction.setEnabled(this.condition != null);
        this.findNextAction.setEnabled(this.condition != null);
        this.firePropertyChange(CONDITION_PROPERTY, oldValue, newValue);
    }

    public Condition getCondition() {
        if (this.condition == null) {
            return null;
        }
        try {
            return this.condition.clone();
        }
        catch (CloneNotSupportedException e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Condition {} does not support cloning!", (Object)this.condition, (Object)e);
            }
            return null;
        }
    }

    private void updateCondition() {
        this.setCondition(this.createCondition());
    }

    private Condition createCondition() {
        String text = null;
        JTextComponent findEditorComponent = this.getFindEditorComponent();
        if (findEditorComponent != null) {
            text = findEditorComponent.getText();
        }
        Condition condition = null;
        String errorMessage = null;
        if (text == null) {
            text = "";
        }
        if (text.startsWith(GROOVY_IDENTIFIER)) {
            File resolvedScriptFile;
            String scriptName = text.substring(GROOVY_IDENTIFIER.length());
            int idx = scriptName.indexOf(35);
            if (idx > -1) {
                text = idx + 1 < scriptName.length() ? scriptName.substring(idx + 1) : "";
                scriptName = scriptName.substring(0, idx);
            } else {
                text = "";
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("GroovyCondition with scriptName '{}' and searchString '{}'", (Object)scriptName, (Object)text);
            }
            if ((resolvedScriptFile = this.applicationPreferences.resolveGroovyConditionScriptFile(scriptName)) != null) {
                condition = new GroovyCondition(resolvedScriptFile.getAbsolutePath(), text);
            } else {
                errorMessage = "Couldn't find groovy script '" + scriptName + "'.";
                condition = null;
            }
        } else if (text.startsWith(SAVED_CONDITION_IDENTIFIER)) {
            String conditionName = text.substring(SAVED_CONDITION_IDENTIFIER.length());
            SavedCondition savedCondition = this.applicationPreferences.resolveSavedCondition(conditionName);
            if (savedCondition != null) {
                condition = savedCondition.getCondition();
            } else {
                errorMessage = "Couldn't find saved condition named '" + conditionName + "'.";
                condition = null;
            }
        } else {
            String selectedType = (String)this.findTypeCombo.getSelectedItem();
            try {
                condition = this.applicationPreferences.createCondition(selectedType, text);
            }
            catch (IllegalArgumentException ex) {
                errorMessage = ex.getMessage();
            }
        }
        if (findEditorComponent != null) {
            if (errorMessage != null) {
                findEditorComponent.setForeground(ERROR_COLOR);
                findEditorComponent.setToolTipText(errorMessage);
            } else {
                findEditorComponent.setForeground(NO_ERROR_COLOR);
                findEditorComponent.setToolTipText(null);
            }
        }
        if (condition != null && this.findNotButton.isSelected()) {
            condition = new Not(condition);
        }
        return condition;
    }

    public void resetFind() {
        JTextComponent findEditorComponent = this.getFindEditorComponent();
        if (findEditorComponent != null) {
            findEditorComponent.setText("");
        }
    }

    public void updateUi() {
        String conditionName;
        this.initTypeCombo();
        Condition condition = this.eventWrapperViewPanel.getFilterCondition();
        boolean not = false;
        if (condition instanceof Not) {
            Not notCondition = (Not)condition;
            not = true;
            condition = notCondition.getCondition();
        }
        if (condition != null && (conditionName = this.applicationPreferences.resolveConditionName(condition)) != null) {
            this.findTypeCombo.setSelectedItem(conditionName);
        }
        this.findNotButton.setSelected(not);
        this.updateFindCombo();
    }

    private void initTypeCombo() {
        List<String> itemsVector = this.applicationPreferences.retrieveAllConditions();
        this.findTypeEventList.clear();
        this.findTypeEventList.addAll(itemsVector);
        this.findTypeCombo.setSelectedItem(this.applicationPreferences.getDefaultConditionName());
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Visible: {}", (Object)visible);
        }
    }

    private JTextComponent getFindEditorComponent() {
        Component findComponent = this.findTextCombo.getEditor().getEditorComponent();
        if (findComponent instanceof JTextComponent) {
            return (JTextComponent)findComponent;
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("findComponent ({}) is not instanceof JTextComponent!", (Object)findComponent.getClass().getName());
        }
        return null;
    }

    public void requestComboFocus() {
        this.findTextCombo.requestFocusInWindow();
        this.findTextCombo.getEditor().selectAll();
    }

    public void enableFindComponents(boolean enabled, Condition condition) {
        this.closeFindAction.setEnabled(enabled);
        this.findTextCombo.setEnabled(enabled);
        if (condition != null) {
            this.findPrevAction.setEnabled(enabled);
            this.findNextAction.setEnabled(enabled);
        } else {
            this.findPrevAction.setEnabled(false);
            this.findNextAction.setEnabled(false);
        }
    }

    private void updateFindCombo() {
        String selectedType = (String)this.findTypeCombo.getSelectedItem();
        if ("Level>=".equals(selectedType)) {
            this.findTextEventList.clear();
            this.findTextEventList.addAll(this.applicationPreferences.retrieveLevelValues());
        } else if ("Saved".equals(selectedType)) {
            this.findTextEventList.clear();
            this.findTextEventList.addAll(this.conditionNames);
        } else {
            String prev = (String)this.findTextCombo.getSelectedItem();
            this.findTextEventList.clear();
            this.findTextEventList.addAll(this.previousSearchStrings);
            this.findTextCombo.setSelectedItem(prev);
        }
    }

    public void setPreviousSearchStrings(List<String> previousSearchStrings) {
        this.previousSearchStrings = new ArrayList<String>(previousSearchStrings);
        this.previousSearchStrings.add(0, "");
        this.updateFindCombo();
    }

    public void setConditionNames(List<String> conditionNames) {
        this.conditionNames = conditionNames;
        this.updateFindCombo();
    }

    private class FindTypeSelectionActionListener
    implements ActionListener {
        private FindTypeSelectionActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            FindPanel.this.updateFindCombo();
            FindPanel.this.updateCondition();
        }
    }

    private class ReplaceFilterAction
    extends AbstractAction {
        private static final long serialVersionUID = 3876315232050114189L;

        public ReplaceFilterAction() {
            this.putValue("ShortDescription", "Replace filter.");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("REPLACE_FILTER_ACTION");
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewContainer container;
            if (FindPanel.this.logger.isInfoEnabled()) {
                FindPanel.this.logger.info("Replace filter.");
            }
            if ((container = FindPanel.this.eventWrapperViewPanel.resolveContainer()) == null) {
                return;
            }
            Condition filter = FindPanel.this.eventWrapperViewPanel.resolveCombinedCondition();
            if (filter == null) {
                return;
            }
            container.replaceFilteredView(FindPanel.this.eventWrapperViewPanel, filter);
        }
    }

    private class CloseFindAction
    extends AbstractAction {
        private static final long serialVersionUID = -7757686292973276423L;

        public CloseFindAction() {
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/emblems/emblem-unreadable.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Close");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("ESCAPE");
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewContainer container = FindPanel.this.eventWrapperViewPanel.resolveContainer();
            if (container != null) {
                ProgressGlassPane progressPanel = container.getProgressPanel();
                progressPanel.getFindCancelAction().cancelSearch();
                FindPanel.this.setVisible(false);
            }
        }
    }

    private class FindPreviousAction
    extends AbstractAction {
        private static final long serialVersionUID = -8192948220602398223L;

        public FindPreviousAction() {
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/actions/go-up.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Find previous.");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("FIND_PREVIOUS_ACTION");
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            FindPanel.this.eventWrapperViewPanel.findPrevious();
        }
    }

    private class FindNextAction
    extends AbstractAction {
        private static final long serialVersionUID = -6469494975854597398L;

        public FindNextAction() {
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/actions/go-down.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Find next.");
            KeyStroke accelerator = LilithKeyStrokes.getKeyStroke("FIND_NEXT_ACTION");
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            FindPanel.this.eventWrapperViewPanel.findNext();
        }
    }

    private class FindTextFieldListener
    implements ActionListener,
    DocumentListener {
        private FindTextFieldListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String selectedType;
            JTextComponent findEditorComponent;
            FindPanel.this.updateCondition();
            if (FindPanel.this.logger.isDebugEnabled()) {
                FindPanel.this.logger.debug("modifiers: " + e.getModifiers());
            }
            if ((findEditorComponent = FindPanel.this.getFindEditorComponent()) != null) {
                findEditorComponent.selectAll();
            }
            if (!"Level>=".equals(selectedType = (String)FindPanel.this.findTypeCombo.getSelectedItem()) && !"Saved".equals(selectedType) && FindPanel.this.condition instanceof SearchStringCondition) {
                FindPanel.this.mainFrame.getApplicationPreferences().addPreviousSearchString(((SearchStringCondition)FindPanel.this.condition).getSearchString());
            }
            FindPanel.this.eventWrapperViewPanel.createFilteredView();
        }

        public void insertUpdate(DocumentEvent e) {
            FindPanel.this.updateCondition();
        }

        public void removeUpdate(DocumentEvent e) {
            FindPanel.this.updateCondition();
        }

        public void changedUpdate(DocumentEvent e) {
            FindPanel.this.updateCondition();
        }
    }

    class MyFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private final Logger logger = LoggerFactory.getLogger(MyFocusTraversalPolicy.class);

        MyFocusTraversalPolicy() {
        }

        private Component resolveComponent(Component component) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (container == FindPanel.this.findTypeCombo) {
                    return FindPanel.this.findTypeCombo;
                }
                if (container != FindPanel.this.findTextCombo) continue;
                return FindPanel.this.findTextCombo;
            }
            return null;
        }

        public Component getComponentAfter(Container aContainer, Component aComponent) {
            if (aComponent.equals(FindPanel.this.closeFindButton)) {
                return FindPanel.this.findNotButton;
            }
            if (aComponent.equals(FindPanel.this.findNotButton)) {
                return FindPanel.this.findTypeCombo;
            }
            if (aComponent.equals(FindPanel.this.findTypeCombo)) {
                return FindPanel.this.findTextCombo;
            }
            if (aComponent.equals(FindPanel.this.findTextCombo)) {
                return FindPanel.this.findPrevButton;
            }
            if (aComponent.equals(FindPanel.this.findPrevButton)) {
                return FindPanel.this.findNextButton;
            }
            if (aComponent.equals(FindPanel.this.findNextButton)) {
                return FindPanel.this.closeFindButton;
            }
            Component c = this.resolveComponent(aComponent);
            if (FindPanel.this.findTypeCombo.equals(c)) {
                return FindPanel.this.findTextCombo;
            }
            if (FindPanel.this.findTextCombo.equals(c)) {
                return FindPanel.this.findPrevButton;
            }
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Moving focus forward was not explicitly handled.\ncontainer={}\ncomponent={}", (Object)aContainer, (Object)aComponent);
            }
            return null;
        }

        public Component getComponentBefore(Container aContainer, Component aComponent) {
            if (aComponent.equals(FindPanel.this.closeFindButton)) {
                return FindPanel.this.findNextButton;
            }
            if (aComponent.equals(FindPanel.this.findNotButton)) {
                return FindPanel.this.closeFindButton;
            }
            if (aComponent.equals(FindPanel.this.findTypeCombo)) {
                return FindPanel.this.findNotButton;
            }
            if (aComponent.equals(FindPanel.this.findTextCombo)) {
                return FindPanel.this.findTypeCombo;
            }
            if (aComponent.equals(FindPanel.this.findPrevButton)) {
                return FindPanel.this.findTextCombo;
            }
            if (aComponent.equals(FindPanel.this.findNextButton)) {
                return FindPanel.this.findPrevButton;
            }
            Component c = this.resolveComponent(aComponent);
            if (FindPanel.this.findTypeCombo.equals(c)) {
                return FindPanel.this.findNotButton;
            }
            if (FindPanel.this.findTextCombo.equals(c)) {
                return FindPanel.this.findTypeCombo;
            }
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Moving focus backward was not explicitly handled.\ncontainer={}\ncomponent={}", (Object)aContainer, (Object)aComponent);
            }
            return null;
        }

        public Component getFirstComponent(Container aContainer) {
            return FindPanel.this.closeFindButton;
        }

        public Component getLastComponent(Container aContainer) {
            return FindPanel.this.findNextButton;
        }

        public Component getDefaultComponent(Container aContainer) {
            return FindPanel.this.findTextCombo;
        }
    }
}

