/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.engine.EventSource;
import de.huxhorn.lilith.swing.FindPanel;
import de.huxhorn.lilith.swing.LoggingViewState;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.ProgressGlassPane;
import de.huxhorn.lilith.swing.RendererConstants;
import de.huxhorn.lilith.swing.ViewActions;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.ViewWindow;
import de.huxhorn.lilith.swing.callables.CallableMetaData;
import de.huxhorn.lilith.swing.callables.FindNextCallable;
import de.huxhorn.lilith.swing.callables.FindPreviousCallable;
import de.huxhorn.lilith.swing.linklistener.StackTraceElementLinkListener;
import de.huxhorn.lilith.swing.table.EventWrapperViewTable;
import de.huxhorn.lilith.swing.table.model.EventWrapperTableModel;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.buffers.DisposeOperation;
import de.huxhorn.sulky.buffers.Flush;
import de.huxhorn.sulky.buffers.FlushOperation;
import de.huxhorn.sulky.buffers.SoftReferenceCachingBuffer;
import de.huxhorn.sulky.buffers.filtering.FilteringBuffer;
import de.huxhorn.sulky.codec.filebuffer.CodecFileBuffer;
import de.huxhorn.sulky.conditions.And;
import de.huxhorn.sulky.conditions.Condition;
import de.huxhorn.sulky.formatting.HumanReadable;
import de.huxhorn.sulky.io.IOUtilities;
import de.huxhorn.sulky.swing.KeyStrokes;
import de.huxhorn.sulky.tasks.Task;
import de.huxhorn.sulky.tasks.TaskListener;
import de.huxhorn.sulky.tasks.TaskManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xhtmlrenderer.context.AWTFontResolver;
import org.xhtmlrenderer.extend.FontResolver;
import org.xhtmlrenderer.extend.NamespaceHandler;
import org.xhtmlrenderer.extend.TextRenderer;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.simple.FSScrollPane;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.simple.extend.XhtmlNamespaceHandler;
import org.xhtmlrenderer.swing.FSMouseListener;
import org.xhtmlrenderer.swing.LinkListener;
import org.xhtmlrenderer.swing.ScalableXHTMLPanel;
import org.xhtmlrenderer.swing.SelectionHighlighter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventWrapperViewPanel<T extends Serializable>
extends JPanel
implements DisposeOperation,
FlushOperation {
    private static final long serialVersionUID = 7987088820464790207L;
    private final Logger logger = LoggerFactory.getLogger(EventWrapperViewPanel.class);
    public static final String STATE_PROPERTY = "state";
    public static final String FILTER_CONDITION_PROPERTY = "filterCondition";
    public static final String EVENT_SOURCE_PROPERTY = "eventSource";
    public static final String SCROLLING_TO_BOTTOM_PROPERTY = "scrollingToBottom";
    public static final String PAUSED_PROPERTY = "paused";
    public static final String SELECTED_EVENT_PROPERTY = "selectedEvent";
    private EventSource<T> eventSource;
    private LoggingViewState state;
    private MainFrame mainFrame;
    private boolean showingFilters;
    private Condition filterCondition;
    private TaskManager<Long> taskManager;
    private EventWrapperViewTable<T> table;
    private EventWrapperTableModel<T> tableModel;
    private JLabel statusLabel;
    private JScrollBar verticalLogScrollbar;
    private StatusTableModelListener tableModelListener;
    private MatteBorder focusedBorder;
    private MatteBorder unfocusedBorder;
    private DecimalFormat eventCountFormat = new DecimalFormat("#,###");
    private FindResultListener findResultListener;
    private ScalableXHTMLPanel messagePane;
    private XhtmlNamespaceHandler xhtmlNamespaceHandler;
    private EventWrapper<T> selectedEvent;
    private SelectionHighlighter.CopyAction copyAction;
    private double scale;
    private JScrollPane tableScrollPane;
    private FindPanel<T> findPanel;
    private SoftReferenceCachingBuffer<EventWrapper<T>> cachedBuffer;

    public EventWrapperViewPanel(MainFrame mainFrame, EventSource<T> eventSource) {
        super(true);
        this.taskManager = mainFrame.getLongWorkManager();
        this.findResultListener = new FindResultListener();
        this.taskManager.addTaskListener((TaskListener)this.findResultListener);
        this.mainFrame = mainFrame;
        this.eventSource = eventSource;
        this.showingFilters = false;
        this.tableModelListener = new StatusTableModelListener();
        this.scale = mainFrame.getApplicationPreferences().getScaleFactor();
        this.initUi();
    }

    private void initUi() {
        Insets borderInsets = new Insets(2, 2, 2, 2);
        this.focusedBorder = new MatteBorder(borderInsets, Color.YELLOW);
        this.unfocusedBorder = new MatteBorder(borderInsets, Color.WHITE);
        this.cachedBuffer = this.createCachedBuffer(this.eventSource.getBuffer());
        this.tableModel = this.createTableModel((Buffer<EventWrapper<T>>)this.cachedBuffer);
        this.tableModel.addTableModelListener(this.tableModelListener);
        this.table = this.createTable(this.tableModel);
        this.table.getSelectionModel().addListSelectionListener(new TableRowSelectionListener());
        this.tableScrollPane = new JScrollPane(this.table);
        this.table.addMouseListener(new TableMouseListener());
        this.tableScrollPane.addMouseListener(new ScrollPaneMouseListener());
        this.tableScrollPane.setPreferredSize(new Dimension(400, 400));
        this.verticalLogScrollbar = this.tableScrollPane.getVerticalScrollBar();
        this.messagePane = new ScalableXHTMLPanel();
        SharedContext sharedContext = this.messagePane.getSharedContext();
        TextRenderer textRenderer = sharedContext.getTextRenderer();
        textRenderer.setSmoothingThreshold(6.0f);
        FontResolver fontResolver = sharedContext.getFontResolver();
        if (fontResolver instanceof AWTFontResolver && RendererConstants.MENSCH_FONT != null) {
            AWTFontResolver awtFontResolver = (AWTFontResolver)fontResolver;
            awtFontResolver.setFontMapping("Monospaced", RendererConstants.MENSCH_FONT);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Installed '{}' font.", (Object)"Monospaced");
            }
        }
        this.messagePane.setScale(this.mainFrame.getApplicationPreferences().getScaleFactor());
        SelectionHighlighter messagePaneCaret = new SelectionHighlighter();
        messagePaneCaret.install((XHTMLPanel)this.messagePane);
        this.copyAction = new SelectionHighlighter.CopyAction();
        this.copyAction.install(messagePaneCaret);
        this.messagePane.addMouseListener((MouseListener)new EventViewMouseListener());
        this.messagePane.addFocusListener((FocusListener)new MessageFocusListener());
        this.messagePane.setBorder((Border)this.unfocusedBorder);
        List mouseTrackingList = this.messagePane.getMouseTrackingListeners();
        if (mouseTrackingList != null) {
            for (Object o : mouseTrackingList) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Before MTL {}", o);
                }
                if (!(o instanceof LinkListener)) continue;
                this.messagePane.removeMouseTrackingListener((FSMouseListener)((LinkListener)o));
            }
        }
        this.messagePane.addMouseTrackingListener((FSMouseListener)new StackTraceElementLinkListener(this.mainFrame));
        this.xhtmlNamespaceHandler = new XhtmlNamespaceHandler();
        FSScrollPane messageScrollPane = new FSScrollPane((JPanel)this.messagePane);
        messageScrollPane.setPreferredSize(new Dimension(400, 400));
        MouseWheelListener[] mwl = messageScrollPane.getMouseWheelListeners();
        if (mwl != null) {
            for (MouseWheelListener current : mwl) {
                messageScrollPane.removeMouseWheelListener(current);
            }
        }
        messageScrollPane.addMouseWheelListener((MouseWheelListener)new WrappingMouseWheelListener(mwl));
        JSplitPane splitPane = new JSplitPane(0, this.tableScrollPane, (Component)messageScrollPane);
        SplitPaneListener splitPaneListener = new SplitPaneListener();
        splitPane.addPropertyChangeListener(splitPaneListener);
        splitPane.setResizeWeight(0.5);
        splitPane.setOneTouchExpandable(true);
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
        ScrollbarChangeListner scrollBarChangeListener = new ScrollbarChangeListner();
        this.verticalLogScrollbar.getModel().addChangeListener(scrollBarChangeListener);
        this.table.addPropertyChangeListener(new EventWrapperViewChangeListener());
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JPanel statusPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.findPanel = new FindPanel(this);
        this.findPanel.addPropertyChangeListener(new FindPanelChangeListener());
        bottomPanel.add(this.findPanel, "Center");
        bottomPanel.add((Component)statusPanel, "South");
        this.statusLabel = new JLabel();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 5, 0, 0);
        statusPanel.add((Component)this.statusLabel, gbc);
        this.add((Component)bottomPanel, "South");
        this.setScrollingToBottom(false);
        this.setPaused(false);
        MyFocusTraversalPolicy focusTraversalPolicy = new MyFocusTraversalPolicy();
        this.setFocusTraversalPolicy(focusTraversalPolicy);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicyProvider(true);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("table.isFocusCycleRoot()={}", (Object)this.table.isFocusCycleRoot());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("table.isFocusTraversalPolicyProvider()={}", (Object)this.table.isFocusTraversalPolicyProvider());
        }
        this.table.setFocusTraversalPolicy(focusTraversalPolicy);
        this.table.setFocusCycleRoot(true);
        this.table.setFocusTraversalKeys(0, this.getFocusTraversalKeys(0));
        this.table.setFocusTraversalKeys(1, this.getFocusTraversalKeys(1));
        this.updateStatusText();
        splitPane.setDividerLocation(0.5);
        this.setShowingStatusBar(this.mainFrame.getApplicationPreferences().isShowingStatusbar());
    }

    public EventWrapperViewTable<T> getTable() {
        return this.table;
    }

    public LoggingViewState getState() {
        if (!EventQueue.isDispatchThread() && this.logger.isWarnEnabled()) {
            this.logger.warn("!DispatchThread - getState: state=" + (Object)((Object)this.state), new Throwable());
        }
        return this.state;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public void setState(LoggingViewState state) {
        LoggingViewState oldValue = this.state;
        LoggingViewState newValue = this.state = state;
        this.firePropertyChange(STATE_PROPERTY, (Object)oldValue, (Object)newValue);
    }

    public boolean isShowingFilters() {
        return this.showingFilters;
    }

    public void setShowingFilters(boolean showingFilters) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ShowingFilters: {}", (Object)showingFilters);
        }
        this.showingFilters = showingFilters;
        if (showingFilters) {
            this.findPanel.updateUi();
        }
        this.findPanel.setVisible(showingFilters);
        if (showingFilters) {
            this.findPanel.requestComboFocus();
            this.applyFilter();
        }
        this.scrollToEvent();
    }

    public void scrollToEvent() {
        if (this.table.isScrollingToBottom()) {
            SwingUtilities.invokeLater(new ScrollToBottomRunnable());
        } else if (this.table.getSelectedRow() < 0) {
            SwingUtilities.invokeLater(new SelectFirstEventRunnable());
        }
    }

    public void setScaleFactor(double scale) {
        this.scale = scale;
        this.messagePane.setScale(scale);
    }

    public void updateView() {
        EventWrapper<T> selected = this.getSelectedEvent();
        if (selected != null) {
            this.initMessage(selected);
        } else {
            this.resetMessage();
        }
    }

    public void setShowingStatusBar(boolean showingStatusbar) {
        this.statusLabel.setVisible(showingStatusbar);
    }

    public void setPreviousSearchStrings(List<String> previousSearchStrings) {
        this.findPanel.setPreviousSearchStrings(previousSearchStrings);
    }

    public void setConditionNames(List<String> conditionNames) {
        this.findPanel.setConditionNames(conditionNames);
    }

    @Override
    public void validate() {
        super.validate();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Validate");
        }
    }

    private SoftReferenceCachingBuffer<EventWrapper<T>> createCachedBuffer(Buffer<EventWrapper<T>> buffer) {
        return new SoftReferenceCachingBuffer(buffer);
    }

    void setEventSource(EventSource<T> eventSource) {
        EventSource<T> oldValue = this.eventSource;
        this.eventSource = eventSource;
        SoftReferenceCachingBuffer<EventWrapper<T>> cachedBuffer = this.createCachedBuffer(eventSource.getBuffer());
        this.tableModel.setBuffer((Buffer)cachedBuffer);
        EventSource<T> newValue = this.eventSource;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("EventSource\nOld: {}\nNew: {}", oldValue, newValue);
        }
        this.firePropertyChange(EVENT_SOURCE_PROPERTY, oldValue, newValue);
    }

    public EventSource<T> getEventSource() {
        return this.eventSource;
    }

    public void setScrollingToBottom(boolean scrollingToBottom) {
        Boolean oldValue = this.table.isScrollingToBottom();
        this.table.setScrollingToBottom(scrollingToBottom);
        Boolean newValue = this.table.isScrollingToBottom();
        this.firePropertyChange(SCROLLING_TO_BOTTOM_PROPERTY, oldValue, newValue);
    }

    public boolean isScrollingToBottom() {
        return this.table.isScrollingToBottom();
    }

    public boolean isPaused() {
        return this.tableModel.isPaused();
    }

    public void setPaused(boolean paused) {
        Boolean oldValue = this.tableModel.isPaused();
        this.tableModel.setPaused(paused);
        Boolean newValue = this.tableModel.isPaused();
        this.firePropertyChange(PAUSED_PROPERTY, oldValue, newValue);
    }

    public ViewContainer<T> resolveContainer() {
        Container parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof ViewContainer); parent = parent.getParent()) {
        }
        return (ViewContainer)parent;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("addNotify - parent: {}", (Object)this.getParent());
        }
        this.findPanel.setVisible(this.isShowingFilters());
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("removeNotify");
        }
    }

    protected abstract EventWrapperTableModel<T> createTableModel(Buffer<EventWrapper<T>> var1);

    protected abstract EventWrapperViewTable<T> createTable(EventWrapperTableModel<T> var1);

    public void dispose() {
        this.tableModel.dispose();
        this.taskManager.removeTaskListener((TaskListener)this.findResultListener);
    }

    public void flush() {
        Flush.flush(this.cachedBuffer);
        this.resetFind();
    }

    public boolean isDisposed() {
        return this.tableModel.isDisposed();
    }

    public void resetFind() {
        this.findPanel.resetFind();
        this.setFilterCondition(null);
    }

    protected void setSelectedEvent(EventWrapper<T> selectedEvent) {
        EventWrapper<T> oldValue = this.selectedEvent;
        EventWrapper<T> newValue = this.selectedEvent = selectedEvent;
        this.firePropertyChange(SELECTED_EVENT_PROPERTY, oldValue, newValue);
    }

    public EventWrapper<T> getSelectedEvent() {
        return this.selectedEvent;
    }

    public EventWrapperTableModel<T> getTableModel() {
        return this.tableModel;
    }

    protected void initMessage(EventWrapper wrapper) {
        String message = this.mainFrame.createMessage(wrapper);
        URL messageViewRootUrl = this.mainFrame.getApplicationPreferences().getDetailsViewRootUrl();
        try {
            this.messagePane.setDocumentFromString(message, messageViewRootUrl.toExternalForm(), (NamespaceHandler)this.xhtmlNamespaceHandler);
            this.messagePane.setScale(this.scale);
        }
        catch (Throwable t) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while setting message {}!", (Object)message, (Object)t);
            }
            this.writeErrorMessage(message);
        }
    }

    protected void resetMessage() {
        String message = "<html><body>No event selected.</body></html>";
        URL messageViewRootUrl = this.mainFrame.getApplicationPreferences().getDetailsViewRootUrl();
        try {
            this.messagePane.setDocumentFromString(message, messageViewRootUrl.toExternalForm(), (NamespaceHandler)this.xhtmlNamespaceHandler);
            this.messagePane.setScale(this.scale);
        }
        catch (Throwable t) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while setting message!", t);
            }
            this.writeErrorMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeErrorMessage(String message) {
        FileOutputStream fos;
        block5: {
            File appPath = this.mainFrame.getApplicationPreferences().getStartupApplicationPath();
            File errorPath = new File(appPath, "errors");
            if (errorPath.mkdirs() && this.logger.isDebugEnabled()) {
                this.logger.debug("Created errors directory '{}'.", (Object)errorPath);
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd'T'HHmmssSSSZ");
            String filename = format.format(new Date());
            File errorFile = new File(errorPath, filename);
            fos = null;
            try {
                fos = new FileOutputStream(errorFile);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                osw.append(message);
                osw.flush();
                if (!this.logger.isInfoEnabled()) break block5;
                this.logger.info("Faulty message written to '{}'.", (Object)errorFile.getAbsolutePath());
            }
            catch (Throwable e) {
                block6: {
                    try {
                        if (!this.logger.isWarnEnabled()) break block6;
                        this.logger.warn("Exception while writing faulty message to '" + errorFile.getAbsolutePath() + "'!", e);
                    }
                    catch (Throwable throwable) {
                        IOUtilities.closeQuietly(fos);
                        throw throwable;
                    }
                }
                IOUtilities.closeQuietly((OutputStream)fos);
            }
        }
        IOUtilities.closeQuietly((OutputStream)fos);
    }

    private EventWrapper<T> getEventWrapper(Point p) {
        int row = this.table.rowAtPoint(p);
        if (-1 == row) {
            return null;
        }
        this.table.setScrollingToBottom(false);
        this.table.selectRow(row);
        return (EventWrapper)this.tableModel.getValueAt(row);
    }

    private void applyFilter() {
        Condition condition = this.findPanel.getCondition();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Setting condition: {}", (Object)condition);
        }
        this.setFilterCondition(condition);
    }

    public void setFilterCondition(Condition condition) {
        Condition old = this.filterCondition;
        this.filterCondition = condition;
        this.table.setFilterCondition(this.filterCondition);
        this.firePropertyChange(FILTER_CONDITION_PROPERTY, old, condition);
    }

    public Condition getFilterCondition() {
        return this.filterCondition;
    }

    public void clear() {
        this.tableModel.clear();
        this.table.requestFocusInWindow();
    }

    public void findPrevious() {
        this.findPrevious(this.getSelectedRow(), this.getFilterCondition());
    }

    public void findPrevious(int currentRow, Condition condition) {
        if (condition != null) {
            FindPreviousCallable callable = new FindPreviousCallable(this, currentRow, condition);
            this.executeFind((Callable<Long>)((Object)callable), "Find previous", currentRow, condition);
        }
    }

    public void findNext() {
        this.findNext(this.getSelectedRow(), this.getFilterCondition());
    }

    public void findNext(int currentRow, Condition condition) {
        if (condition != null) {
            FindNextCallable callable = new FindNextCallable(this, currentRow, condition);
            this.executeFind((Callable<Long>)((Object)callable), "Find next", currentRow, condition);
        }
    }

    public void setSelectedRow(int row) {
        if (row > -1) {
            if (this.isScrollingToBottom()) {
                this.setScrollingToBottom(false);
            }
            this.table.selectRow(row);
        }
    }

    public int getSelectedRow() {
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        return selectionModel.getLeadSelectionIndex();
    }

    private void updateStatusText() {
        int eventCount = this.tableModel.getRowCount();
        StringBuilder statusText = new StringBuilder();
        if (eventCount < 1) {
            statusText.append("No events.");
        } else {
            if (eventCount == 1) {
                statusText.append("One event.");
            } else {
                statusText.append(this.eventCountFormat.format(eventCount)).append(" events.");
            }
            long size = this.getSizeOnDisk();
            if (size > 0L) {
                statusText.append("   Size on disk: ").append(HumanReadable.getHumanReadableSize((long)size, (boolean)true, (boolean)false)).append("bytes");
                statusText.append("   Average event: ").append(HumanReadable.getHumanReadableSize((long)(size / (long)eventCount), (boolean)true, (boolean)false)).append("bytes");
            }
        }
        this.statusLabel.setText(statusText.toString());
    }

    protected long getSizeOnDisk() {
        Buffer buffer = this.getEventSource().getBuffer();
        if (buffer instanceof CodecFileBuffer) {
            CodecFileBuffer cfb = (CodecFileBuffer)buffer;
            return cfb.getDataFile().length();
        }
        return -1L;
    }

    public Buffer<EventWrapper<T>> getSourceBuffer() {
        Buffer buffer = this.eventSource.getBuffer();
        if (buffer instanceof FilteringBuffer) {
            FilteringBuffer filteringBuffer = (FilteringBuffer)buffer;
            return filteringBuffer.getSourceBuffer();
        }
        return buffer;
    }

    public Condition getBufferCondition() {
        Buffer buffer = this.eventSource.getBuffer();
        if (buffer instanceof FilteringBuffer) {
            FilteringBuffer filteringBuffer = (FilteringBuffer)buffer;
            return filteringBuffer.getCondition();
        }
        return null;
    }

    public void copySelection() {
        this.copyAction.actionPerformed(null);
    }

    public Condition getCombinedCondition(Condition condition) {
        Condition previousCondition = this.getBufferCondition();
        if (previousCondition == null) {
            return condition;
        }
        try {
            ArrayList<Condition> conditions;
            And and;
            Condition previousClone = previousCondition.clone();
            if (condition == null) {
                return previousClone;
            }
            if (previousClone instanceof And) {
                and = (And)previousClone;
            } else {
                and = new And();
                conditions = new ArrayList<Condition>();
                conditions.add(previousClone);
                and.setConditions(conditions);
            }
            conditions = and.getConditions();
            if (conditions == null) {
                conditions = new ArrayList();
            }
            if (!conditions.contains(condition)) {
                conditions.add(condition);
            }
            if (conditions.size() > 1) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Setting and-conditions: {}", conditions);
                }
                and.setConditions(conditions);
                return and;
            }
            return condition;
        }
        catch (CloneNotSupportedException ex) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while cloning {}!", (Object)previousCondition, (Object)ex);
            }
            return null;
        }
    }

    void createFilteredView() {
        ViewContainer<T> container = this.resolveContainer();
        if (container == null) {
            return;
        }
        Condition condition = this.resolveCombinedCondition();
        if (condition == null) {
            return;
        }
        container.addFilteredView(this, condition);
    }

    public void showUnfilteredEvent() {
        Buffer buffer;
        ViewContainer<T> container;
        int row = this.getSelectedRow();
        if (row >= 0 && (container = this.resolveContainer()) != null && (buffer = this.eventSource.getBuffer()) instanceof FilteringBuffer) {
            FilteringBuffer filteringBuffer = (FilteringBuffer)buffer;
            long unfilteredRow = filteringBuffer.getSourceIndex((long)row);
            if (unfilteredRow >= 0L) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Show unfiltered event {} for filtered event {}...", (Object)unfilteredRow, (Object)row);
                }
                EventWrapperViewPanel<T> defaultView = container.getDefaultView();
                container.showDefaultView();
                defaultView.setSelectedRow((int)unfilteredRow);
            } else if (this.logger.isWarnEnabled()) {
                this.logger.info("Can't show unfiltered event {} for filtered event {}...", (Object)unfilteredRow, (Object)row);
            }
        }
    }

    private void showPopup(Component component, Point p) {
        ViewContainer<T> container = this.resolveContainer();
        if (container != null) {
            ViewWindow viewWindow = container.resolveViewWindow();
            if (viewWindow != null) {
                ViewActions viewActions = viewWindow.getViewActions();
                JPopupMenu popup = viewActions.getPopupMenu();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Show popup at {}.", (Object)p);
                }
                popup.show(component, p.x, p.y);
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn("Couldn't resolve viewWindow of viewContainer {}!", container);
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("Couldn't resolve viewContainer of viewPanel {}!", (Object)this);
        }
    }

    public void focusTable() {
        this.table.requestFocusInWindow();
    }

    public void focusMessagePane() {
        this.messagePane.requestFocusInWindow();
    }

    private void executeFind(Callable<Long> callable, String name, int currentRow, Condition condition) {
        ViewContainer<T> container = this.resolveContainer();
        if (container != null && container.isSearching()) {
            return;
        }
        Map<String, String> metaData = CallableMetaData.createFindMetaData(condition, this.eventSource, currentRow);
        String description = "Executing '" + name + "'  on " + metaData.get("SourceIdentifier") + " starting at row " + currentRow + ".\n\n" + metaData.get("Condition");
        this.findPanel.enableFindComponents(false, condition);
        this.findResultListener.setCallable(callable);
        Task task = this.taskManager.startTask(callable, name, description, metaData);
        if (container != null) {
            container.showSearchPanel((Task<Long>)task);
        }
    }

    protected abstract void closeConnection(SourceIdentifier var1);

    public Condition resolveCombinedCondition() {
        Condition currentFilter = this.getTable().getFilterCondition();
        if (currentFilter == null) {
            return null;
        }
        Condition originalBufferCondition = this.getBufferCondition();
        Condition filter = this.getCombinedCondition(currentFilter);
        if (filter == null || filter.equals(originalBufferCondition)) {
            return null;
        }
        return filter;
    }

    private class WrappingMouseWheelListener
    implements MouseWheelListener {
        private MouseWheelListener[] wrapped;

        private WrappingMouseWheelListener(MouseWheelListener[] wrapped) {
            this.wrapped = wrapped;
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            block5: {
                block4: {
                    if (e.getModifiers() != KeyStrokes.COMMAND_KEYMASK) break block4;
                    int rotation = e.getWheelRotation();
                    boolean up = false;
                    if (rotation < 0) {
                        up = true;
                        rotation = -rotation;
                    }
                    for (int i = 0; i < rotation; ++i) {
                        if (up) {
                            EventWrapperViewPanel.this.mainFrame.zoomIn();
                            continue;
                        }
                        EventWrapperViewPanel.this.mainFrame.zoomOut();
                    }
                    break block5;
                }
                if (this.wrapped == null) break block5;
                for (MouseWheelListener current : this.wrapped) {
                    current.mouseWheelMoved(e);
                }
            }
        }
    }

    private class MessageFocusListener
    implements FocusListener {
        private MessageFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            EventWrapperViewPanel.this.messagePane.setBorder((Border)EventWrapperViewPanel.this.focusedBorder);
        }

        public void focusLost(FocusEvent e) {
            EventWrapperViewPanel.this.messagePane.setBorder((Border)EventWrapperViewPanel.this.unfocusedBorder);
        }
    }

    private class SplitPaneListener
    implements PropertyChangeListener {
        private SplitPaneListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName;
            if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                EventWrapperViewPanel.this.logger.debug("Splitpane change!");
            }
            if ("dividerLocation".equals(propertyName = evt.getPropertyName())) {
                EventWrapperViewPanel.this.scrollToEvent();
            }
        }
    }

    private class StatusTableModelListener
    implements TableModelListener {
        private StatusTableModelListener() {
        }

        public void tableChanged(TableModelEvent e) {
            if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                EventWrapperViewPanel.this.logger.debug("TableModelEvent: {}", (Object)e);
            }
            EventWrapperViewPanel.this.updateStatusText();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FindResultListener
    implements TaskListener<Long> {
        private Callable<Long> callable;

        private FindResultListener() {
        }

        public void taskCreated(Task<Long> longTask) {
        }

        public void executionFailed(Task<Long> task, ExecutionException exception) {
            if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                EventWrapperViewPanel.this.logger.debug("in executionFailed:\n     task: {}\nthis.callable: {}", task, this.callable);
            }
            if (this.callable == task.getCallable()) {
                if (EventWrapperViewPanel.this.logger.isInfoEnabled()) {
                    EventWrapperViewPanel.this.logger.info("Find execution failed!", (Throwable)exception);
                }
                this.finished();
            }
        }

        public void executionFinished(Task<Long> task, Long result) {
            if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                EventWrapperViewPanel.this.logger.debug("in executionFinished:\n     task: {}\nthis.callable: {}", task, this.callable);
            }
            if (this.callable == task.getCallable()) {
                if (EventWrapperViewPanel.this.logger.isInfoEnabled()) {
                    EventWrapperViewPanel.this.logger.info("Find execution finished: {}!", (Object)result);
                }
                if (result != null && result >= 0L) {
                    int row = result.intValue();
                    EventWrapperViewPanel.this.setSelectedRow(row);
                }
                this.finished();
            }
        }

        public void executionCanceled(Task<Long> task) {
            if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                EventWrapperViewPanel.this.logger.debug("in executionCanceled:\n     task: {}\nthis.callable: {}", task, this.callable);
            }
            if (this.callable == task.getCallable()) {
                if (EventWrapperViewPanel.this.logger.isInfoEnabled()) {
                    EventWrapperViewPanel.this.logger.info("Find execution canceled.");
                }
                this.finished();
            }
        }

        public void progressUpdated(Task<Long> task, int progress) {
            if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                EventWrapperViewPanel.this.logger.debug("in progressUpdated:\task: {}\n   this.callable: {}", task, this.callable);
            }
            if (this.callable == task.getCallable()) {
                ViewContainer container;
                if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                    EventWrapperViewPanel.this.logger.debug("Progress update: {}", (Object)progress);
                }
                if ((container = EventWrapperViewPanel.this.resolveContainer()) != null) {
                    ProgressGlassPane progressPanel = container.getProgressPanel();
                    progressPanel.setProgress(progress);
                }
            }
        }

        private void finished() {
            ViewContainer container;
            if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                EventWrapperViewPanel.this.logger.debug("Executing FindResultListener.finished().");
            }
            if ((container = EventWrapperViewPanel.this.resolveContainer()) != null) {
                ProgressGlassPane progressPanel = container.getProgressPanel();
                progressPanel.getFindCancelAction().setTask(null);
                this.setCallable(null);
                container.hideSearchPanel();
            }
            EventWrapperViewPanel.this.findPanel.enableFindComponents(true, EventWrapperViewPanel.this.table.getFilterCondition());
        }

        public void setCallable(Callable<Long> callable) {
            if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                EventWrapperViewPanel.this.logger.debug("Setting task...\n     newCallable: " + callable + "\npreviousCallable: " + this.callable, new Throwable());
            }
            this.callable = callable;
        }
    }

    class FindPanelChangeListener
    implements PropertyChangeListener {
        final Logger logger = LoggerFactory.getLogger(FindPanelChangeListener.class);

        FindPanelChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            String propertyName = event.getPropertyName();
            if ("condition".equals(propertyName)) {
                EventWrapperViewPanel.this.applyFilter();
            }
        }
    }

    class EventWrapperViewChangeListener
    implements PropertyChangeListener {
        final Logger logger = LoggerFactory.getLogger(EventWrapperViewChangeListener.class);

        EventWrapperViewChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            String propertyName = event.getPropertyName();
            if (EventWrapperViewPanel.SCROLLING_TO_BOTTOM_PROPERTY.equals(propertyName)) {
                Object oldValue = event.getOldValue();
                Object newValue = event.getNewValue();
                EventWrapperViewPanel.this.firePropertyChange(EventWrapperViewPanel.SCROLLING_TO_BOTTOM_PROPERTY, oldValue, newValue);
            }
        }
    }

    private class ScrollbarChangeListner
    implements ChangeListener {
        private final Logger logger = LoggerFactory.getLogger(ScrollbarChangeListner.class);

        private ScrollbarChangeListner() {
        }

        public void stateChanged(ChangeEvent evt) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("changeEvent: {}", (Object)evt);
            }
            if (EventWrapperViewPanel.this.isScrollingToBottom() && EventWrapperViewPanel.this.verticalLogScrollbar.getModel().getValueIsAdjusting()) {
                EventWrapperViewPanel.this.setScrollingToBottom(false);
            }
        }
    }

    private class TableRowSelectionListener
    implements ListSelectionListener {
        private final Logger logger = LoggerFactory.getLogger(TableRowSelectionListener.class);

        private TableRowSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            int row = EventWrapperViewPanel.this.getSelectedRow();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Selected row: {}.", (Object)row);
            }
            if (row >= 0) {
                EventWrapper event = (EventWrapper)EventWrapperViewPanel.this.tableModel.getValueAt(row);
                EventWrapperViewPanel.this.setSelectedEvent(event);
                EventWrapperViewPanel.this.initMessage(event);
            } else {
                EventWrapperViewPanel.this.setSelectedEvent(null);
                EventWrapperViewPanel.this.resetMessage();
            }
        }
    }

    private class ScrollPaneMouseListener
    implements MouseListener {
        private void showPopup(MouseEvent evt) {
            Point p = evt.getPoint();
            EventWrapperViewPanel.this.showPopup(EventWrapperViewPanel.this.tableScrollPane, p);
        }

        public void mouseClicked(MouseEvent evt) {
            EventWrapperViewPanel.this.tableScrollPane.requestFocusInWindow();
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mousePressed(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mouseReleased(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    private class EventViewMouseListener
    implements MouseListener {
        private void showPopup(MouseEvent evt) {
            Point p = evt.getPoint();
            EventWrapperViewPanel.this.showPopup((Component)EventWrapperViewPanel.this.messagePane, p);
        }

        public void mouseClicked(MouseEvent evt) {
            EventWrapperViewPanel.this.messagePane.requestFocusInWindow();
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mousePressed(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mouseReleased(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    private class TableMouseListener
    implements MouseListener {
        public void mouseClicked(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            } else if (evt.getClickCount() > 1 && evt.getButton() == 1) {
                if ((evt.getModifiersEx() & 0x40) != 0) {
                    LoggingEvent loggingEvent;
                    ExtendedStackTraceElement[] callStack;
                    Serializable event;
                    Point p = evt.getPoint();
                    EventWrapper wrapper = EventWrapperViewPanel.this.getEventWrapper(p);
                    if (wrapper != null && (event = wrapper.getEvent()) instanceof LoggingEvent && (callStack = (loggingEvent = (LoggingEvent)event).getCallStack()) != null && callStack.length > 0) {
                        EventWrapperViewPanel.this.mainFrame.goToSource(callStack[0].getStackTraceElement());
                    }
                } else {
                    Point p = evt.getPoint();
                    EventWrapper wrapper = EventWrapperViewPanel.this.getEventWrapper(p);
                    if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                        EventWrapperViewPanel.this.logger.debug("Show unfiltered event {}.", (Object)wrapper);
                    }
                    EventWrapperViewPanel.this.showUnfilteredEvent();
                }
            }
        }

        private void showPopup(MouseEvent evt) {
            Point p = evt.getPoint();
            EventWrapper wrapper = EventWrapperViewPanel.this.getEventWrapper(p);
            if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                EventWrapperViewPanel.this.logger.debug("Show popup at {} for event {}.", (Object)p, (Object)wrapper);
            }
            EventWrapperViewPanel.this.showPopup(EventWrapperViewPanel.this.table, p);
        }

        public void mousePressed(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mouseReleased(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    class MyFocusTraversalPolicy
    extends FocusTraversalPolicy {
        MyFocusTraversalPolicy() {
        }

        private Component resolveComponent(Component component) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (container == EventWrapperViewPanel.this.table) {
                    return EventWrapperViewPanel.this.table;
                }
                if (container != EventWrapperViewPanel.this.messagePane) continue;
                return EventWrapperViewPanel.this.messagePane;
            }
            return null;
        }

        public Component getComponentAfter(Container aContainer, Component aComponent) {
            if (aComponent.equals(EventWrapperViewPanel.this.table)) {
                return EventWrapperViewPanel.this.messagePane;
            }
            if (aComponent.equals(EventWrapperViewPanel.this.messagePane)) {
                if (EventWrapperViewPanel.this.isShowingFilters()) {
                    if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                        EventWrapperViewPanel.this.logger.debug("Performing FocusTraversal-Voodoo...");
                    }
                    FocusTraversalPolicy policy = EventWrapperViewPanel.this.findPanel.getFocusTraversalPolicy();
                    return policy.getDefaultComponent(aContainer);
                }
                return EventWrapperViewPanel.this.table;
            }
            if (aComponent.equals(EventWrapperViewPanel.this.findPanel)) {
                return EventWrapperViewPanel.this.table;
            }
            if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                EventWrapperViewPanel.this.logger.debug("Performing FocusTraversal-Yaddayadda...");
            }
            Component c = this.resolveComponent(aComponent);
            if (EventWrapperViewPanel.this.table.equals(c)) {
                return EventWrapperViewPanel.this.messagePane;
            }
            if (EventWrapperViewPanel.this.messagePane.equals(c)) {
                if (EventWrapperViewPanel.this.isShowingFilters()) {
                    return EventWrapperViewPanel.this.findPanel;
                }
                return EventWrapperViewPanel.this.table;
            }
            FocusTraversalPolicy policy = EventWrapperViewPanel.this.findPanel.getFocusTraversalPolicy();
            Component result = policy.getComponentAfter(aContainer, aComponent);
            if (result == policy.getFirstComponent(aContainer)) {
                return EventWrapperViewPanel.this.table;
            }
            if (result != null) {
                return result;
            }
            if (EventWrapperViewPanel.this.logger.isWarnEnabled()) {
                EventWrapperViewPanel.this.logger.warn("Moving focus forward was not explicitly handled.\ncontainer={}\ncomponent={}", (Object)aContainer, (Object)aComponent);
            }
            return null;
        }

        public Component getComponentBefore(Container aContainer, Component aComponent) {
            if (aComponent.equals(EventWrapperViewPanel.this.messagePane)) {
                return EventWrapperViewPanel.this.table;
            }
            if (aComponent.equals(EventWrapperViewPanel.this.findPanel)) {
                return EventWrapperViewPanel.this.messagePane;
            }
            if (aComponent.equals(EventWrapperViewPanel.this.table)) {
                if (EventWrapperViewPanel.this.isShowingFilters()) {
                    if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                        EventWrapperViewPanel.this.logger.debug("Performing FocusTraversal-Voodoo...");
                    }
                    FocusTraversalPolicy policy = EventWrapperViewPanel.this.findPanel.getFocusTraversalPolicy();
                    return policy.getDefaultComponent(aContainer);
                }
                return EventWrapperViewPanel.this.messagePane;
            }
            if (EventWrapperViewPanel.this.logger.isDebugEnabled()) {
                EventWrapperViewPanel.this.logger.debug("Performing FocusTraversal-Yaddayadda...");
            }
            Component c = this.resolveComponent(aComponent);
            if (EventWrapperViewPanel.this.table.equals(c)) {
                if (EventWrapperViewPanel.this.isShowingFilters()) {
                    return EventWrapperViewPanel.this.findPanel;
                }
                return EventWrapperViewPanel.this.messagePane;
            }
            if (EventWrapperViewPanel.this.messagePane.equals(c)) {
                return EventWrapperViewPanel.this.table;
            }
            FocusTraversalPolicy policy = EventWrapperViewPanel.this.findPanel.getFocusTraversalPolicy();
            Component result = policy.getComponentBefore(aContainer, aComponent);
            if (result == policy.getLastComponent(aContainer)) {
                return EventWrapperViewPanel.this.messagePane;
            }
            if (result != null) {
                return result;
            }
            if (EventWrapperViewPanel.this.logger.isWarnEnabled()) {
                EventWrapperViewPanel.this.logger.warn("Moving focus backward was not explicitly handled.\ncontainer={}\ncomponent={}", (Object)aContainer, (Object)aComponent);
            }
            return null;
        }

        public Component getFirstComponent(Container aContainer) {
            return EventWrapperViewPanel.this.table;
        }

        public Component getLastComponent(Container aContainer) {
            return EventWrapperViewPanel.this.messagePane;
        }

        public Component getDefaultComponent(Container aContainer) {
            return EventWrapperViewPanel.this.table;
        }
    }

    private class SelectFirstEventRunnable
    implements Runnable {
        private SelectFirstEventRunnable() {
        }

        public void run() {
            EventWrapperViewPanel.this.table.scrollToFirst();
        }
    }

    private class ScrollToBottomRunnable
    implements Runnable {
        private ScrollToBottomRunnable() {
        }

        public void run() {
            if (EventWrapperViewPanel.this.table.isScrollingToBottom()) {
                EventWrapperViewPanel.this.table.scrollToBottom();
            }
        }
    }
}

