/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.services.clipboard;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.ThrowableInfo;
import de.huxhorn.lilith.services.clipboard.ClipboardFormatter;
import java.io.Serializable;

public class LoggingThrowableFormatter
implements ClipboardFormatter {
    private static final long serialVersionUID = 830054294833389446L;

    public String getName() {
        return "Copy Throwable";
    }

    public String getDescription() {
        return "Copies the Throwable of the logging event to the clipboard.";
    }

    public String getAccelerator() {
        return "command shift alt T";
    }

    public boolean isCompatible(Object object) {
        Serializable eventObj;
        EventWrapper wrapper;
        if (object instanceof EventWrapper && (wrapper = (EventWrapper)object).getEvent() != null && (eventObj = wrapper.getEvent()) instanceof LoggingEvent) {
            LoggingEvent loggingEvent = (LoggingEvent)eventObj;
            return loggingEvent.getThrowable() != null;
        }
        return false;
    }

    public String toString(Object object) {
        LoggingEvent loggingEvent;
        ThrowableInfo info;
        Serializable eventObj;
        EventWrapper wrapper;
        if (object instanceof EventWrapper && (wrapper = (EventWrapper)object).getEvent() != null && (eventObj = wrapper.getEvent()) instanceof LoggingEvent && (info = (loggingEvent = (LoggingEvent)eventObj).getThrowable()) != null) {
            return info.toString();
        }
        return null;
    }
}

