/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.services.clipboard;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.Marker;
import de.huxhorn.lilith.services.clipboard.ClipboardFormatter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingMarkerFormatter
implements ClipboardFormatter {
    private static final long serialVersionUID = 8972697463195544172L;

    @Override
    public String getName() {
        return "Copy Marker";
    }

    @Override
    public String getDescription() {
        return "Copies the Marker hierarchy of the logging event to the clipboard.";
    }

    @Override
    public String getAccelerator() {
        return null;
    }

    @Override
    public boolean isCompatible(Object object) {
        Serializable eventObj;
        EventWrapper wrapper;
        if (object instanceof EventWrapper && (wrapper = (EventWrapper)object).getEvent() != null && (eventObj = wrapper.getEvent()) instanceof LoggingEvent) {
            LoggingEvent loggingEvent = (LoggingEvent)eventObj;
            return loggingEvent.getMarker() != null;
        }
        return false;
    }

    @Override
    public String toString(Object object) {
        LoggingEvent loggingEvent;
        Marker marker;
        Serializable eventObj;
        EventWrapper wrapper;
        if (object instanceof EventWrapper && (wrapper = (EventWrapper)object).getEvent() != null && (eventObj = wrapper.getEvent()) instanceof LoggingEvent && (marker = (loggingEvent = (LoggingEvent)eventObj).getMarker()) != null) {
            StringBuilder text = new StringBuilder();
            this.buildMarker(text, 0, marker, new ArrayList<String>());
            return text.toString();
        }
        return null;
    }

    private void buildMarker(StringBuilder text, int indent, Marker marker, List<String> handledMarkers) {
        if (marker != null) {
            for (int i = 0; i < indent; ++i) {
                text.append("  ");
            }
            String markerName = marker.getName();
            text.append("- ").append(markerName);
            if (handledMarkers.contains(markerName)) {
                text.append(" [..]\n");
            } else {
                text.append("\n");
                handledMarkers.add(markerName);
                Map references = marker.getReferences();
                if (references != null) {
                    for (Map.Entry current : references.entrySet()) {
                        this.buildMarker(text, indent + 1, (Marker)current.getValue(), handledMarkers);
                    }
                }
            }
        }
    }
}

