/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.services.clipboard;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.services.clipboard.ClipboardFormatter;
import java.io.Serializable;

public class LoggingCallStackFormatter
implements ClipboardFormatter {
    private static final long serialVersionUID = 861522045350829907L;

    public String getName() {
        return "Copy call stack";
    }

    public String getDescription() {
        return "Copies the call stack of the logging event to the clipboard.";
    }

    public String getAccelerator() {
        return null;
    }

    public boolean isCompatible(Object object) {
        Serializable eventObj;
        EventWrapper wrapper;
        if (object instanceof EventWrapper && (wrapper = (EventWrapper)object).getEvent() != null && (eventObj = wrapper.getEvent()) instanceof LoggingEvent) {
            LoggingEvent loggingEvent = (LoggingEvent)eventObj;
            ExtendedStackTraceElement[] callStack = loggingEvent.getCallStack();
            return callStack != null && callStack.length > 0;
        }
        return false;
    }

    public String toString(Object object) {
        LoggingEvent loggingEvent;
        ExtendedStackTraceElement[] callStack;
        Serializable eventObj;
        EventWrapper wrapper;
        if (object instanceof EventWrapper && (wrapper = (EventWrapper)object).getEvent() != null && (eventObj = wrapper.getEvent()) instanceof LoggingEvent && (callStack = (loggingEvent = (LoggingEvent)eventObj).getCallStack()) != null && callStack.length > 0) {
            StringBuilder text = new StringBuilder();
            boolean first = true;
            for (ExtendedStackTraceElement current : callStack) {
                if (first) {
                    first = false;
                } else {
                    text.append("\n");
                }
                text.append("\tat ").append(current.toString(true));
            }
            return text.toString();
        }
        return null;
    }
}

