/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.services.clipboard;

import de.huxhorn.lilith.services.clipboard.ClipboardFormatter;
import de.huxhorn.sulky.groovy.GroovyInstance;
import java.io.File;

public class GroovyFormatter
implements ClipboardFormatter {
    private GroovyInstance groovyInstance = new GroovyInstance();

    public GroovyFormatter() {
    }

    public GroovyFormatter(String fileName) {
        this();
        this.setGroovyFileName(fileName);
    }

    public void setGroovyFileName(String fileName) {
        this.groovyInstance.setGroovyFileName(fileName);
    }

    private ClipboardFormatter getFormatter() {
        return (ClipboardFormatter)this.groovyInstance.getInstanceAs(ClipboardFormatter.class);
    }

    public String getName() {
        ClipboardFormatter formatter = this.getFormatter();
        if (formatter != null) {
            return formatter.getName();
        }
        String fileName = this.groovyInstance.getGroovyFileName();
        if (fileName != null) {
            File file = new File(fileName);
            return file.getName();
        }
        return "Missing file!";
    }

    public String getDescription() {
        Class instanceClass;
        String errorMessage;
        ClipboardFormatter formatter = this.getFormatter();
        if (formatter != null) {
            return formatter.getDescription();
        }
        String fileName = this.groovyInstance.getGroovyFileName();
        String shortName = "Missing file!";
        if (fileName != null) {
            File file = new File(fileName);
            shortName = file.getName();
        }
        if ((errorMessage = this.groovyInstance.getErrorMessage()) == null && (instanceClass = this.groovyInstance.getInstanceClass()) != null) {
            return shortName + " - Expected ClipboardFormatter but received " + instanceClass.getName() + "!";
        }
        return shortName + " - " + errorMessage;
    }

    public String getAccelerator() {
        ClipboardFormatter formatter = this.getFormatter();
        return formatter == null ? null : formatter.getAccelerator();
    }

    public boolean isCompatible(Object object) {
        ClipboardFormatter formatter = this.getFormatter();
        return formatter != null && formatter.isCompatible(object);
    }

    public String toString(Object object) {
        ClipboardFormatter formatter = this.getFormatter();
        if (formatter == null) {
            return null;
        }
        return formatter.toString(object);
    }
}

