/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.eventhandlers;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.engine.EventHandler;
import de.huxhorn.sulky.sounds.Sounds;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlarmSoundLoggingEventHandler
implements EventHandler<LoggingEvent> {
    private Sounds sounds;

    public Sounds getSounds() {
        return this.sounds;
    }

    public void setSounds(Sounds sounds) {
        this.sounds = sounds;
    }

    public void handle(List<EventWrapper<LoggingEvent>> events) {
        if (this.sounds != null) {
            boolean errorDetected = false;
            boolean warnDetected = false;
            for (EventWrapper<LoggingEvent> current : events) {
                LoggingEvent event = (LoggingEvent)current.getEvent();
                if (event != null && LoggingEvent.Level.ERROR == event.getLevel()) {
                    errorDetected = true;
                }
                if (event == null || LoggingEvent.Level.WARN != event.getLevel()) continue;
                warnDetected = true;
            }
            if (warnDetected) {
                this.sounds.play("warnEventAlarm");
            }
            if (errorDetected) {
                this.sounds.play("errorEventAlarm");
            }
        }
    }
}

