/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.debug;

import de.huxhorn.lilith.debug.LogASCIIRunnable;
import de.huxhorn.lilith.debug.LogAnonymousRunnable;
import de.huxhorn.lilith.debug.LogDateRunnable;
import de.huxhorn.lilith.debug.LogNdcRunnable;
import de.huxhorn.lilith.debug.LogParamThrowableRunnable;
import de.huxhorn.lilith.debug.LogStuffRunnable;
import de.huxhorn.lilith.debug.LogStuffWithMdcRunnable;
import de.huxhorn.lilith.debug.LogThrowableRunnable;
import de.huxhorn.lilith.debug.LogTruthRunnable;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class LoggerEventEmitter {
    private final Logger logger = LoggerFactory.getLogger(LoggerEventEmitter.class);
    private static final int DEFAULT_DELAY = 50;
    private int delay = 50;
    private Marker marker = this.createMarker();
    private Marker fnordMarker = this.createFnordMarker();
    private ExecutorService executor = Executors.newCachedThreadPool();
    public static final Method ADD_SUPPRESSED_METHOD;

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void logStuff() {
        this.execute(new LogStuffRunnable(this.delay, null));
    }

    public void logNDC() {
        this.execute(new LogNdcRunnable(this.delay));
    }

    private void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    public void logStuffWithMdc() {
        this.execute(new LogStuffWithMdcRunnable(this.delay, null));
    }

    private Marker createMarker() {
        Marker marker = MarkerFactory.getMarker((String)"FooBar");
        Marker marker1 = MarkerFactory.getMarker((String)"Foo");
        Marker marker2 = MarkerFactory.getMarker((String)"Bar");
        Marker marker3 = MarkerFactory.getMarker((String)"Recursive");
        marker.add(marker1);
        marker.add(marker2);
        marker.add(marker3);
        marker3.add(marker);
        return marker;
    }

    private Marker createFnordMarker() {
        Marker eris = MarkerFactory.getMarker((String)"Hail Eris!!");
        Marker discordia = MarkerFactory.getMarker((String)"All Hail Discordia!!!");
        eris.add(discordia);
        return eris;
    }

    public void logStuffWithMdcAndMarker() {
        this.execute(new LogStuffWithMdcRunnable(this.delay, this.marker));
    }

    public void logStuffWithMarker() {
        this.execute(new LogStuffRunnable(this.delay, this.marker));
    }

    public void logException() {
        RuntimeException ex = new RuntimeException("Test-Exception");
        this.execute(new LogThrowableRunnable(this.delay, ex));
    }

    public void logException2() {
        RuntimeException causeCause = new RuntimeException("CauseCause-Exception", new RuntimeException("Inline CauseCauseCause-Exception"));
        RuntimeException cause = new RuntimeException("Cause-Exception", causeCause);
        RuntimeException ex = new RuntimeException("Another Test-Exception", cause);
        this.execute(new LogThrowableRunnable(this.delay, ex));
    }

    public void logExceptionSuppressed() {
        if (ADD_SUPPRESSED_METHOD != null) {
            RuntimeException cause;
            block3: {
                RuntimeException causeCause = new RuntimeException("Suppressed - CauseCause-Exception", new RuntimeException("Inline CauseCauseCause-Exception"));
                cause = new RuntimeException("Suppressed - Cause-Exception", causeCause);
                try {
                    ADD_SUPPRESSED_METHOD.invoke((Object)cause, new RuntimeException("Suppressed1"));
                    ADD_SUPPRESSED_METHOD.invoke((Object)cause, new RuntimeException("Suppressed2"));
                    ADD_SUPPRESSED_METHOD.invoke((Object)cause, new RuntimeException("Suppressed3"));
                }
                catch (Throwable e) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn("Exception while calling Throwable.addSuppressed!", e);
                }
            }
            RuntimeException ex = new RuntimeException("Suppressed - Root-Exception", cause);
            this.execute(new LogThrowableRunnable(this.delay, ex));
        }
    }

    public void logParamException() {
        RuntimeException ex = new RuntimeException("Test-Exception");
        this.execute(new LogParamThrowableRunnable(this.delay, ex));
    }

    public void logParamException2() {
        RuntimeException causeCause = new RuntimeException("CauseCause-Exception", new RuntimeException("Inline CauseCauseCause-Exception"));
        RuntimeException cause = new RuntimeException("Cause-Exception", causeCause);
        RuntimeException ex = new RuntimeException("Another Test-Exception", cause);
        this.execute(new LogParamThrowableRunnable(this.delay, ex));
    }

    public void logAnonymous() {
        this.execute(new LogAnonymousRunnable(this.delay));
    }

    public void logASCII() {
        this.execute(new LogASCIIRunnable(this.delay));
    }

    public void logTruth() {
        this.execute(new LogTruthRunnable(this.delay, this.fnordMarker, true));
        this.execute(new LogTruthRunnable(this.delay, this.fnordMarker, false));
    }

    public void logDate() {
        this.execute(new LogDateRunnable(this.delay));
    }

    static {
        Method method = null;
        try {
            method = Throwable.class.getMethod("addSuppressed", Throwable.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        ADD_SUPPRESSED_METHOD = method;
    }
}

