/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.debug;

import de.huxhorn.lilith.debug.DebugProgressingCallable;
import de.huxhorn.lilith.debug.LoggerEventEmitter;
import de.huxhorn.lilith.swing.MainFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.concurrent.Callable;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugDialog
extends JDialog {
    private final Logger logger = LoggerFactory.getLogger(DebugDialog.class);
    LoggerEventEmitter loggerEventEmitter;
    private MainFrame mainFrame;

    public DebugDialog(Frame owner, MainFrame mainFrame) {
        super(owner, "Debug");
        this.mainFrame = mainFrame;
        this.initUI();
    }

    public DebugDialog(Dialog owner) {
        super(owner, "Debug");
        this.initUI();
    }

    private void initUI() {
        this.setModal(false);
        this.loggerEventEmitter = new LoggerEventEmitter();
        this.loggerEventEmitter.setDelay(0);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(new JButton(new DoneAction()));
        JPanel loggingPanel = new JPanel(new GridBagLayout());
        loggingPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Create logging events"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.5;
        gbc.fill = 2;
        AbstractAction action = new LogStuffAction();
        JButton button = new JButton(action);
        gbc.gridx = 0;
        gbc.gridy = 0;
        loggingPanel.add((Component)button, gbc);
        action = new LogASCIIArtAction();
        button = new JButton(action);
        gbc.gridx = 1;
        gbc.gridy = 0;
        loggingPanel.add((Component)button, gbc);
        action = new LogExceptionsAction();
        button = new JButton(action);
        gbc.gridx = 0;
        gbc.gridy = 1;
        loggingPanel.add((Component)button, gbc);
        action = new LogParamExceptionsAction();
        button = new JButton(action);
        gbc.gridx = 1;
        gbc.gridy = 1;
        loggingPanel.add((Component)button, gbc);
        action = new LogTruthAction();
        button = new JButton(action);
        gbc.gridx = 0;
        gbc.gridy = 2;
        loggingPanel.add((Component)button, gbc);
        action = new LogAnonymousAction();
        button = new JButton(action);
        gbc.gridx = 1;
        gbc.gridy = 2;
        loggingPanel.add((Component)button, gbc);
        action = new LogNDCAction();
        button = new JButton(action);
        gbc.gridx = 0;
        gbc.gridy = 3;
        loggingPanel.add((Component)button, gbc);
        action = new LogDateAction();
        button = new JButton(action);
        gbc.gridx = 1;
        gbc.gridy = 3;
        loggingPanel.add((Component)button, gbc);
        action = new LogAllAction();
        button = new JButton(action);
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 4;
        loggingPanel.add((Component)button, gbc);
        JPanel miscPanel = new JPanel(new GridBagLayout());
        miscPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Miscellaneous"));
        action = new NetworkAction();
        button = new JButton(action);
        gbc.gridx = 0;
        gbc.gridy = 0;
        miscPanel.add((Component)button, gbc);
        action = new DebugCallableAction();
        button = new JButton(action);
        gbc.gridx = 0;
        gbc.gridy = 1;
        miscPanel.add((Component)button, gbc);
        action = new EditGroovyAction();
        button = new JButton(action);
        gbc.gridx = 0;
        gbc.gridy = 2;
        miscPanel.add((Component)button, gbc);
        action = new UncaughtExceptionAction();
        button = new JButton(action);
        gbc.gridx = 0;
        gbc.gridy = 3;
        miscPanel.add((Component)button, gbc);
        JPanel centerPanel = new JPanel(new GridBagLayout());
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        centerPanel.add((Component)loggingPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        centerPanel.add((Component)miscPanel, gbc);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)centerPanel, "Center");
        contentPane.add((Component)buttonPanel, "South");
    }

    private class UncaughtExceptionAction
    extends AbstractAction {
        private static final long serialVersionUID = -3600189121760822853L;

        public UncaughtExceptionAction() {
            super("Uncaught Exception");
            this.putValue("ShortDescription", "Throws an uncaught exception.");
        }

        public void actionPerformed(ActionEvent e) {
            throw new RuntimeException("Uncaught Exception!");
        }
    }

    private class EditGroovyAction
    extends AbstractAction {
        private static final long serialVersionUID = -8812061542734868784L;

        public EditGroovyAction() {
            super("Edit details view groovy!");
            this.putValue("ShortDescription", "Edit the details view Groovy file.");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.mainFrame.getPreferencesDialog().editDetailsFormatter();
        }
    }

    private class DebugCallableAction
    extends AbstractAction {
        private static final long serialVersionUID = -97047951966954750L;

        public DebugCallableAction() {
            super("Callable");
            this.putValue("ShortDescription", "Creates a callable that's simply counting up and adds it to the task-manager.");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.mainFrame.getLongWorkManager().startTask((Callable)((Object)new DebugProgressingCallable()), "Test Task", "This is just a simply test task.");
        }
    }

    private class NetworkAction
    extends AbstractAction {
        private static final long serialVersionUID = -3099597544720236257L;

        public NetworkAction() {
            super("Network");
            this.putValue("ShortDescription", "Detects all non-local network addresses and logs them to the internal Lilith log.");
        }

        public void actionPerformed(ActionEvent e) {
            HashSet<InetAddress> inetAddresses;
            block5: {
                inetAddresses = new HashSet<InetAddress>();
                try {
                    Enumeration<NetworkInterface> netIfcs = NetworkInterface.getNetworkInterfaces();
                    while (netIfcs.hasMoreElements()) {
                        NetworkInterface ni = netIfcs.nextElement();
                        Enumeration<InetAddress> inetAddrs = ni.getInetAddresses();
                        while (inetAddrs.hasMoreElements()) {
                            InetAddress iadd = inetAddrs.nextElement();
                            if (iadd.isLoopbackAddress()) continue;
                            inetAddresses.add(iadd);
                        }
                    }
                }
                catch (SocketException ex) {
                    if (!DebugDialog.this.logger.isWarnEnabled()) break block5;
                    DebugDialog.this.logger.warn("Exception while retrieving InetAddresses!", (Throwable)ex);
                }
            }
            if (DebugDialog.this.logger.isInfoEnabled()) {
                DebugDialog.this.logger.info("InetAddresses: {}", inetAddresses);
            }
        }
    }

    private class LogAllAction
    extends AbstractAction {
        private static final long serialVersionUID = -5004276984975201630L;

        public LogAllAction() {
            super("Log all!");
            this.putValue("ShortDescription", "Executes all of the above logging examples. May be NSFW depending on the closed-mindedness of your working environment...");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.loggerEventEmitter.logStuff();
            DebugDialog.this.loggerEventEmitter.logStuffWithMarker();
            DebugDialog.this.loggerEventEmitter.logStuffWithMdc();
            DebugDialog.this.loggerEventEmitter.logStuffWithMdcAndMarker();
            DebugDialog.this.loggerEventEmitter.logException();
            DebugDialog.this.loggerEventEmitter.logException2();
            DebugDialog.this.loggerEventEmitter.logExceptionSuppressed();
            DebugDialog.this.loggerEventEmitter.logParamException();
            DebugDialog.this.loggerEventEmitter.logParamException2();
            DebugDialog.this.loggerEventEmitter.logASCII();
            DebugDialog.this.loggerEventEmitter.logTruth();
            DebugDialog.this.loggerEventEmitter.logAnonymous();
            DebugDialog.this.loggerEventEmitter.logNDC();
            DebugDialog.this.loggerEventEmitter.logDate();
        }
    }

    private class LogDateAction
    extends AbstractAction {
        private static final long serialVersionUID = -1734237014776105342L;

        public LogDateAction() {
            super("Log date");
            this.putValue("ShortDescription", "Creates logging events containing a Date as an parameter. This will use Date.toString in case of Logback and ISO8601-format in case of MultiplexAppenders.");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.loggerEventEmitter.logDate();
        }
    }

    private class LogNDCAction
    extends AbstractAction {
        private static final long serialVersionUID = -518958063141973150L;

        public LogNDCAction() {
            super("Log NDC");
            this.putValue("ShortDescription", "Creates logging events containing NDC. This is not supported by Logback. The NDC will only show up in the MultiplexAppenders.");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.loggerEventEmitter.logNDC();
        }
    }

    private class LogAnonymousAction
    extends AbstractAction {
        private static final long serialVersionUID = -3343304084268635261L;

        public LogAnonymousAction() {
            super("Log anonymous");
            this.putValue("ShortDescription", "Creates logging events inside anonymous inner classes. Used to check if STE is handled correctly.");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.loggerEventEmitter.logAnonymous();
        }
    }

    private class LogTruthAction
    extends AbstractAction {
        private static final long serialVersionUID = -7354728704746203904L;

        public LogTruthAction() {
            super("Log truth");
            this.putValue("ShortDescription", "Creates logging events containing Discordian Truth.");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.loggerEventEmitter.logTruth();
        }
    }

    private class LogParamExceptionsAction
    extends AbstractAction {
        private static final long serialVersionUID = -7404752330757185806L;

        public LogParamExceptionsAction() {
            super("Log param exceptions");
            this.putValue("ShortDescription", "Creates logging events containing exceptions. Exceptions are given as a parameter which is not supported by Logback. The exceptions will only show up in the MultiplexAppenders.");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.loggerEventEmitter.logParamException();
            DebugDialog.this.loggerEventEmitter.logParamException2();
        }
    }

    private class LogExceptionsAction
    extends AbstractAction {
        private static final long serialVersionUID = -2289262066339501111L;

        public LogExceptionsAction() {
            super("Log exceptions");
            this.putValue("ShortDescription", "Creates logging events containing exceptions.");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.loggerEventEmitter.logException();
            DebugDialog.this.loggerEventEmitter.logException2();
            DebugDialog.this.loggerEventEmitter.logExceptionSuppressed();
        }
    }

    private class LogASCIIArtAction
    extends AbstractAction {
        private static final long serialVersionUID = -3162155864945849819L;

        public LogASCIIArtAction() {
            super("Log ASCII-Art");
            this.putValue("ShortDescription", "Logs some ASCII-Art. This can be used to see if details view is handling preformatted text correctly. May be NSFW depending on the closed-mindedness of your working environment...");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.loggerEventEmitter.logASCII();
        }
    }

    private class LogStuffAction
    extends AbstractAction {
        private static final long serialVersionUID = -3191463140774402016L;

        public LogStuffAction() {
            super("Log stuff");
            this.putValue("ShortDescription", "Creates logging events, some containing MDC, some containing Markers and some containing both.");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.loggerEventEmitter.logStuff();
            DebugDialog.this.loggerEventEmitter.logStuffWithMarker();
            DebugDialog.this.loggerEventEmitter.logStuffWithMdc();
            DebugDialog.this.loggerEventEmitter.logStuffWithMdcAndMarker();
        }
    }

    private class DoneAction
    extends AbstractAction {
        private static final long serialVersionUID = -7747612911180730271L;

        public DoneAction() {
            super("Done");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.setVisible(false);
        }
    }
}

