/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import de.huxhorn.lilith.VersionBundle;
import de.huxhorn.lilith.appender.InternalLilithAppender;
import de.huxhorn.lilith.cli.Cat;
import de.huxhorn.lilith.cli.CommandLineArgs;
import de.huxhorn.lilith.cli.Filter;
import de.huxhorn.lilith.cli.Help;
import de.huxhorn.lilith.cli.Index;
import de.huxhorn.lilith.cli.Md5;
import de.huxhorn.lilith.cli.Tail;
import de.huxhorn.lilith.handler.Slf4JHandler;
import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.LicenseAgreementDialog;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.SplashScreen;
import de.huxhorn.lilith.tools.CatCommand;
import de.huxhorn.lilith.tools.CreateMd5Command;
import de.huxhorn.lilith.tools.FilterCommand;
import de.huxhorn.lilith.tools.ImportExportCommand;
import de.huxhorn.lilith.tools.IndexCommand;
import de.huxhorn.lilith.tools.TailCommand;
import de.huxhorn.sulky.io.IOUtilities;
import de.huxhorn.sulky.sounds.Sounds;
import de.huxhorn.sulky.sounds.jlayer.JLayerSounds;
import de.huxhorn.sulky.swing.Windows;
import it.sauronsoftware.junique.AlreadyLockedException;
import it.sauronsoftware.junique.JUnique;
import it.sauronsoftware.junique.MessageHandler;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.simplericity.macify.eawt.DefaultApplication;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lilith {
    public static final String APP_NAME;
    public static final String APP_VERSION;
    public static final String APP_PLAIN_VERSION;
    public static final boolean APP_SNAPSHOT;
    public static final String APP_REVISION;
    public static final long APP_TIMESTAMP;
    public static final String APP_TIMESTAMP_DATE;
    public static final VersionBundle APP_VERSION_BUNDLE;
    private static final String SNAPSHOT_POSTFIX = "-SNAPSHOT";
    private static final String JUNIQUE_MSG_SHOW = "Show";
    private static final String JUNIQUE_REPLY_OK = "OK";
    private static final String JUNIQUE_REPLY_UNKNOWN = "Unknown";
    private static Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private static MainFrame mainFrame;

    public static void main(String[] argv) {
        List<String> files;
        String command;
        Slf4JHandler handler = new Slf4JHandler();
        java.util.logging.Logger rootLogger = java.util.logging.Logger.getLogger("");
        rootLogger.addHandler((Handler)handler);
        rootLogger.setLevel(Level.WARNING);
        String appTitle = APP_NAME + " V" + APP_VERSION;
        if (APP_SNAPSHOT) {
            appTitle = appTitle + " (" + APP_TIMESTAMP_DATE + ")";
        }
        CommandLineArgs cl = new CommandLineArgs();
        JCommander commander = new JCommander((Object)cl);
        Cat cat = new Cat();
        commander.addCommand("cat", (Object)cat);
        Tail tail = new Tail();
        commander.addCommand("tail", (Object)tail);
        Filter filter = new Filter();
        commander.addCommand("filter", (Object)filter);
        Index index = new Index();
        commander.addCommand("index", (Object)index);
        Md5 md5 = new Md5();
        commander.addCommand("md5", (Object)md5);
        Help help = new Help();
        commander.addCommand("help", (Object)help);
        try {
            commander.parse(argv);
        }
        catch (ParameterException ex) {
            Lilith.printAppInfo(appTitle, false);
            System.out.println(ex.getMessage() + "\n");
            Lilith.printHelp(commander);
            System.exit(-1);
        }
        if (cl.verbose) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            Date d = new Date(APP_TIMESTAMP);
            appTitle = appTitle + " - " + sdf.format(d);
            appTitle = appTitle + " - " + APP_REVISION;
        }
        if (cl.showHelp) {
            Lilith.printAppInfo(appTitle, false);
            Lilith.printHelp(commander);
            System.exit(0);
        }
        if (!("tail".equals(command = commander.getParsedCommand()) || "cat".equals(command) || "filter".equals(command))) {
            Lilith.printAppInfo(appTitle, true);
        }
        if (cl.logbackConfig != null) {
            File logbackFile = new File(cl.logbackConfig);
            if (!logbackFile.isFile()) {
                System.out.println(logbackFile.getAbsolutePath() + " is not a valid file.");
                System.exit(-1);
            }
            try {
                Lilith.initLogbackConfig(logbackFile.toURI().toURL());
            }
            catch (MalformedURLException e) {
                System.out.println("Failed to convert " + logbackFile.getAbsolutePath() + " to URL. " + e);
                System.exit(-1);
            }
        } else if (cl.verbose) {
            Lilith.initVerboseLogging();
        }
        if (cl.printBuildTimestamp) {
            System.out.println("Build-Timestamp: " + APP_TIMESTAMP);
            System.out.println("Build-Date     : " + APP_TIMESTAMP_DATE);
            System.out.println("Build-Revision : " + APP_REVISION);
            System.exit(0);
        }
        if ("help".equals(command)) {
            commander.usage();
            if (help.commands == null || help.commands.size() == 0) {
                commander.usage("help");
            } else {
                Map commands = commander.getCommands();
                for (String current : help.commands) {
                    if (commands.containsKey(current)) {
                        commander.usage(current);
                        continue;
                    }
                    System.out.println("Unknown command '" + current + "'!");
                }
            }
            System.exit(0);
        }
        if ("md5".equals(command)) {
            files = md5.files;
            if (files == null || files.size() == 0) {
                Lilith.printHelp(commander);
                System.exit(-1);
            }
            boolean error = false;
            for (String current : files) {
                if (CreateMd5Command.createMd5(new File(current))) continue;
                error = true;
            }
            if (error) {
                System.exit(-1);
            }
            System.exit(0);
        }
        if ("index".equals(command)) {
            if (!cl.verbose && cl.logbackConfig == null) {
                Lilith.initCLILogging();
            }
            if ((files = index.files) == null || files.size() == 0) {
                Lilith.printHelp(commander);
                System.exit(-1);
            }
            boolean error = false;
            for (String current : files) {
                if (IndexCommand.indexLogFile(new File(current))) continue;
                error = true;
            }
            if (error) {
                System.exit(-1);
            }
            System.exit(0);
        }
        if ("cat".equals(command)) {
            if (!cl.verbose && cl.logbackConfig == null) {
                Lilith.initCLILogging();
            }
            if ((files = cat.files) == null || files.size() != 1) {
                Lilith.printHelp(commander);
                System.exit(-1);
            }
            if (CatCommand.catFile(new File(files.get(0)), cat.pattern, cat.numberOfLines)) {
                System.exit(0);
            }
            System.exit(-1);
        }
        if ("tail".equals(command)) {
            if (!cl.verbose && cl.logbackConfig == null) {
                Lilith.initCLILogging();
            }
            if ((files = tail.files) == null || files.size() != 1) {
                Lilith.printHelp(commander);
                System.exit(-1);
            }
            if (TailCommand.tailFile(new File(files.get(0)), tail.pattern, tail.numberOfLines.intValue(), tail.keepRunning)) {
                System.exit(0);
            }
            System.exit(-1);
        }
        if ("filter".equals(command)) {
            if (!cl.verbose && cl.logbackConfig == null) {
                Lilith.initCLILogging();
            }
            if (FilterCommand.filterFile(new File(filter.input), new File(filter.output), new File(filter.condition), filter.searchString, filter.pattern, filter.overwrite, filter.keepRunning, filter.exclusive)) {
                System.exit(0);
            }
            System.exit(-1);
        }
        if (cl.flushPreferences) {
            Lilith.flushPreferences();
        }
        if (cl.exportPreferencesFile != null) {
            Lilith.exportPreferences(cl.exportPreferencesFile);
        }
        if (cl.importPreferencesFile != null) {
            Lilith.importPreferences(cl.importPreferencesFile);
        }
        if (cl.exportPreferencesFile != null || cl.importPreferencesFile != null) {
            System.exit(0);
        }
        if (cl.flushLicensed) {
            Lilith.flushLicensed();
        }
        Lilith.startLilith(appTitle, cl.enableBonjour);
    }

    private static void printHelp(JCommander commander) {
        commander.usage();
        String command = commander.getParsedCommand();
        if (command != null) {
            commander.usage(command);
        }
    }

    private static void printAppInfo(String appTitle, boolean printHelpInfo) {
        System.out.println(" _     _ _ _ _   _     \n| |   (_) (_) |_| |__  \n| |   | | | | __| '_ \\ \n| |___| | | | |_| | | |\n|_____|_|_|_|\\__|_| |_|");
        System.out.println(appTitle);
        System.out.println("http://lilith.huxhorn.de");
        System.out.println("\nCopyright (C) 2007-2013 Joern Huxhorn\n\nThis program comes with ABSOLUTELY NO WARRANTY!\n\nThis is free software, and you are welcome to redistribute it\nunder certain conditions.\nYou should have received a copy of the GNU General Public License\nalong with this program.  If not, see <http://www.gnu.org/licenses/>.\n");
        if (printHelpInfo) {
            System.out.println("Use commandline option -h to view help.\n");
        }
    }

    private static void importPreferences(String file) {
        ImportExportCommand.importPreferences(new File(file));
    }

    private static void exportPreferences(String file) {
        ImportExportCommand.exportPreferences(new File(file));
    }

    private static void startLilith(String appTitle, boolean enableBonjour) {
        final Logger logger = LoggerFactory.getLogger(Lilith.class);
        uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                if (logger.isErrorEnabled()) {
                    logger.error("Caught an uncaught exception from thread {}!", (Object)t, (Object)e);
                }
                System.err.println("\n-----\nThread " + t.getName() + " threw an exception!");
                e.printStackTrace(System.err);
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
        try {
            JUnique.acquireLock((String)Lilith.class.getName(), (MessageHandler)new MessageHandler(){

                public String handle(String message) {
                    return Lilith.handleJUniqueMessage(message);
                }
            });
        }
        catch (AlreadyLockedException e) {
            if (logger.isInfoEnabled()) {
                logger.info("Detected running instance, quitting.");
            }
            String result = JUnique.sendMessage((String)Lilith.class.getName(), (String)JUNIQUE_MSG_SHOW);
            if (logger.isDebugEnabled()) {
                logger.debug("JUnique result: {}", (Object)result);
            }
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Thread.currentThread().setUncaughtExceptionHandler(uncaughtExceptionHandler);
            }
        });
        Lilith.startUI(appTitle, enableBonjour);
    }

    private static void initCLILogging() {
        Lilith.initLogbackConfig(Lilith.class.getResource("/logbackCLI.xml"));
    }

    private static void initVerboseLogging() {
        Lilith.initLogbackConfig(Lilith.class.getResource("/logbackVerbose.xml"));
    }

    private static void initLogbackConfig(URL configUrl) {
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        if (loggerFactory instanceof LoggerContext) {
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            loggerContext.reset();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)loggerContext);
            try {
                configurator.doConfigure(configUrl);
                Logger logger = LoggerFactory.getLogger(Lilith.class);
                if (logger.isDebugEnabled()) {
                    logger.debug("Configured logging with {}.", (Object)configUrl);
                }
                StatusPrinter.print((Context)loggerContext);
            }
            catch (JoranException ex) {
                Logger logger = LoggerFactory.getLogger(Lilith.class);
                if (logger.isErrorEnabled()) {
                    logger.error("Error configuring logging framework!", (Throwable)ex);
                }
                StatusPrinter.print((Context)loggerContext);
            }
        }
    }

    private static void flushLicensed() {
        Logger logger = LoggerFactory.getLogger(Lilith.class);
        ApplicationPreferences prefs = new ApplicationPreferences();
        prefs.setLicensed(false);
        if (logger.isInfoEnabled()) {
            logger.info("Flushed licensed...");
        }
        System.exit(0);
    }

    private static void flushPreferences() {
        Logger logger = LoggerFactory.getLogger(Lilith.class);
        ApplicationPreferences prefs = new ApplicationPreferences();
        prefs.reset();
        prefs.setLicensed(false);
        if (logger.isInfoEnabled()) {
            logger.info("Flushed preferences...");
        }
        System.exit(0);
    }

    private static String handleJUniqueMessage(String msg) {
        if (JUNIQUE_MSG_SHOW.equals(msg)) {
            Lilith.showMainFrame();
            return JUNIQUE_REPLY_OK;
        }
        return JUNIQUE_REPLY_UNKNOWN;
    }

    private static void showMainFrame() {
        if (mainFrame != null) {
            final MainFrame frame = mainFrame;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (frame.isVisible()) {
                        frame.setVisible(false);
                    }
                    Windows.showWindow((Window)frame, null, (boolean)false);
                    frame.toFront();
                }
            });
        }
    }

    private static void updateSplashStatus(final SplashScreen splashScreen, final String status) throws InvocationTargetException, InterruptedException {
        if (splashScreen != null) {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    if (!splashScreen.isVisible()) {
                        Windows.showWindow((Window)splashScreen, null, (boolean)true);
                    }
                    splashScreen.toFront();
                    splashScreen.setStatusText(status);
                }
            });
        }
    }

    private static void hideSplashScreen(final SplashScreen splashScreen) throws InvocationTargetException, InterruptedException {
        if (splashScreen != null) {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    splashScreen.setVisible(false);
                }
            });
        }
    }

    public static void startUI(String appTitle, boolean enableBonjour) {
        block33: {
            String lookAndFeel;
            Logger logger = LoggerFactory.getLogger(Lilith.class);
            UIManager.installLookAndFeel("JGoodies Windows", "com.jgoodies.looks.windows.WindowsLookAndFeel");
            UIManager.installLookAndFeel("JGoodies Plastic", "com.jgoodies.looks.plastic.PlasticLookAndFeel");
            UIManager.installLookAndFeel("JGoodies Plastic 3D", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
            UIManager.installLookAndFeel("JGoodies Plastic XP", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
            if (SystemUtils.IS_JAVA_1_6) {
                UIManager.installLookAndFeel("Substance Dark - Twilight", "org.pushingpixels.substance.api.skin.SubstanceTwilightLookAndFeel");
                UIManager.installLookAndFeel("Substance Light - Business", "org.pushingpixels.substance.api.skin.SubstanceBusinessLookAndFeel");
            }
            DefaultApplication application = new DefaultApplication();
            ApplicationPreferences applicationPreferences = new ApplicationPreferences();
            HashMap storedDefaults = new HashMap();
            if (application.isMac()) {
                try {
                    System.setProperty("apple.laf.useScreenMenuBar", "true");
                }
                catch (Exception e) {
                    System.setProperty("com.apple.macos.useScreenMenuBar", "true");
                }
            }
            if ((lookAndFeel = applicationPreferences.getLookAndFeel()) != null) {
                block32: {
                    try {
                        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                            if (!lookAndFeel.equals(info.getName())) continue;
                            String lafClassName = info.getClassName();
                            if (logger.isDebugEnabled()) {
                                logger.debug("Setting look&feel to {}.", (Object)lafClassName);
                            }
                            UIManager.setLookAndFeel(lafClassName);
                            if (application.isMac() && lafClassName.equals(UIManager.getSystemLookAndFeelClassName())) {
                                try {
                                    System.setProperty("apple.laf.useScreenMenuBar", "true");
                                }
                                catch (Exception e) {
                                    System.setProperty("com.apple.macos.useScreenMenuBar", "true");
                                }
                            }
                            break;
                        }
                    }
                    catch (Throwable t) {
                        if (!logger.isErrorEnabled()) break block32;
                        logger.error("Exception while setting look & feel '{}'!", (Object)lookAndFeel, (Object)t);
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("storedDefaults: {}", storedDefaults);
                }
                for (Map.Entry current : storedDefaults.entrySet()) {
                    UIManager.put(current.getKey(), current.getValue());
                }
            }
            boolean splashScreenDisabled = applicationPreferences.isSplashScreenDisabled();
            try {
                File startupApplicationPath;
                SplashScreen splashScreen = null;
                if (!splashScreenDisabled) {
                    CreateSplashRunnable createRunnable = new CreateSplashRunnable(appTitle);
                    SwingUtilities.invokeAndWait(createRunnable);
                    splashScreen = createRunnable.getSplashScreen();
                    Thread.sleep(500L);
                    Lilith.updateSplashStatus(splashScreen, "Initialized application preferences...");
                }
                if ((startupApplicationPath = applicationPreferences.getStartupApplicationPath()).mkdirs() && logger.isDebugEnabled()) {
                    logger.debug("Created '{}'.", (Object)startupApplicationPath.getAbsolutePath());
                }
                File errorLog = new File(startupApplicationPath, "errors.log");
                boolean freshFile = false;
                if (!errorLog.isFile()) {
                    freshFile = true;
                }
                try {
                    FileOutputStream fos = new FileOutputStream(errorLog, true);
                    PrintStream ps = new PrintStream(fos, true);
                    if (!freshFile) {
                        ps.println("----------------------------------------");
                    }
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
                    ps.println("Started " + APP_NAME + " V" + APP_VERSION + " at " + format.format(new Date()));
                    System.setErr(ps);
                    if (logger.isInfoEnabled()) {
                        logger.info("Writing System.err to '{}'.", (Object)errorLog.getAbsolutePath());
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                File prevPathFile = new File(startupApplicationPath, ".previous.application.path");
                if (prevPathFile.isFile()) {
                    Lilith.updateSplashStatus(splashScreen, "Moving application path content...");
                    Lilith.moveApplicationPathContent(prevPathFile, startupApplicationPath);
                }
                if (!applicationPreferences.isLicensed()) {
                    Lilith.hideSplashScreen(splashScreen);
                    LicenseAgreementDialog licenseDialog = new LicenseAgreementDialog();
                    Windows.showWindow((Window)licenseDialog, null, (boolean)true);
                    if (licenseDialog.isLicenseAgreed()) {
                        applicationPreferences.setLicensed(true);
                    } else {
                        if (logger.isWarnEnabled()) {
                            logger.warn("Didn't accept license! Exiting...");
                        }
                        System.exit(-1);
                    }
                }
                Lilith.updateSplashStatus(splashScreen, "Creating main window...");
                CreateMainFrameRunnable createMain = new CreateMainFrameRunnable(applicationPreferences, splashScreen, appTitle, enableBonjour);
                SwingUtilities.invokeAndWait(createMain);
                final MainFrame frame = createMain.getMainFrame();
                if (logger.isDebugEnabled()) {
                    logger.debug("After show...");
                }
                Lilith.updateSplashStatus(splashScreen, "Initializing application...");
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        frame.startUp();
                    }
                });
                Lilith.hideSplashScreen(splashScreen);
                mainFrame = frame;
            }
            catch (InterruptedException ex) {
                if (logger.isInfoEnabled()) {
                    logger.info("Interrupted...", (Throwable)ex);
                }
            }
            catch (InvocationTargetException ex) {
                if (logger.isWarnEnabled()) {
                    logger.warn("InvocationTargetException...", (Throwable)ex);
                }
                if (!logger.isWarnEnabled()) break block33;
                logger.warn("Target-Exception: ", ex.getTargetException());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void moveApplicationPathContent(File prevPathFile, File startupApplicationPath) {
        Logger logger = LoggerFactory.getLogger(Lilith.class);
        FileInputStream is = null;
        String prevPathStr = null;
        try {
            is = new FileInputStream(prevPathFile);
            prevPathStr = IOUtils.toString((InputStream)is);
        }
        catch (IOException ex) {
            block9: {
                try {
                    if (!logger.isWarnEnabled()) break block9;
                    logger.warn("Exception while reading previous application path!", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    IOUtilities.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtilities.closeQuietly((InputStream)is);
        }
        IOUtilities.closeQuietly((InputStream)is);
        if (prevPathStr != null) {
            File prevPath;
            block10: {
                prevPath = new File(prevPathStr);
                try {
                    FileUtils.copyDirectory((File)prevPath, (File)startupApplicationPath);
                    FileUtils.deleteDirectory((File)prevPath);
                }
                catch (IOException ex) {
                    if (!logger.isWarnEnabled()) break block10;
                    logger.warn("Exception while moving content of previous application path '" + prevPath.getAbsolutePath() + "' to new one '" + startupApplicationPath.getAbsolutePath() + "'!", (Throwable)ex);
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info("Moved content from previous application path '{}' to new application path '{}'.", (Object)prevPath.getAbsolutePath(), (Object)startupApplicationPath.getAbsolutePath());
            }
        }
        if (prevPathFile.delete() && logger.isDebugEnabled()) {
            logger.debug("Deleted {}.", (Object)prevPathFile.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InternalLilithAppender.getSourceIdentifier();
        Logger logger = LoggerFactory.getLogger(Lilith.class);
        InputStream is = Lilith.class.getResourceAsStream("/app.properties");
        Properties p = new Properties();
        try {
            p.load(is);
        }
        catch (IOException ex) {
            if (logger.isErrorEnabled()) {
                logger.error("Couldn't find app info resource!", (Throwable)ex);
            }
        }
        finally {
            IOUtilities.closeQuietly((InputStream)is);
        }
        APP_NAME = p.getProperty("application.name");
        APP_VERSION = p.getProperty("application.version");
        boolean snapshot = false;
        String plainVersion = APP_VERSION;
        if (plainVersion != null && plainVersion.endsWith(SNAPSHOT_POSTFIX)) {
            snapshot = true;
            plainVersion = plainVersion.substring(0, plainVersion.length() - SNAPSHOT_POSTFIX.length());
        }
        APP_SNAPSHOT = snapshot;
        APP_PLAIN_VERSION = plainVersion;
        APP_REVISION = p.getProperty("application.revision");
        String tsStr = p.getProperty("application.timestamp");
        long ts = -1L;
        String dateStr = null;
        if (tsStr != null) {
            try {
                ts = Long.parseLong(tsStr);
                Date d = new Date(ts);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                dateStr = format.format(d);
            }
            catch (NumberFormatException ex) {
                if (logger.isErrorEnabled()) {
                    logger.error("Exception while reading timestamp!", (Throwable)ex);
                }
            }
        } else if (logger.isErrorEnabled()) {
            logger.error("Application-timestamp not found!");
        }
        APP_TIMESTAMP = ts;
        APP_TIMESTAMP_DATE = dateStr;
        APP_VERSION_BUNDLE = new VersionBundle(APP_PLAIN_VERSION, APP_TIMESTAMP);
        if (APP_VERSION != null) {
            System.setProperty("lilith.version", APP_VERSION);
        }
        if (APP_TIMESTAMP > -1L) {
            System.setProperty("lilith.timestamp.milliseconds", "" + APP_TIMESTAMP);
        }
        if (APP_TIMESTAMP_DATE != null) {
            System.setProperty("lilith.timestamp", APP_TIMESTAMP_DATE);
        }
        if (APP_REVISION != null) {
            System.setProperty("lilith.revision", APP_REVISION);
        }
    }

    static class CreateMainFrameRunnable
    implements Runnable {
        private SplashScreen splashScreen;
        private MainFrame mainFrame;
        private ApplicationPreferences applicationPreferences;
        private String appTitle;
        private boolean enableBonjour;

        public CreateMainFrameRunnable(ApplicationPreferences applicationPreferences, SplashScreen splashScreen, String appTitle, boolean enableBonjour) {
            this.splashScreen = splashScreen;
            this.enableBonjour = enableBonjour;
            this.appTitle = appTitle;
            this.applicationPreferences = applicationPreferences;
        }

        public void run() {
            this.mainFrame = new MainFrame(this.applicationPreferences, this.splashScreen, this.appTitle, this.enableBonjour);
            this.mainFrame.setSounds((Sounds)new JLayerSounds());
            this.mainFrame.setSize(1024, 768);
            Windows.showWindow((Window)this.mainFrame, null, (boolean)false);
        }

        public MainFrame getMainFrame() {
            return this.mainFrame;
        }
    }

    static class CreateSplashRunnable
    implements Runnable {
        private SplashScreen splashScreen;
        private String appTitle;

        public CreateSplashRunnable(String appTitle) {
            this.appTitle = appTitle;
        }

        public void run() {
            this.splashScreen = new SplashScreen(this.appTitle);
            Windows.showWindow((Window)this.splashScreen, null, (boolean)true);
        }

        public SplashScreen getSplashScreen() {
            return this.splashScreen;
        }
    }
}

