/*
 * Lilith - a log event viewer.
 * Copyright (C) 2007-2011 Joern Huxhorn
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package de.huxhorn.lilith.debug;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class LogASCIIRunnable
	extends AbstractDebugRunnable
{
	private final Logger logger = LoggerFactory.getLogger(LogASCIIRunnable.class);
	private static final Marker ASCII_MARKER;

	static
	{
		ASCII_MARKER = MarkerFactory.getDetachedMarker("ASCII");
		ASCII_MARKER.add(MarkerFactory.getDetachedMarker("Art"));
	}


	public LogASCIIRunnable(int delay)
	{
		super(delay);
	}

	public void runIt()
		throws InterruptedException
	{
		if(logger.isDebugEnabled())
		{
			logger.debug(ASCII_MARKER,
					"Skull!\n" +
					"     _.--\"\"\"\"\"--._\n" +
					"   .'             '.\n" +
					"  /                 \\\n" +
					" ;                   ;\n" +
					" |                   |\n" +
					" |                   |\n" +
					" ;                   ;\n" +
					"  \\ (`'--,    ,--'`) /\n" +
					"   \\ \\  _ )  ( _  / /\n" +
					"    ) )(')/  \\(')( (\n" +
					"   (_ `\"\"` /\\ `\"\"` _)\n" +
					"    \\`\"-, /  \\ ,-\"`/\n" +
					"     `\\ / `\"\"` \\ /`\n" +
					"      |/\\/\\/\\/\\/\\|\n" +
					"      |\\        /|\n" +
					"      ; |/\\/\\/\\| ;\n" +
					"       \\`-`--`-`/\n" +
					"        \\      /\n" +
					"         ',__,'\n" +
					"          q__p\n" +
					"          q__p\n" +
					"          q__p\n" +
					"          q__p"
			);

			sleep();

			logger.debug(ASCII_MARKER,
				"Mike Jittlov's \"Meriday in the Morning\"\n" +
				"\n" +
				"                       8888  8888888\n" +
				"                  888888888888888888888888\n" +
				"               8888:::8888888888888888888888888\n" +
				"             8888::::::8888888888888888888888888888\n" +
				"            88::::::::888:::8888888888888888888888888\n" +
				"          88888888::::8:::::::::::88888888888888888888\n" +
				"        888 8::888888::::::::::::::::::88888888888   888\n" +
				"           88::::88888888::::m::::::::::88888888888    8\n" +
				"         888888888888888888:M:::::::::::8888888888888\n" +
				"        88888888888888888888::::::::::::M88888888888888\n" +
				"        8888888888888888888888:::::::::M8888888888888888\n" +
				"         8888888888888888888888:::::::M888888888888888888\n" +
				"        8888888888888888::88888::::::M88888888888888888888\n" +
				"      88888888888888888:::88888:::::M888888888888888   8888\n" +
				"     88888888888888888:::88888::::M::;o*M*o;888888888    88\n" +
				"    88888888888888888:::8888:::::M:::::::::::88888888    8\n" +
				"   88888888888888888::::88::::::M:;:::::::::::888888888\n" +
				"  8888888888888888888:::8::::::M::aAa::::::::M8888888888       8\n" +
				"  88   8888888888::88::::8::::M:::::::::::::888888888888888 8888\n" +
				" 88  88888888888:::8:::::::::M::::::::::;::88:88888888888888888\n" +
				" 8  8888888888888:::::::::::M::\"@@@@@@@\"::::8w8888888888888888\n" +
				"  88888888888:888::::::::::M:::::\"@a@\":::::M8i888888888888888\n" +
				" 8888888888::::88:::::::::M88:::::::::::::M88z88888888888888888\n" +
				"8888888888:::::8:::::::::M88888:::::::::MM888!888888888888888888\n" +
				"888888888:::::8:::::::::M8888888MAmmmAMVMM888*88888888   88888888\n" +
				"888888 M:::::::::::::::M888888888:::::::MM88888888888888   8888888\n" +
				"8888   M::::::::::::::M88888888888::::::MM888888888888888    88888\n" +
				" 888   M:::::::::::::M8888888888888M:::::mM888888888888888    8888\n" +
				"  888  M::::::::::::M8888:888888888888::::m::Mm88888 888888   8888\n" +
				"   88  M::::::::::::8888:88888888888888888::::::Mm8   88888   888\n" +
				"   88  M::::::::::8888M::88888::888888888888:::::::Mm88888    88\n" +
				"   8   MM::::::::8888M:::8888:::::888888888888::::::::Mm8     4\n" +
				"       8M:::::::8888M:::::888:::::::88:::8888888::::::::Mm    2\n" +
				"      88MM:::::8888M:::::::88::::::::8:::::888888:::M:::::M\n" +
				"     8888M:::::888MM::::::::8:::::::::::M::::8888::::M::::M\n" +
				"    88888M:::::88:M::::::::::8:::::::::::M:::8888::::::M::M\n" +
				"   88 888MM:::888:M:::::::::::::::::::::::M:8888:::::::::M:\n" +
				"   8 88888M:::88::M:::::::::::::::::::::::MM:88::::::::::::M\n" +
				"     88888M:::88::M::::::::::*88*::::::::::M:88::::::::::::::M\n" +
				"    888888M:::88::M:::::::::88@@88:::::::::M::88::::::::::::::M\n" +
				"    888888MM::88::MM::::::::88@@88:::::::::M:::8::::::::::::::*8\n" +
				"    88888  M:::8::MM:::::::::*88*::::::::::M:::::::::::::::::88@@\n" +
				"    8888   MM::::::MM:::::::::::::::::::::MM:::::::::::::::::88@@\n" +
				"     888    M:::::::MM:::::::::::::::::::MM::M::::::::::::::::*8\n" +
				"     888    MM:::::::MMM::::::::::::::::MM:::MM:::::::::::::::M\n" +
				"      88     M::::::::MMMM:::::::::::MMMM:::::MM::::::::::::MM\n" +
				"      88    MM:::::::::MMMMMMMMMMMMMMM::::::::MMM::::::::MMM\n" +
				"        88    MM::::::::::::MMMMMMM::::::::::::::MMMMMMMMMM\n" +
				"         88   8MM::::::::::::::::::::::::::::::::::MMMMMM\n" +
				"          8   88MM::::::::::::::::::::::M:::M::::::::MM\n" +
				"              888MM::::::::::::::::::MM::::::MM::::::MM\n" +
				"             88888MM:::::::::::::::MMM:::::::mM:::::MM\n" +
				"             888888MM:::::::::::::MMM:::::::::MMM:::M\n" +
				"            88888888MM:::::::::::MMM:::::::::::MM:::M\n" +
				"           88 8888888M:::::::::MMM::::::::::::::M:::M\n" +
				"           8  888888 M:::::::MM:::::::::::::::::M:::M:\n" +
				"              888888 M::::::M:::::::::::::::::::M:::MM\n" +
				"             888888  M:::::M::::::::::::::::::::::::M:M\n" +
				"             888888  M:::::M:::::::::@::::::::::::::M::M\n" +
				"             88888   M::::::::::::::@@:::::::::::::::M::M\n" +
				"            88888   M::::::::::::::@@@::::::::::::::::M::M\n" +
				"           88888   M:::::::::::::::@@::::::::::::::::::M::M\n" +
				"          88888   M:::::m::::::::::@::::::::::Mm:::::::M:::M\n" +
				"          8888   M:::::M:::::::::::::::::::::::MM:::::::M:::M\n" +
				"         8888   M:::::M:::::::::::::::::::::::MMM::::::::M:::M\n" +
				"        888    M:::::M:::::::::::::::::::::::MMM:::::::::M::::M\n" +
				"      8888    MM::::Mm:::::::::::::::::::::MMMM:::::::::m::m:::M\n" +
				"    888      M:::::M::::::::::::::::::::MMM::::::::::::M::mm:::M\n" +
				"  8888       MM:::::::::::::::::::::::::MM:::::::::::::mM::MM:::M:\n" +
				"             M:::::::::::::::::::::::::M:::::::::::::::mM::MM:::Mm\n" +
				"            MM::::::m:::::::::::::::::::::::::::::::::::M::MM:::MM\n" +
				"            M::::::::M:::::::::::::::::::::::::::::::::::M::M:::MM\n" +
				"           MM:::::::::M:::::::::::::M:::::::::::::::::::::M:M:::MM\n" +
				"           M:::::::::::M88:::::::::M:::::::::::::::::::::::MM::MMM\n" +
				"           M::::::::::::8888888888M::::::::::::::::::::::::MM::MM\n" +
				"           M:::::::::::::88888888M:::::::::::::::::::::::::M::MM\n" +
				"           M::::::::::::::888888M:::::::::::::::::::::::::M::MM\n" +
				"           M:::::::::::::::88888M:::::::::::::::::::::::::M:MM\n" +
				"           M:::::::::::::::::88M::::::::::::::::::::::::::MMM\n" +
				"           M:::::::::::::::::::M::::::::::::::::::::::::::MMM\n" +
				"           MM:::::::::::::::::M::::::::::::::::::::::::::MMM\n" +
				"            M:::::::::::::::::M::::::::::::::::::::::::::MMM\n" +
				"            MM:::::::::::::::M::::::::::::::::::::::::::MMM\n" +
				"             M:::::::::::::::M:::::::::::::::::::::::::MMM\n" +
				"             MM:::::::::::::M:::::::::::::::::::::::::MMM\n" +
				"              M:::::::::::::M::::::::::::::::::::::::MMM\n" +
				"              MM:::::::::::M::::::::::::::::::::::::MMM\n" +
				"               M:::::::::::M:::::::::::::::::::::::MMM\n" +
				"               MM:::::::::M:::::::::::::::::::::::MMM\n" +
				"                M:::::::::M::::::::::::::::::::::MMM\n" +
				"                MM:::::::M::::::::::::::::::::::MMM\n" +
				"                 MM::::::M:::::::::::::::::::::MMM\n" +
				"                 MM:::::M:::::::::::::::::::::MMM\n" +
				"                  MM::::M::::::::::::::::::::MMM\n" +
				"                  MM:::M::::::::::::::::::::MMM\n" +
				"                   MM::M:::::::::::::::::::MMM\n" +
				"                   MM:M:::::::::::::::::::MMM\n" +
				"                   MMM::::::::::::::::::MMM\n" +
				"                    MM::::::::::::::::::MMM\n" +
				"                     M:::::::::::::::::MMM\n" +
				"                    MM::::::::::::::::MMM\n" +
				"                    MM:::::::::::::::MMM\n" +
				"                    MM::::M:::::::::MMM:\n" +
				"                    mMM::::MM:::::::MMMM\n" +
				"                     MMM:::::::::::MMM:M\n" +
				"                     mMM:::M:::::::M:M:M\n" +
				"                      MM::MMMM:::::::M:M\n" +
				"                      MM::MMM::::::::M:M\n" +
				"                      mMM::MM::::::::M:M\n" +
				"                       MM::MM:::::::::M:M\n" +
				"                       MM::MM::::::::::M:m\n" +
				"                       MM:::M:::::::::::MM\n" +
				"                       MMM:::::::::::::::M:\n" +
				"                       MMM:::::::::::::::M:\n" +
				"                       MMM::::::::::::::::M\n" +
				"                       MMM::::::::::::::::M\n" +
				"                       MMM::::::::::::::::Mm\n" +
				"                        MM::::::::::::::::MM\n" +
				"                        MMM:::::::::::::::MM\n" +
				"                        MMM:::::::::::::::MM\n" +
				"                        MMM:::::::::::::::MM\n" +
				"                        MMM:::::::::::::::MM\n" +
				"                         MM::::::::::::::MMM\n" +
				"                         MMM:::::::::::::MM\n" +
				"                         MMM:::::::::::::MM\n" +
				"                         MMM::::::::::::MM\n" +
				"                          MM::::::::::::MM\n" +
				"                          MM::::::::::::MM\n" +
				"                          MM:::::::::::MM\n" +
				"                          MMM::::::::::MM\n" +
				"                          MMM::::::::::MM\n" +
				"                           MM:::::::::MM\n" +
				"                           MMM::::::::MM\n" +
				"                           MMM::::::::MM\n" +
				"                            MM::::::::MM\n" +
				"                            MMM::::::MM\n" +
				"                            MMM::::::MM\n" +
				"                             MM::::::MM\n" +
				"                             MM::::::MM\n" +
				"                              MM:::::MM\n" +
				"                              MM:::::MM:\n" +
				"                              MM:::::M:M\n" +
				"                              MM:::::M:M\n" +
				"                              :M::::::M:\n" +
				"                             M:M:::::::M\n" +
				"                            M:::M::::::M\n" +
				"                           M::::M::::::M\n" +
				"                          M:::::M:::::::M\n" +
				"                         M::::::MM:::::::M\n" +
				"                         M:::::::M::::::::M\n" +
				"                         M;:;::::M:::::::::M\n" +
				"                         M:m:;:::M::::::::::M\n" +
				"                         MM:m:m::M::::::::;:M\n" +
				"                          MM:m::MM:::::::;:;M\n" +
				"                           MM::MMM::::::;:m:M\n" +
				"                            MMMM MM::::m:m:MM\n" +
				"                                  MM::::m:MM\n" +
				"                                   MM::::MM\n" +
				"                                    MM::MM\n" +
				"                                     MMMM\n" +
				"\n" +
				"(Source: http://www.textfiles.com/art/ASCIIPR0N/pinup00.txt)"
			);

			sleep();

			logger.debug(ASCII_MARKER,
				"                                    .:AMMMMMMMMMMA:.\n" +
				"                                  .AMMMMMMMMMMMHMMMMA.\n" +
				"                                 AMMMMMMMMMMMMMHMMMMMA\n" +
				"                                :MMMMMMMMMMMHMHHHHMMMMA.\n" +
				"                                AMMMMIIIIIIIIIIIIIIIIIMA.\n" +
				"                               :MMMMIIIIII:.... ..IIIIIMA\n" +
				"                               AHMMIIIIII::....   .:)IIMM\n" +
				"                               MMMMIIIIIII::....   /..:MM\n" +
				"                               MMMVIIIIII:::...   /...:MM\n" +
				"                               VMHIIIIIII:::.      ...:MM\n" +
				"                               :HHII::mMMMMm:.....mmm.IMM\n" +
				"                               IIHI::::YIMIbHI :dIMIIP:MI\n" +
				"                               IIIII:::::::.II :.::::..:I\n" +
				"                               `IIII::::::.:II :.   ..::V\n" +
				"                                VIIII:::::::II :......:A'\n" +
				"                                `III:I:::::IHIII:  ..::V\n" +
				"                                 VI::::::::::i.  . .::A\n" +
				"                                 `II:::::.md888bm.:.::V\n" +
				"                                  :IH::::::Y888P:..::A'\n" +
				"                                  AIH\\:::::::.  ..:::V\n" +
				"                                 .MIIIH::::::.....::V\n" +
				"                               .A::IIIIIIIIIIIIIIV.V\n" +
				"                             .:M:::I:IIIIIII:::::...M\n" +
				"                          .:I:::..II::III:::::::....:A.\n" +
				"                      .:A::...    I::::::::::::.....:. A:.\n" +
				"                    AI:.....     .:::::::::::::.....::    A:.\n" +
				"                 .:V:.......    ....::..:....::.....:... ....A:.\n" +
				"               .AMII::::::::::.:::..:::... .....   .............A.\n" +
				"             .A:::::......  ..:.::.....::... ...:::::. ..:::::::::A.\n" +
				"            AII::.......  ..::.:.....  . ::......:      .... .......A:.\n" +
				"          .AIII:::...     ::.......  ....  :...  ..::    ....... ....::A.\n" +
				"         .MIIII:::..     ::............... .:... ....::..:......   ....::A\n" +
				"         AIIIIII:::.....I:..................  :      ............      ::IA\n" +
				"        :MIIIII::::::::I:::::..............    ...................   .:::IIA\n" +
				"        AHIIIIIII:::::H:::::................. :......................::::IIM:\n" +
				"        MHIIIIIII:::IHII:::::...   .......  . ....................:::::::IIM\n" +
				"       :MMHIIIIIIIIIMHII::::::...       ..... ... ... .............::::IIIIV\n" +
				"       AMMHHIIIIIHIMHHHIII::::::....      ... :..      .. .......::::IIIIIA:\n" +
				"      AHHHHHHHHIIIIMHHHHIIIII:::::....     .. ....          ....::::HIIIIIM'\n" +
				"     AHHHHHHIII::IIMHHHHHIIIIII:::::....  ..  ::..          .....:HHIIIIIIM\n" +
				"    :MHHHHHHHI:::IMHHHHHHIMMIIIII:::::::....  :....        ....::HHIIIIIIIV:\n" +
				"    AHHHHIIHHII::IMHHHHHIMMoMIIIIIH:::::    :    ........:::.::HHIHH:IIIIIIA\n" +
				"   :MHHHIIIIIIIIIIM:IHHHIHMMMIHHIIHHA:::... ::::.   ::.::::HHoIHHHIIIIIIIIIV:\n" +
				"   AHHIIIIIIIIIIIIAAIIHHHHHHHHHHIII::::::     .   ...::::IIIHHHHH:IIIIIIIIIIA\n" +
				"  AHIHIIIIIIIIIIIV  VIIIHHHHHHIIIIH::::::  ..:::.    ::IIIIIIIAII:IIIIIIIIIIM\n" +
				" A:HIIIIIIIIIIIMV   `AII:IHHHIHIIIHHAm:::::::::::::::IIIIIIIIIHA:::IIIII:IIIM\n" +
				" I:IIIIIIIIIIMV'     V:::IHIIH::III::::    .::::: ::::::::::::M V::IIIIIIIIIM\n" +
				" I:IIII:::HIM'        V::IHHIH::HII::::::..:.::.    ::::..::IIM  V::IIIIIIIIV.\n" +
				" V:III:...:IM         `A:IHHHHmIHIHHAm::.....::.. .:::.:::::::V   V:IIIIIHIIIA\n" +
				" :M:II::....:A         V:IIHH:HIIIHHV::::::.:::.:::::.::I::::A'    AIIHHHIIIIM\n" +
				"  V:IIII:....:A        `A:IHH:HIIIII:::     ::::::::::::I::::V     MHHIIIIIIIM\n" +
				"  :MIIII:::...:A        V:IHHmIIIIIIA:::.. ...:    :::::I.IIA'     MHIIIIIIIIM\n" +
				"   VIIIIII::...:A       `AIHII:IIIIHHAm:::..::..    .::I::::M      MIIIIIIIIIV\n" +
				"    V:IIII:::...:A       MHHIHmHIIIIIV:::..HHH:::...:::I:..IV.    .VIIIIIIIIA'\n" +
				"     VIIII:I:::..:A      MIIHH:HIIIII::::.IMCMI.....:::I:...:A    AIIIIIIIIIM\n" +
				"      VIIII::::::::b    .VIH:::HIIIIA:::::.::::.....:..:I...:M    MIIIIIIIIIV\n" +
				"       `VIII::I.::::b   AIIH::::HIIIIHA::::::::.....I..:I...:M    M:IIIIIIIA:\n" +
				"         VIII:::::::M:. M\\IH::\\::HIIIIH:::::I::::...I:::I::::M    MIIIIIIIIM'\n" +
				"          VIII:::::I:HI:HI:::::II:HIIHV::I:::::::::I::::::.::M    V:IIIIIIIM\n" +
				"           `VII::I::IV::VIA::::.I:HIIH::::I:I::::::::::I...::M  .AIIIIIIIIIV\n" +
				"             VII:::V::::::VA::...I::IHHA:I:::I::::::::::....:MMA..::.:IIIIV\n" +
				"             `VI:I::::::....MA:...I::HV::I:::::::::::::I ...A.  . ..:.IIIV\n" +
				"               MIII::..:::....A....I::::::::.:::::::::I. . A:M8M....::IAV\n" +
				"               HIII:::../M8A:.M... .I:::::::::::::::::. .:AMMIV...V.::V'\n" +
				"               MI:I.....MMM88MMA:.  :I:I::::::::::.::::AMM88MV..AV..:A'\n" +
				"               V:II::::.M::MMM88MMMA:.IIIII::::::::AMMM888V'..:M...V:V\n" +
				"               `MII:::::M:::.`VM8888MMMMMMMMMMMMMMM8VK88V'...AV...V.:'\n" +
				"                VIMI:V:::A::...`VM888888888888888888968V . AV.A..V..V\n" +
				"                `MM::A`V: A:.... `VM88888888888888888MV  WV  A. V:VA'\n" +
				"                 VHM.:A:V: A....  .`VM88888888888888V'.     A:.V:V:M\n" +
				"                 `MM\\.:A:V::A.. .....VM888888888888V..     A::V:V. V\n" +
				"                  VIM:.IA:`WW.........VM8888888888V....  . WW:.V :V\n" +
				"                  `MHM.HIW:::..........VMM8888888M'........ WMVWWV\n" +
				"                   `VIM.IW:::...........VMMM88888V:............IM\n" +
				"                    `MIMII:::............VMMMM88V:::...........:M\n" +
				"                     M:II:::::............VMMMMVI::::.........::M\n" +
				"                     M::::::.... ....:.:::.MMMV:::::::.........:M\n" +
				"                     M::I::::... .....:::::MMIII:::::::.......::M\n" +
				"                     MIII:::....  ...::::::MIIII::::::::.:.:..::V\n" +
				"                     MII:::::... ..::::::::MHIIII::::::::...:.:A:\n" +
				"                     MIII:::.... ...:::::::MHII::I::..:::::::::M'\n" +
				"                     MII::::::.  ..::::::::MIIIIIIII:..::::::::M\n" +
				"                     MII::::::.  ..::::::::MIIIIIIII:.:::::::::M\n" +
				"                     MIII:::::.  ...:::::::MIIIII:III::::::::::V\n" +
				"                     MII::::::.  ...:::::::MIIIIIIIII:::::::::A:\n" +
				"                     MII::::::.  .:.:::::::MHIIIIII:::::::::::M'\n" +
				"                     MII:::::::.  :.:::::::MHHIIII:I::::::::::M\n" +
				"                     MIII::::::.  :.::::I::MHHIIIII::::::::::A:\n" +
				"                     VII::::::::  ..::::::MHHHHIIII::::::::I:M'\n" +
				"                     :AII:::::::. .::::::V MHHHIIII:::::II::IV\n" +
				"                     :MI::::::::. ..::::V  MHHHIII:::::III:IA:\n" +
				"                     :MI::::::::: ..:::A'  MHHHIIII::IIIII:IM'\n" +
				"                      VII::::::::  ::::M   MHHHIIIIIIIIIIIIIV\n" +
				"                      :AI::::::::  ::::M  :VHHHIIIIIIIIIIIIA'\n" +
				"                      :MI::::::::. ::::M  AHHHHIIIIIIIIIIIIV\n" +
				"                       MI::::::::. ::::V  MHHHHIII::IIIIIHV\n" +
				"                       MI:I::::::..:::A'  MHHHHIII:::::IIA'\n" +
				"                       MIH::::..::::::V  :VHHHHIII:::::IIV\n" +
				"                       MIHI:::..::::IA'  AHHHHHHII:::IIIA'\n" +
				"                       MIHI:::. :::HHM   MIIHHHHII:::I:IM\n" +
				"                      .VIIH::::::HHHIV   VIIIHHHIIH:::HIV\n" +
				"                      AIIIIH::::HHH:A'   :AIIHHIIIIHHHIA'\n" +
				"                     .VIIIIHHHIHHHIIV    `MIIIHIIIIIIIIV\n" +
				"                     AHIIIIIHHHHHHIA'     MHHIIHHIIIIIA'\n" +
				"                    .VHIIIIIIIHHH:IM      VHHHIIHHIIIIM\n" +
				"                    AIHIIIIIIIIIHIIM      :AHHIIIHHIIIV.\n" +
				"                   AIIHIIIIIIIIIIHIM      `MHHIIIIIIIIIA\n" +
				"                  .VIIHIIIIIIIIIHIIV:     .VHIIIIII:I:IM\n" +
				"                  AIIIIIIIIIIIIHIIIIA     AHHIIII:::I::M\n" +
				"                  MIIIIIIIIIIIHIIIIIM    .VHIHIII:I:I::M:\n" +
				"                  VIIIIIIIIIIHIIIIIIM    AHIIIHIII:::::V:\n" +
				"                  :AIIIIIIIIIIIIIIIIM   .VIIIIIHI::::::MA\n" +
				"                  `MIIIIIIIIIIIIIIHA'   AIIIIIIHI:::::IMV\n" +
				"                   VIIIIIIIIIIIIHHHV    MHIIII:II.:::IIA:\n" +
				"                   `VIIIIIIIIIIHHHV     MHIIIIIII.:::IIM\n" +
				"                    :AIIIIIIIIHHHM'     MHHIII:II::II:IM\n" +
				"                     MIIIIIIHHHHHV      MHHIII:II::IIIIV\n" +
				"                     MIIIIIIHHHHV       VAHIII:I:::IIIA:\n" +
				"                     VHIIIIIIHHA'       :MHII::I:::IIIM\n" +
				"                     :AIIIIIIHHM         MHI::II:IIIIIM\n" +
				"                     `MHIIIIIIIM         MHII:I::IIIIIV\n" +
				"                      MIIIIIIIIM         MHII:I:::IIIA'\n" +
				"                      VHHIIIIIIM         MHII:I:II:IIV\n" +
				"                      :AIIIIIIIM         MHII.I::IIIV\n" +
				"                      `MIIIIIIIM         MHII:I:IIIA\n" +
				"                       MHIIIIIIM         MHHII::IIIV\n" +
				"                       MHIIIIIIV.        MHH:I::IIV\n" +
				"                       MHHII:IIIA        MHI:I:IIA'\n" +
				"                       MHHIIIIIIM        MHI:::IIV\n" +
				"                       MHHIIIIIIM       :VI::::IA'\n" +
				"                       MHHIIIIIIM       AMM::::IV\n" +
				"                      .VII:::::IM       MHII:::IM\n" +
				"                      AI:I::::IIM      .VIII:::IV\n" +
				"                     AIIII::::IIM      AHIII:::::A\n" +
				"                     MIIII::::::V     .VHIII:::::V.\n" +
				"                     MII:::::::A'     AHHIII::::::A.\n" +
				"                    .V:I:::::IIM      VHHII:I:::::::A.\n" +
				"                    AI:I:II:::IM       VAHIIII:::.:::A.\n" +
				"                   .M:::::::::IM        `\"VAHIII:.:::::A.\n" +
				"                   M.....::I:::M            `\"VAI:::.:::VMA.\n" +
				"                   VA.......:::V:              `VMI::..:::VA)\n" +
				"                   `M.Q.Q.Q./..:D               `VM:::::D:::D)\n" +
				"                     V(E(E(EIIMD                   `VMIID)MD)\n"+
				"\n" +
				"(Source: http://www.textfiles.com/art/ASCIIPR0N/hunky01.txt)"
			);

			sleep();

			logger.debug(ASCII_MARKER,
				"                                                      $$$$$$$$$\n" +
				"                                                  $$$$$$$$$$$$$$$$$         $$$$$$\n" +
				"                                                $$$$$$$$$$$$$$$$$$$$    $$$$$$$$$$$$$$\n" +
				"                                              $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                             $$$$$$$$$$$$$$$$$$$$$$$.$$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                            $$$$$$$$$$$$$$$$$$$$$$$$.$$$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                           $$$$$$$$$$$$$$$$$$$$$$$$$.$$$$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                           $$$$$$$$$$$$$$$$$$$$$$$$$.$$$$$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                          $$$$$$$$$$$$$$$$$$$$$$$$$$.$$$$$$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                          $$$$$$$$$$$$$$$$$$$$$$$$$.$.$$$$$$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                          $$$$$$$$$$$$$$$$$$$$$$$..$$$..$$$$$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                         $$$$$$$$$$$$$$$$$$$$....$$$$$$$..$$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                         $$$$$$$$$$$$$$$$$$..$$$$$$$$$$$$$..$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                         $$$$$$$$$$$$$$$$..$$$$$$$$$$$$$$$$$.$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                        $$$$$$$$$$$$$$$$.$$$$$$$$$$$$$$$$$$$$.$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                        $$$$$$$$$$$$$$..$$$$$$$$$$$$$$$$$$$$$$..$$$$$$$$$$$$$$$$$$$$\n" +
				"                                        $$$$$$$$$$$$..$$$$$$$$$$$$$$$$$$$$$$$$$$.$$$$$$$$$$$$$$$$$$$$\n" +
				"                                        $$$$$$$$$$$.$$$$$$$$$$$$$$$$$$$$$$$$$$$$$.$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                       $$$$$$$$$$$.$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$.$$$$$$$$$$$$$$$$$$$$\n" +
				"                                       $$$$$$$$$$.$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$.$$$$$$$$$$$$$$$$$$$$\n" +
				"                                       $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$.$$$$$$$$$$$$$$$$$$$$\n" +
				"                                       $$$$$$$$$        $$$$$$$$$ $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                       $$$$$$$$              $$$$$$$$$$$$$$$$$$$....$$$$$$$$$$$$$$$$$$$$\n" +
				"                                       $$$$$$$$                 $$$$$$$$    .........$$$$$$$$$$$$$$$$$$$$\n" +
				"                                      $$$$$$$$$                                  .....$$$$$$$$$$$$$$$$$$$\n" +
				"                                      $$$$$$$$                                     ...$$$$$$$$$$$$$$$$$$$$\n" +
				"                                      $$$$$$$$                                     ...$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                      $$$$$$$$                                     ....$$$$$$$$$$$$$$$$$$$$\n" +
				"                                      $$$$$$$$                                     ....$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                     $$$$$$$$$                                     ....$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                     $$$$$$$$$ /< $$$*..                           .....$$$$$$$$$$$$$$$$$$$$\n" +
				"                                     $$$$$$$$$% 1    $$$$*                   .**$$$$....$$$$$$$$$$$$$$$$$$$$\n" +
				"                                    $$$$$$$-$$1 1          -           *$$$$$$$$........$$$$$$$$$$$$$$$$$$$$\n" +
				"                                    $$$$$$/ 1$1-1-------  / <                 .   .....$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                    $$$$$$1 11  1-  $$  -1  1          .*------*.......$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                   $$$$$$$1/ 1  1 -------1  1         $   $$     $.....$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                   $$$$$$$1  1  1        1--1   /1      --------......$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                  $$$$$$$$1  1  .1       1 .1  1 1              ......$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                  $$$$$$$$$1 1  .1      /  .1  1-1              ......$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                  $$$$$$$$$1 1  .1      1 ..1 1  1             ......$$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                 $$$$$$$$$$1 1  ..1    1  ..1 1  1           ........$$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                 $$$$$$$$$$1  1  .1    1  ..11  1     1     ........$$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                 $$$$$$$$$$1  1  ..1   1  ..1  .1/---.<     .......$$$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                $$$$$$$$$$$1  1  ..1  1   ..1 ..1          ........$$$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                $$$$$$$$$$$1  1  ...1 1  ..1  .1           .......$.$$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                $$$$$$$$$$$1  1   ..11   ..1  .1           ......$..$$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                $$$$$$$$$$$$1 1    ..1   ..1  .1$$$$$$$   ......$...$$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                $$$$$$$$$$$$1            ..1  .1$$$$$    ......$...$$$$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                $$$$$$$$$$$$$1            .1   .1.      .....$$...$$$$$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                $$$$$$$$$$$$$1                 .1..    $$...$....$$$$$$$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                $$$$$$$$$$$$$$1                 .1..  $$$$.$...$$$$$$$$------..$$$$$$$$$$$$$$\n" +
				"                                 $$$$$$$$$$$$$$$.               .1...$$$$$$$$$$$$$$$$$/      ----$$$$$$$$$$$$$$       $$$$$\n" +
				"                                 $$$$$$$$$$$$$$ $..             .1$$$$$$$$$$$$$$$$$$/.          -..$$$$$$$$$$$$$$$$$$$$$$$\n" +
				"                                 $$$$$$$$$$$$$$  $..           ..$..$$$$$$$$$$$$$$$/.            --------$$$$$$$$$$$$$$$$$\n" +
				"                                  $$$$$$$$$$$$    $..          ..$..$$$$$$$$$$$$$$/.                      -$$$$$$$$$$$$$$\n" +
				"                                    $$$$$$$$$     $...         ..$..$$$$$$$$$$$$$/.               ....$$$$$$$$$$$$$$$$$$\n" +
				"                  .*$$$$$$$$$$$$$$$$$$$$$$         $...        ..$...$$$$$$$$$$/..              ...$$$.....     $$$$$$$\n" +
				"               .*$$                                $...       ...$....$$$$$$$$/..            .....$$$$$$$$$$$$$$--  ..$$\n" +
				"             *$$                                   $...       ...$....  $$$$$/..            ....              1   <  ..*$\n" +
				"            $                                      $..        ...$...     $$1..                  ........**$$$$$$$   ...*$\n" +
				"           $                                       $.        ...$....       $..           $   .....$$$$$$            ....*$\n" +
				"          $                                       $..        ...$...        $..           .$ .*..$$...               ....*$\n" +
				"          $                                       $.         ..*$...        $..          ...$.*.$*....              .....**$\n" +
				"         $                                       $.         ..*$...         $..           ...$ $*.....              .....**$\n" +
				"         $.                                     $..        ...*$...         $...           ...$**......             .....**$\n" +
				"        .$.             ..$                     $.        ...*$...           $..           ...$**......             .....**\n" +
				"        $..             ..$.                   $..       ....*$..            $..           ...$**........           .....**$\n" +
				"        $..             ...$..                $..        ...*$..             $...           ...$**.......           .....**$\n" +
				"        $..             ...$.. $             $..        ....*$..              $..           ...$**....$..   $       ....***$\n" +
				"        $..            ....$..$.            $..        ....*$..               $..           ....$**....$$. $         ...***$\n" +
				"       .$..             ....$$..           $..        ....*$..                $...          ....$**......$$.         ...***$\n" +
				"       *...             ....$..           $..        .....*$..                 $..           ....$**.....$..         ...***$\n" +
				"       $...             ....$..          $..        .....*$$.            $     $..           ....$**.....$..        ....***$\n" +
				"       $...              ...$..         $..         ....*$..$          $       $...           ...*$**...$..         ....***$\n" +
				"       $..               ...$..       $..          ....**$.. $       $          $...          ....*$**..$..         ....***$\n" +
				"       $..               ...$..      $..          ....**$..   $    .$           $...           ....*$**.$..         ....***$\n" +
				"       $..               ...$..    $...          .....**$..    $  ..$.          $...            ....*$*$*..         ...****$\n" +
				"       $..              ....$.    $..           .....**$..      $..$..           $...            ....*$$*..         ...****$\n" +
				"       $..              ....$.   $..           .....**$..       $..$..           $...            ....**$**..        ...****$\n" +
				"       $..              ...$.  $...           ......**$..       $**$..            $...            ....*$***..       ...****$\n" +
				"       $..             ....$. $..            ......**$..       ..$$...            $...             ...**$**.       ....***$\n" +
				"       $..             ....$$...           .......***$..       ..$$*..            $...             ....**$*.       ....***$\n" +
				"       $..             ...$...            .......***$..        ..$$*..            $...             .....***..      ....***$\n" +
				"       $...           ...$...            .......***$..         ..$$*...            $...             .....$*..      ....***$\n" +
				"       $...          ...$...            .......***$..         ...$.$*..            $...             ....**$*..     ....***$\n" +
				"       $...          ..$...            ........***$..        ...$*.$*...           $...             .....**$*..     ...***$\n" +
				"        $..         ...$..            ........***$..       ....*$ ..$*....         $...              .....**$*..    ..****$\n" +
				"        $..         ..$..            ........***$...     ....**$   ..$**....        $...             ......**$..    ..****$\n" +
				"        $..         ..$.           ..........***$...   ....**$$.    ..$***.....     $...            ........**$..   ..***$\n" +
				"        $...        .$.           ..........***$*........**$$..      ..$****........$....           .........**$.   ..***$\n" +
				"        $...        $.           ...........***$***..****$$...       ...$$*****......$...           .........**$.  ..***$\n" +
				"        $...        $           ...........***$********$$...           ...$$*********$....           ..........*$   ..***$\n" +
				"         $..                   ............***$*****$$$...               ...$$$$******$...            .........**$  ..**$\n" +
				"         $...                 ............***$$$$$$.....        .          .....$$$$$$$....           ..........*$  ..**$\n" +
				"         $...                 ...........***$*........          .              ........$...           ..........**$..**$\n" +
				"          $...               ...........****$*.......          ..                  ....$....           ..........*$..**$\n" +
				"          $...              ...........****$*......           ..                   .....$...            .........*$..**$\n" +
				"           $...             ..........****$*......            ..                  .......$....             ..........**$\n" +
				"           $...            ..........****$*......            ...                  ........$....            .........**$\n" +
				"            $...          ..........****$*......             ..                  ..........$....           ........**$\n" +
				"             $...         ........****$**......             ...                  ...........$....          .......**$\n" +
				"              $...       ........****$**.....              ....                 ............*$....         .......**$\n" +
				"              $....     ........****$**.....              ....                  .............*$....        ......**$\n" +
				"               $....    ......****$***.....              .....                   .............*$....      ......**$\n" +
				"                $....  .....****$****.....              .....                     ............**$....    ......***$\n" +
				"                 $........*****$****....                .....                      ...........***$..... ......**$$\n" +
				"                  $$**********$$***....                ......                      ...........*****$.........**$\n" +
				"                    $$*******$ $***....               .......                       .........*******$$......$$$\n" +
				"                      $$$$$$   $**....               .......                        .........*********$$$$$$\n" +
				"                               $*....               ........                         ........***********$\n" +
				"                               $*...               .........                         .........**********$\n" +
				"                               $*..                ........                           .........********$\n" +
				"                              $*...                ........                           .........*******$\n" +
				"                              $*...                ........                            ........******$\n" +
				"                              $...                  .......                            ........*****$\n" +
				"                             $....                  ....*.                              .......****$\n" +
				"                             $...                    ...$.                              .......****$\n" +
				"                            $....                    ...$.                              .......***$\n" +
				"                            $...                     ...$                              .......***$\n" +
				"                           $....                      ..$                              ......***$\n" +
				"                           $...                       ..$                              ......***$\n" +
				"                          $...                        .$                              ......***$\n" +
				"                          $...                         $                              ......**$\n" +
				"                         $...                                                        ......**$\n" +
				"                        $$...                                                       ......**$\n" +
				"                       $.$...                                                      .......**$\n" +
				"                      $..$...                        **                            .......*$$\n" +
				"                     $...$..                         **                           .......*$*$\n" +
				"                    $....$..                                                     ........*$*$\n" +
				"                   $......$.                                                    ........*$**$\n" +
				"                  $*......$.                                                   ........*$.***$\n" +
				"                 $*........$                        $                         ........*$..***$\n" +
				"                $*.........$                        $                        .........$...****$\n" +
				"               $*...........$                       $                        ..............***$\n" +
				"              $*...... .....                        $                       ...............***\n" +
				"             $**.....    ...                                               ................***$\n" +
				"             $**.....     .                                                .................**$\n" +
				"            $**......                                                     ..................*****$\n" +
				"            $**.....                                                     ...................******$\n" +
				"           $**......                                                    .....................*****$\n" +
				"           $**......                                                   ......................******$\n" +
				"          $**.......                                                  .......................*******$\n" +
				"          $**........                                               .........................********$\n" +
				"         $**.........                                             ..........................**********$\n" +
				"         $**.........                                           ............................**********$\n" +
				"         $**.........                                         ..............................***********$\n" +
				"        $***.........                                      ................................*************$\n" +
				"        $****........                                   ...................................*************$\n" +
				"        $****........                                ......................................**************$   ****\n" +
				"        $****.........                            ........................................****************$ **** *\n" +
				"       $$$***.........                          ..........................................****$$$$$$$$$$$$$**** * *\n" +
				"       $$$$$$$........                        .........................................$$$$$$$$$$$$$$$$$$$$$** * * *\n" +
				"       $$$$$$$$$......                     ....................................$$$$$$$$$$$$$$$$$$$$********$ *** ***\n" +
				"       $****$$$$$$$$...                 ...................................$$$$$$$$$$$$$$$$$.**************$ *** *\n" +
				"       $****..$$$$$$$$$$             ..................................$$$$$$$$$$$$$$$$.......*************$ ** **\n" +
				"       $****.....$$$$$$$$$$$$$     .............................$$$$$$$$$$$$$$$$$$$...........**************$ **\n" +
				"       $****.......$$$$$$$$$$$$$$$$$...................$$$$$$$$$$$$$$$$$$$$$$$$...............**************$ **\n" +
				"       $***...........$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$   $$$$$$$$$$$$..................*************$ *\n" +
				"       $***........  ...$$$$$$$$$$$$  $$$$ $$$$$$$$$$$$$$$     $$$$$$$$$$$.....................*************$ *\n" +
				"       $***........    ...$$$$$$$$$ $ $$$  $$$ $$$$$ $$$   $ $$$$$$$$$$$.......................*************$* *\n" +
				"       $***........      ....$$$$$ $$ $$ $ $$$ $$$$$ $$$$$$$ $$$$$$$$$.........................************* * *\n" +
				"       $**.........         ...$$ $$$ $ $$ $$$ $$$$$ $$$$$$$ $$$$$$....      ...................***********$ * *\n" +
				"       $**........            ..$$$$$  $$$ $$$ $$$$$ $$$$$$$ $$$$....          .................***********$ * *\n" +
				"       $**........             ..$$$$ $$$$ $$$       $$$$$$$ $$....             ................***********$ * *\n" +
				"       $**........              ..$$$$$$$$ $$$ $$$$$ $$$$$$$$$....              ................**********$  * *\n" +
				"       $**........               ..$$$$$$$ $$$ $$$$$ $$$$$$$....                ................**********$  * *\n" +
				"       $**........                ...$$$$$ $$$ $$$$$ $$$$$$....                  ...............**********$  * *\n" +
				"       $***.......                ....$$$$$$$$ $$$$$ $$$$$....                   ...............**********$  *  *\n" +
				"       $***........                ..*.$$$$$$$ $$$$$ $$$.....                    ...............**********$  *  *\n" +
				"        $**........                 ..**.$$$$$$$$$$$$$$.....                     ................*********$  *  *\n" +
				"        $**........                 ...**.$$$$$$$$$$$$.....                      ................*********$  *   *\n" +
				"        $**........                 ....***.$$$$$$$$$.....                       ................*********$   *\n" +
				"        $***.......                 .....****..$$$$$.....                        ...............*********$    *\n" +
				"         $**.......                 ......*****...$.....                          ..............*********$     *\n" +
				"         $**.......                 ......*******$.....                           ..............*********$\n" +
				"         $***......                  ......******$.....                           ..............*********$\n" +
				"          $**.......                 ......*****$......                           ..............*********$\n" +
				"          $**.......                 ......*****$......                            ..............********$\n" +
				"          $**.......                 ......****$......                             ..............********$\n" +
				"          $***......                 ......****$......                             .............*********$\n" +
				"           $**.......                 .....****$......                             .............********$\n" +
				"           $**.......                 .....***$......                             ..............********$\n" +
				"           $***......                 .....***$......                             ..............********$\n" +
				"            $**......                 .....***$......                             ..............*******$\n" +
				"            $**.......                .....***$......                             .............********$\n" +
				"            $**.......                .....***$......                             .............********$\n" +
				"            $***......                .....***$.....                             ..............*******$\n" +
				"             $**......                .....***$.....                             ..............*******$\n" +
				"             $**......                 ....***$.....                             .............*******$\n" +
				"             $**.......                ....***$.....                             .............*******$\n" +
				"             $**.......                ....***$.....                            ..............******$\n" +
				"             $***......                .....**$.....                            .............*******$\n" +
				"              $**......                .....**$....                             .............*******$\n" +
				"              $**......                .....**$....                             .............******$\n" +
				"              $***......               .....**$....                            .............*******$\n" +
				"               $**......                ....**$....                            .............******$\n" +
				"               $***.....                ....**$....                            .............******$\n" +
				"                $**......               ....**$....                           .............******$\n" +
				"                $**......               ....**$.....                          .............******$\n" +
				"                $***.....               ....**$.....                          .............*****$\n" +
				"                 $**......               ....**$....                          ............******$\n" +
				"                 $***.....               ....**$....                         .............******$\n" +
				"                  $***....               ....**$....                         .............*****$\n" +
				"                   $**.....              ....**$....                         ............******$\n" +
				"                   $***....               ...**$....                         ............*****$\n" +
				"                    $**.....              ...**$....                         ...........******$\n" +
				"                    $***.....             ...**$....                         ...........*****$\n" +
				"                     $***.....            ....*$....                         ...........*****$\n" +
				"                      $**.....             ...*$....                        ...........*****$\n" +
				"                      $**......            ...*$....                        ...........*****$\n" +
				"                      $***......           ...*$....                        ..........*****$\n" +
				"                       $**......           ....*$...                        ..........*****$\n" +
				"                       $***......           ...*$...                       ...........****$\n" +
				"                        $**......           ...*$...                       ..........*****$\n" +
				"                        $***......          ...*$...                       ..........****$\n" +
				"                         $**......          ...*$...                       ..........****$\n" +
				"                         $***.....          ...*$...                       .........*****$\n" +
				"                          $**......         ...*$...                      ..........****$\n" +
				"                          $***.....          ..*$....                     ..........****$\n" +
				"                           $**.....          ...*$...                     .........****$\n" +
				"                           $***....           ..*$...                    ..........****$\n" +
				"                            $**.....          ...$...                    .........****$\n" +
				"                            $***....          ...$...                    .........****$\n" +
				"                             $**.....         ...$...                   ..........***$\n" +
				"                             $***....          ..$...                   .........****$\n" +
				"                              $**.....         ..$...                   .........***$\n" +
				"                              $***....         ..$...                   .........***$\n" +
				"                               $**.....        ...$..                  .........***$\n" +
				"                               $***....         ..$..                 ..........***$\n" +
				"                                $**.....        ..$..                 ..........***$\n" +
				"                                $***....        ..$..                 ..........**$\n" +
				"                                 $**.....       ..$...               ...........**$\n" +
				"                                  $**....       ..$...               ..........***$\n" +
				"                                  $**.....       .$...               ..........**$\n" +
				"                                  $***....       .$...               ..........**$\n" +
				"                                   $**....       .$...              ...........**$\n" +
				"                                   $**....        $...              ...........*$\n" +
				"                                   $***....        $..              ...........*$\n" +
				"                                    $**....        $...            ............*$\n" +
				"                                    $**....        .$..            ............*$\n" +
				"                                    $**....        .$..            ..**........*$\n" +
				"                                    $**....        .$...           ..***.......*$\n" +
				"                                     $**...        ..$..           ..***.......*$\n" +
				"                                     $**...         .$...          ..***.......*$\n" +
				"                                      $**...        ..$..           ..**.......**$\n" +
				"                                      $**...        ..$..           ...**......**$\n" +
				"                                      $**...        ..$..            ..........**$\n" +
				"                                      $**...         ..$..            .........***$\n" +
				"                                       $*...         ..$..            .........***$\n" +
				"                                       $*...         ..$...            ........****$\n" +
				"                                       $*...         ...$..            .........***$\n" +
				"                                       $*...          ..$..             ........****$\n" +
				"                                       $*....         ..$...            ........****$\n" +
				"                                       $**...         ...$..            .........****$\n" +
				"                                        $*...          ..$..             ........****$\n" +
				"                                        $*...          ..$..             ........*****$\n" +
				"                                        $*...          ..$...            .........****$\n" +
				"                                        $*...          ...$..            .........****$\n" +
				"                                        $*....          ..$..             ........*****$\n" +
				"                                        $**...          ..$..             .........****$\n" +
				"                                         $*...          ..$..             .........****$\n" +
				"                                         $*...          ..$..             .........*****$\n" +
				"                                         $**...         ..$...            .........*****$\n" +
				"                                          $*...         ..$...            .........*****$\n" +
				"                                          $*...         ..$...             ........*****$\n" +
				"                                          $**...        ...$..             ........******$\n" +
				"                                           $*...         ..$..             .........*****$\n" +
				"                                           $*...         ..$...            .........*****$\n" +
				"                                           $*....        ..$...             ........*****$\n" +
				"                                           $**...        ...$..             ........*****$\n" +
				"                                            $*...         ..$...            ........******$\n" +
				"                                            $*....        ..$...            ........******$\n" +
				"                                            $**...        ...$..            ........******$\n" +
				"                                             $*....        ..$...           ........******$\n" +
				"                                             $**...        ..$...           ........******$\n" +
				"                                              $*...        ...$..            .......******$\n" +
				"                                              $*...         ..$...           .......******$\n" +
				"                                              $*....        ..$...           .......******$\n" +
				"                                               $*...        ...$..           .......******$\n" +
				"                                               $*...         ..$...          .......******$\n" +
				"                                                $*...        ..$...          .......******$\n" +
				"                                                $*...        ...$..          .......******$\n" +
				"                                                $*....        ..$..           .......*****$\n" +
				"                                                 $*...        ..$...          .......*****$\n" +
				"                                                 $*...         ..$...         .......*****$\n" +
				"                                                  $....        ...$..         .......*****$\n" +
				"                                                   $...         ..$..         .......*****$\n" +
				"                                                   $...         ..$...         ......*****$\n" +
				"                                                    $..         ...$..         ......****$\n" +
				"                                                    $...         ..$...        ......****$\n" +
				"                                                     $...        ..$...        ......****$\n" +
				"                                                      $..        ...$..        ......****$\n" +
				"                                                      $...        ..$...        .....****$\n" +
				"                                                       $..        ..$...        .....***$\n" +
				"                                                       $...       ...$..        .....***$\n" +
				"                                                        $..        ..$...       .....***$\n" +
				"                                                        $...       ..$...       ......**$\n" +
				"                                                         $..       ...$..        .....**$\n" +
				"                                                         $..        ..$..        .....**$\n" +
				"                                                         $...       ..$...       .....*$\n" +
				"                                                          $..       ..$...       .....*$\n" +
				"                                                          $..       ...$..       .....*$\n" +
				"                                                          $..        ..$..        ....*$\n" +
				"                                                          $..        ..$..        ....*$\n" +
				"                                                          $...       ..$..        ....*$\n" +
				"                                                           $..       ..$..        ....*$\n" +
				"                                                           $..       ..$..        ....*$\n" +
				"                                                           $..       ..$..        ....*$\n" +
				"                                                           $..       ..$..         ...*$\n" +
				"                                                           $..       ..$..         ...*$\n" +
				"                                                           $..       ..$...        ...*$\n" +
				"                                                           $..       ..$...        ...*$\n" +
				"                                                           $..       ...$..         ..*$\n" +
				"                                                           $..       ...$..         ..*$\n" +
				"                                                           $..       ...$..         ..*$\n" +
				"                                                           $..       ...$..         ..*$\n" +
				"                                                           $..       ...$..         ...$\n" +
				"                                                          $..       ....$..         ....$\n" +
				"                                                          $..       ....$..          ...$\n" +
				"                                                          $..       ....$..          ...$\n" +
				"                                                          $.        ....$..          ...$\n" +
				"                                                         $..        .....$.           ...$\n" +
				"                                                         $.         .....$.            ..$\n" +
				"                                                        $..        ......$$             ..$\n" +
				"                                                        $..        .....$$.$            ..$\n" +
				"                                                       $..         ....$ $..             ..$\n" +
				"                                                       $..        ....$  $ ..             ..$\n" +
				"                                                      $..         ....$  $  ..            ...$\n" +
				"                                                      $..         ...$    $                ..$\n" +
				"                                                     $..         ....$     $                ..$\n" +
				"                                                     $..         ...$       $.               ..$\n" +
				"                                                    $..         ....$        $.               ..$\n" +
				"                                                   $..          ...$          $.               .\n" +
				"                                                  $...         ...$            $.              .$\n" +
				"                                                 $...          ...$             $.             ..$\n" +
				"                                                $....         ...$               $.             ..$\n" +
				"                                                $....         ...$                $.             ..$\n" +
				"                                               $.....         ..$                 $..               .$\n" +
				"                                               $..*.* *  *   ..$                   $..               .$\n" +
				"                                              $--*.*.*  *   ..$                    $..                .$\n" +
				"                                              $ *-*-*--*---..$                      $..                .$\n" +
				"                                               $ *  * *   /.$                        $..                .$\n" +
				"                                                $$$$$$$$$$$$                         $..                 .$\n" +
				"                                                                                      $..                 $\n" +
				"                                                                                       $..              *  $\n" +
				"                                                                                        $..          *   */$\n" +
				"                                                                                         $..       *  *  /*$\n" +
				"                                                                                          $.        *  *1 $\n" +
				"                                                                                          $..   *   /*/ *$\n" +
				"                                                                                           $..   * / *1$$\n" +
				"                                                                                            $..  /*1 $$\n" +
				"                                                                                             $../ $$$\n" +
				"                                                                                              $.1 $\n" +
				"                                                                                               $$$\n" +
				"(Source: http://www.textfiles.com/art/ASCIIPR0N/pinup28.txt)"
			);

			sleep();

			logger.debug(ASCII_MARKER,
				"         ../MMMMMMM\\\n" +
				"      ./MMMMMMMMMMMMM\\\n" +
				"    /MMMMMMMMMMMMMMMMM\\\n" +
				"   /MMMMMMMMMMMMMMMMMMM\\\n" +
				"  /MMMMMMMMMMMMMMMMMMMMM\\\n" +
				" |MMMMMMMMMMMMMMMMMMMMMMM\n" +
				" |MMMMMMMMMMMMMMMMMMMMMMM\n" +
				"  |MMM/.......\\MMMMMMMMMM|\n" +
				"   \\ \".........\\MMMMMMM-\"|\n" +
				"    ) \".. ___..   \\MM/..||\n" +
				"    . _./||||      \\\\.I.|:\\\n" +
				"     \\||||HHH:::`.....(::..\\\n" +
				"      `||HH:::::............\\\n" +
				"       ||:.:::::: .......|...\\\n" +
				"       ||') .::::..............:\\_____\n" +
				"         \\`  ::)..... /|. |......      `   __\n" +
				"           //::::::. /:||\\:........-.......:::|\\\n" +
				"            \\ \\::: /::|::|:::/............  ...:|\\\n" +
				"            /-----:::|...:|\\|.............    ..:|\n" +
				"           /...:.-::- ......\\:............    ...:\\\n" +
				"         /    ................\\:..................:|\n" +
				"        /   _ .................\\.................:||\n" +
				"     _/    .....................:.............\\:: :|\\\n" +
				"    / ...........................\\........  ..::::::|\\\n" +
				"   / .......   ...................\\......   ..::|:.::|\\\n" +
				"  /  ......     ..................:...     ...::....|||\n" +
				" /  .::....  ......   .............\\..    ....::|...|::\\\n" +
				" |  :::...  ........       . ......:  ....   :M@|.....:|\\\n" +
				" | .::: ..... |:: .....       ..... .L\\:::|||||||......:|\\\n" +
				" | .:::......:|:::::....      .... /... .\\::|||:/|`.....:|\n" +
				" | .:::....:::||::::::::::'..... /..... ...:: :(||:'  `...\\\n" +
				" `| .::: ::: ||||:::V@K:|||||:/.     ..  :::  :|| \\::::...|\n" +
				"  |\\:::.     |||||||||||||::/.   :    |.. . ...:|\\ \\:::`...\\\n" +
				"  |.\\:::.   .|\\|||:::::.......  ::.   |..  ..::|| \\ \\:/.....\\\n" +
				"  :.:.::..  .| \\|| :::::....\\:.. .. : .\\...::||:| |  / .....|\n" +
				" /.::.....  .|`  \\|::::::....\\:||..  ..|...|: .:| |    .....:\\\n" +
				" |||: .... ..| \\   \\:.::::...   .||||||:\\..   .:| |   \\... ..|\n" +
				" |||: ...  ..|  \\    \\::::`...  .       :\\.   .:. |    \\..  .|\n" +
				" |||::...... /    \\   \\:::: ..    :     .:\\  .::.\\ \\    .   .:\\\n" +
				" | ||:.......'     `\\  :::'...: ||. :   .:| .::.|.\\ \\   |  . .|\n" +
				" | .::......|        \\ \\.:...:. |.:||||| .::....|..\\ `  |.  ..|\n" +
				" | . .  . ..|         | :.:.:... |.:     .( ....:|.\\  | |.....|\n" +
				" | ::.  \\\\..|         | :' .:... |:..    .... ...|..| |  :...|'\n" +
				" | |:.  .:.\\|         |  :::.:... |::.  ........:|..| |  ....|\n" +
				" `||..\\  \\|:|          / \\::: :\\....||:...........|.| | :/  )|\n" +
				"  |||:.. .\\:|         /   .|||:|\\..................:| |:/ ./ |\n" +
				"  |:|::\\  ..|        /   .|::|||:|\\................:| |(::/..|\n" +
				"  | :::.\\ ..|       '   .|::`:....:\\..............|:|(. .|  \\ \\\n" +
				"  | :::..  ..|     |    ||:........:\\.............|(:.\\:.:\\  \\ |\n" +
				"  \\ .|:..| ..|     |    |...........::............(:::::`  `\\__|\n" +
				"  ` ::|:.|...|     |    \\`..............:........ ::`\\::::\\::`)\n" +
				"   \\ : |:|  ..|    |     :..............:...:||`/'  \\::`\\:::)\n" +
				"    \\::..| ...|    |     :'...   .........:|/'       \\:::)\n" +
				"    ||::.|....|    |     ::.... .......:|/'           |  \\\n" +
				"     \\|: \\. ..|    |     :..... ...... /              |   \\\n" +
				"      \\|: \\.  .    |    .:.....  .../               .|     \\\n" +
				"       \\|:'\\   \\   |    :...... .:/                 :|      |\n" +
				"       `.::-..  \\  |   ........//                   .|      |\n" +
				"        \\ ::..   '\\___.:.....:/                     :|      |\n" +
				"         \\\\.....  ::..:`\\. /'                      .|      /\n" +
				"(Source: http://www.asciipr0n.com/pr0n/hunky/hunky08.txt)"
			);

			sleep();

			logger.debug(ASCII_MARKER,
				"                    _____\n" +
				"               ,---';;;;;`--.\n" +
				"             ,';;;;;; '''''''`-,\n" +
				"            ; ;;;;,,;;;;;;;;;;;`;\n" +
				"           ` ;;; ; ;;;;;;;;,-'`-;\n" +
				"           ` ;;;;' ;;; ;;;; ,-'~\n" +
				"       /\\  /\\ ;'  ;;;;;;; ,-'\n" +
				"      ,--`/ ^;    ;:;;;;  ;\n" +
				"    .'        `.   ;;;;;  `.\n" +
				"   ,' (O)       ;  ;; ;;;; `.\n" +
				"  (v}'         ,' ; ;; ;;;; `.\n" +
				"   `-.--'   _,'`.  :;;;  ;;; :\n" +
				"  _._ ~`---' ,-  `.`.;;;;;; ;`.\n" +
				" /___\\ ;   ,'     :  . ;; ;; ;;\n" +
				"c|##c==-.__;      `-. ; ;;;;; ;\n" +
				"c:##c==,_  `    ,'  `-.;;;;;;;;\n" +
				" `----'  `------',    `.; ;;;;;\n" +
				"      :     __,----. , `.;;;;;\n" +
				"    ,'`.  ,' ,     ' `  ;;;;;\n" +
				"    :  `.,' ,`       , ,';;\n" +
				"    `._  : ,`       ,_,,'\n" +
				" __,-' `-`_`   ____,-'\n" +
				"Ccc_,----'_`--'   _)\n" +
				"       CCcc_,----'\n"
			);
		}
	}
}
