/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.logback.appender;

import ch.qos.logback.classic.spi.LoggingEvent;
import de.huxhorn.lilith.data.logging.json.LoggingJsonEncoder;
import de.huxhorn.lilith.data.logging.logback.TransformingEncoder;
import de.huxhorn.lilith.logback.appender.MultiplexSocketAppenderBase;
import de.huxhorn.sulky.codec.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassicJsonMultiplexSocketAppender
extends MultiplexSocketAppenderBase<LoggingEvent> {
    public static final int COMPRESSED_DEFAULT_PORT = 10030;
    public static final int UNCOMPRESSED_DEFAULT_PORT = 10031;
    private boolean includeCallerData;
    private boolean compressing;
    private boolean usingDefaultPort = true;
    private TransformingEncoder transformingEncoder = new TransformingEncoder();

    public ClassicJsonMultiplexSocketAppender() {
        this(true);
    }

    public ClassicJsonMultiplexSocketAppender(boolean compressing) {
        this.setEncoder((Encoder)this.transformingEncoder);
        this.setCompressing(compressing);
        this.includeCallerData = false;
    }

    protected void applicationIdentifierChanged() {
        this.transformingEncoder.setApplicationIdentifier(this.getApplicationIdentifier());
    }

    protected void uuidChanged() {
        this.transformingEncoder.setUUID(this.getUUID());
    }

    public void setPort(int port) {
        super.setPort(port);
        this.usingDefaultPort = false;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
        if (this.usingDefaultPort) {
            if (compressing) {
                this.setPort(10030);
            } else {
                this.setPort(10031);
            }
            this.usingDefaultPort = true;
        }
        this.transformingEncoder.setLilithEncoder((Encoder)new LoggingJsonEncoder(compressing));
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public boolean isIncludeCallerData() {
        return this.includeCallerData;
    }

    public void setIncludeCallerData(boolean includeCallerData) {
        this.includeCallerData = includeCallerData;
    }

    protected void preProcess(LoggingEvent event) {
        if (event != null && this.includeCallerData) {
            event.getCallerData();
        }
    }
}

