/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle;

import de.akquinet.jbosscc.needle.reflection.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NeedleContext {
    private final Object test;
    private final Map<String, Object> objectUnderTestMap = new HashMap<String, Object>();
    private final Map<Object, Object> injectedObjectMap = new HashMap<Object, Object>();
    private final Map<Class<? extends Annotation>, List<Field>> annotatedTestcaseFieldMap;

    public NeedleContext(Object test) {
        this.test = test;
        this.annotatedTestcaseFieldMap = ReflectionUtil.getAllAnnotatedFields(test.getClass());
    }

    public Object getTest() {
        return this.test;
    }

    public <X> X getInjectedObject(Object key) {
        return (X)this.injectedObjectMap.get(key);
    }

    public Collection<Object> getInjectedObjects() {
        return this.injectedObjectMap.values();
    }

    public void addInjectedObject(Object key, Object instance) {
        this.injectedObjectMap.put(key, instance);
    }

    public Object getObjectUnderTest(String id) {
        return this.objectUnderTestMap.get(id);
    }

    public void addObjectUnderTest(String id, Object instance) {
        this.objectUnderTestMap.put(id, instance);
    }

    public Collection<Object> getObjectsUnderTest() {
        return this.objectUnderTestMap.values();
    }

    public List<Field> getAnnotatedTestcaseFields(Class<? extends Annotation> annotationClass) {
        ArrayList value = this.annotatedTestcaseFieldMap.get(annotationClass);
        return value != null ? value : new ArrayList();
    }
}

