/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.junit.internal;

import com.tngtech.archunit.ArchConfiguration;

final class DisplayNameResolver {
    static final String JUNIT_DISPLAYNAME_REPLACE_UNDERSCORES_BY_SPACES_PROPERTY_NAME = "junit.displayName.replaceUnderscoresBySpaces";

    DisplayNameResolver() {
    }

    static String determineDisplayName(String elementName) {
        return DisplayNameResolver.replaceUnderscoresBySpaces() ? DisplayNameResolver.underscoresReplacedBySpaces(elementName) : elementName;
    }

    private static String underscoresReplacedBySpaces(String elementName) {
        return elementName.replace('_', ' ');
    }

    private static boolean replaceUnderscoresBySpaces() {
        String replaceUnderscoresBySpaces = ArchConfiguration.get().getPropertyOrDefault(JUNIT_DISPLAYNAME_REPLACE_UNDERSCORES_BY_SPACES_PROPERTY_NAME, Boolean.FALSE.toString());
        return Boolean.parseBoolean(replaceUnderscoresBySpaces);
    }
}

