/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.tables;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.tools.schemaframework.IndexDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexMetadata
extends ORMetadata {
    private Boolean m_unique;
    private String m_name;
    private String m_schema;
    private String m_catalog;
    private String m_table;
    private List<String> m_columnNames = new ArrayList<String>();

    public IndexMetadata() {
        super("<index>");
    }

    public IndexMetadata(MetadataAnnotation index, MetadataAccessor accessor) {
        super(index, accessor);
        if (index != null) {
            this.m_name = (String)index.getAttribute("name");
            this.m_schema = (String)index.getAttribute("schema");
            this.m_catalog = (String)index.getAttribute("catalog");
            this.m_table = (String)index.getAttribute("table");
            this.m_unique = (Boolean)index.getAttribute("unique");
            Object[] objectArray = (Object[])index.getAttributeArray("columnNames");
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object columnName = objectArray[n2];
                this.m_columnNames.add((String)columnName);
                ++n2;
            }
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof IndexMetadata) {
            IndexMetadata table = (IndexMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_name, table.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_schema, table.getSchema())) {
                return false;
            }
            if (!this.valuesMatch(this.m_catalog, table.getCatalog())) {
                return false;
            }
            return this.m_columnNames.equals(table.getColumnNames());
        }
        return false;
    }

    public String getCatalog() {
        return this.m_catalog;
    }

    public List<String> getColumnNames() {
        return this.m_columnNames;
    }

    @Override
    protected String getIdentifier() {
        return this.getName();
    }

    public String getName() {
        return this.m_name;
    }

    public String getSchema() {
        return this.m_schema;
    }

    public String getTable() {
        return this.m_table;
    }

    public Boolean getUnique() {
        return this.m_unique;
    }

    public void process(MetadataDescriptor descriptor, String defaultColumnName) {
        IndexDefinition indexDefinition = new IndexDefinition();
        if (this.m_columnNames.isEmpty() && defaultColumnName != null) {
            indexDefinition.getFields().add(defaultColumnName);
        } else {
            indexDefinition.getFields().addAll(this.m_columnNames);
        }
        if (this.m_name != null && this.m_name.length() != 0) {
            indexDefinition.setName(this.m_name);
        } else {
            String name = "INDEX_" + descriptor.getPrimaryTableName();
            for (String column : indexDefinition.getFields()) {
                name = String.valueOf(name) + "_" + column;
            }
            indexDefinition.setName(name);
        }
        if (this.m_schema != null && this.m_schema.length() != 0) {
            indexDefinition.setQualifier(this.m_schema);
        } else if (descriptor.getDefaultSchema() != null && descriptor.getDefaultSchema().length() != 0) {
            indexDefinition.setQualifier(descriptor.getDefaultSchema());
        }
        if (this.m_catalog != null && this.m_catalog.length() != 0) {
            indexDefinition.setQualifier(this.m_catalog);
        } else if (descriptor.getDefaultCatalog() != null && descriptor.getDefaultCatalog().length() != 0) {
            indexDefinition.setQualifier(descriptor.getDefaultCatalog());
        }
        if (this.m_unique != null) {
            indexDefinition.setIsUnique(this.m_unique);
        }
        if (this.m_table == null || this.m_table.length() == 0) {
            indexDefinition.setTargetTable(descriptor.getPrimaryTable().getQualifiedName());
            descriptor.getPrimaryTable().getIndexes().add(indexDefinition);
        } else if (this.m_table.equals(descriptor.getPrimaryTable().getQualifiedName()) || this.m_table.equals(descriptor.getPrimaryTableName())) {
            indexDefinition.setTargetTable(this.m_table);
            descriptor.getPrimaryTable().getIndexes().add(indexDefinition);
        } else {
            indexDefinition.setTargetTable(this.m_table);
            boolean found = false;
            for (DatabaseTable databaseTable : descriptor.getClassDescriptor().getTables()) {
                if (!this.m_table.equals(databaseTable.getQualifiedName()) && !this.m_table.equals(databaseTable.getName())) continue;
                databaseTable.getIndexes().add(indexDefinition);
                found = true;
            }
            if (!found) {
                descriptor.getPrimaryTable().getIndexes().add(indexDefinition);
            }
        }
    }

    public void setUnique(Boolean unique) {
        this.m_unique = unique;
    }

    public void setColumnNames(List<String> columnNames) {
        this.m_columnNames = columnNames;
    }

    public void setCatalog(String catalog) {
        this.m_catalog = catalog;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setSchema(String schema) {
        this.m_schema = schema;
    }

    public void setTable(String table) {
        this.m_table = table;
    }
}

