/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.jcdi;

import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.server.impl.jcdi.JCDIComponentProviderFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JCDIComponentProviderFactoryInitializer {
    private static final Logger LOGGER = Logger.getLogger(JCDIComponentProviderFactoryInitializer.class.getName());

    public static void initialize(ResourceConfig rc) {
        try {
            Object beanManager = new InitialContext().lookup("java:comp/BeanManager");
            if (beanManager == null) {
                LOGGER.config("The JCDI BeanManager is not available. JAX-RS JCDI support is disabled.");
                return;
            }
            rc.getSingletons().add(new JCDIComponentProviderFactory(beanManager));
        }
        catch (NamingException ex) {
            LOGGER.log(Level.CONFIG, "The JCDI BeanManager is not available. JAX-RS JCDI support is disabled.", ex);
        }
    }
}

