/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.oauth.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class NonceManager {
    private final long maxAge;
    private final int gcPeriod;
    private int gcCounter = 0;
    private final Map<String, Map<Long, Set<String>>> map = new HashMap<String, Map<Long, Set<String>>>();
    private final SortedMap<Long, String> tsIndex = new TreeMap<Long, String>();

    public NonceManager(long maxAge, int gcPeriod) {
        if (maxAge <= 0L || gcPeriod <= 0) {
            throw new IllegalArgumentException();
        }
        this.maxAge = maxAge;
        this.gcPeriod = gcPeriod;
    }

    public synchronized boolean verify(String key, String timestamp, String nonce) {
        Set<String> nonces;
        long now = System.currentTimeMillis();
        long stamp = NonceManager.longValue(timestamp) * 1000L;
        if (stamp + this.maxAge < now) {
            return false;
        }
        Map<Long, Set<String>> timestamps = this.map.get(key);
        if (timestamps == null) {
            timestamps = new HashMap<Long, Set<String>>();
            this.map.put(key, timestamps);
        }
        if ((nonces = timestamps.get(stamp)) == null) {
            nonces = new HashSet<String>();
            timestamps.put(stamp, nonces);
            this.tsIndex.put(stamp, key);
        }
        boolean result = nonces.add(nonce);
        if (++this.gcCounter >= this.gcPeriod) {
            this.gcCounter = 0;
            SortedMap<Long, String> toCollect = this.tsIndex.headMap(now - this.maxAge);
            for (Map.Entry<Long, String> entry : toCollect.entrySet()) {
                this.map.get(entry.getValue()).remove(entry.getKey());
            }
            toCollect.clear();
        }
        return result;
    }

    private static long longValue(String value) {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            return -1L;
        }
    }
}

